/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.util.MathUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Path2D;

public class ProgressRectanglePainter {
    private float percentComplete;
    private Rectangle controlRectangle;
    private Insets insets;
    private Color fillColor = Color.WHITE;
    private Color outlineColor = Color.BLACK;

    public ProgressRectanglePainter() {
        this.controlRectangle = new Rectangle(0, 0, 100, 100);
        this.insets = new Insets(0, 0, 0, 0);
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public void paint(Graphics2D g2) {
        int wholeSides = (int)this.percentComplete / 25;
        float lastSideFraction = this.percentComplete % 25.0f / 25.0f;
        Point[] outerCorners = new Point[]{new Point(this.controlRectangle.x, this.controlRectangle.y + this.controlRectangle.height), new Point(this.controlRectangle.x + this.controlRectangle.width, this.controlRectangle.y + this.controlRectangle.height), new Point(this.controlRectangle.x + this.controlRectangle.width, this.controlRectangle.y), new Point(this.controlRectangle.x, this.controlRectangle.y)};
        Point[] innerEdgeOffsets = new Point[]{new Point(0, -this.insets.bottom), new Point(-this.insets.right, 0), new Point(0, this.insets.top), new Point(this.insets.left, 0)};
        for (int i = 0; i < 4; ++i) {
            if (wholeSides < i) continue;
            Point thisEdgeOffset = innerEdgeOffsets[i];
            Point lastEdgeOffset = innerEdgeOffsets[(i + 3) % 4];
            Point nextEdgeOffset = innerEdgeOffsets[(i + 1) % 4];
            Point outerEdgeStart = new Point(outerCorners[i]);
            Point outerEdgeStart2 = new Point(outerEdgeStart);
            outerEdgeStart2.translate(lastEdgeOffset.x, lastEdgeOffset.y);
            Point outerEdgeEnd = new Point(outerCorners[(i + 1) % 4]);
            outerEdgeEnd.translate(nextEdgeOffset.x, nextEdgeOffset.y);
            if (wholeSides == i) {
                float sideFraction = wholeSides > i ? 1.0f : lastSideFraction;
                outerEdgeEnd = new Point((int)MathUtils.interpolate(sideFraction, outerEdgeStart2.x, outerEdgeEnd.x), (int)MathUtils.interpolate(sideFraction, outerEdgeStart2.y, outerEdgeEnd.y));
            }
            Point innerEdgeStart = new Point(outerEdgeStart);
            innerEdgeStart.translate(thisEdgeOffset.x, thisEdgeOffset.y);
            Point innerEdgeStart2 = new Point(outerEdgeStart2);
            innerEdgeStart2.translate(thisEdgeOffset.x, thisEdgeOffset.y);
            Point innerEdgeEnd = new Point(outerEdgeEnd);
            innerEdgeEnd.translate(thisEdgeOffset.x, thisEdgeOffset.y);
            Path2D.Float fillShape = new Path2D.Float();
            ((Path2D)fillShape).moveTo(outerEdgeEnd.x, outerEdgeEnd.y);
            ((Path2D)fillShape).lineTo(outerEdgeStart.x, outerEdgeStart.y);
            ((Path2D)fillShape).lineTo(innerEdgeStart.x, innerEdgeStart.y);
            ((Path2D)fillShape).lineTo(innerEdgeEnd.x, innerEdgeEnd.y);
            fillShape.closePath();
            Color oldColor = g2.getColor();
            if (this.fillColor != null) {
                g2.setColor(this.fillColor);
            }
            g2.fill(fillShape);
            if (this.outlineColor != null) {
                g2.setColor(this.outlineColor);
            }
            g2.drawLine(innerEdgeStart.x, innerEdgeStart.y, outerEdgeStart.x, outerEdgeStart.y);
            g2.drawLine(outerEdgeStart.x, outerEdgeStart.y, outerEdgeEnd.x, outerEdgeEnd.y);
            if (i == 0 && this.percentComplete < 100.0f) {
                g2.drawLine(innerEdgeStart.x, innerEdgeStart.y, innerEdgeEnd.x, innerEdgeEnd.y);
            } else {
                g2.drawLine(innerEdgeStart2.x, innerEdgeStart2.y, innerEdgeEnd.x, innerEdgeEnd.y);
            }
            if (wholeSides == i) {
                g2.drawLine(innerEdgeEnd.x, innerEdgeEnd.y, outerEdgeEnd.x, outerEdgeEnd.y);
            }
            g2.setColor(oldColor);
        }
    }

    public void setPercentComplete(float percentComplete) {
        this.percentComplete = percentComplete;
    }

    public void setControlRectangle(Rectangle rectangle) {
        assert (rectangle != null) : "rectangle is null";
        this.controlRectangle = rectangle;
    }

    public void setInsets(Insets insets) {
        assert (insets != null) : "insets is null";
        this.insets = insets;
    }
}

