/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.animation.InterpolationFunction;
import com.sodiumarc.patchwork.app.scenecomposer.model.GridDirection;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridCoords;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.PlayingGridLayout;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.ProgressRectanglePainter;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.ShelfCoords;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class PlayingGridPainter {
    private final PlayingGridLayout layout;
    private final Container container;
    private final boolean editMode;
    private final ProgressRectanglePainter borderPainter;
    private float fractionComplete;
    private GridCoords selectedGridCoords;
    private ShelfCoords selectedShelfCoords;
    private InterpolationFunction interpFunc;
    private static final Color BOUNDARY_LINE_COLOR = new Color(200, 200, 200);
    private static final Color SHELF_BORDER_COLOR = new Color(200, 200, 200);
    private static final Color INSERT_ARROW_COLOR = new Color(230, 240, 250);
    private static final Color DELETE_BUTTON_COLOR = new Color(180, 200, 225);

    public PlayingGridPainter(PlayingGridLayout layout, Container container, boolean editMode) {
        this.layout = layout;
        this.container = container;
        this.editMode = editMode;
        this.borderPainter = new ProgressRectanglePainter();
        this.selectedGridCoords = new GridCoords(0, 0);
        this.setFractionComplete(0.0f);
    }

    public void setSelectedGridCoords(GridCoords selectedGridCoords) {
        this.selectedGridCoords = selectedGridCoords;
        this.selectedShelfCoords = null;
    }

    public void setSelectedShelfCoords(ShelfCoords selectedShelfCoords) {
        this.selectedShelfCoords = selectedShelfCoords;
        this.selectedGridCoords = null;
    }

    public void paint(Graphics2D g) {
        int col;
        float adjustedFraction;
        float startDelay;
        Point to;
        Point from;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.container.getWidth(), this.container.getHeight());
        float fractionComplete = this.getAdjustedFractionComplete();
        Color gridBGColor = ColorUtils.blend(Color.WHITE, PatchworkProject.GRID_BG_COLOR, fractionComplete);
        g.setColor(gridBGColor);
        Rectangle gridBounds = this.layout.getGridBounds(this.container);
        g.fillRect(gridBounds.x, gridBounds.y, gridBounds.width - 1, gridBounds.height - 1);
        g.setColor(BOUNDARY_LINE_COLOR);
        for (int row = 1; row < this.layout.getRows(); ++row) {
            int y = gridBounds.y + row * PatchworkProject.CARD_SIZE;
            from = new Point(gridBounds.x, y);
            to = new Point(gridBounds.x + gridBounds.width, y);
            startDelay = 0.5f - 0.25f / (float)this.layout.getRows() * (float)row;
            adjustedFraction = (float)MathUtils.clamp(MathUtils.rangeFraction(fractionComplete, startDelay, 1.0), 0.0, 1.0);
            this.drawLine(g, to, from, adjustedFraction);
        }
        for (col = 1; col < this.layout.getColumns(); ++col) {
            int x = gridBounds.x + col * PatchworkProject.CARD_SIZE;
            from = new Point(x, gridBounds.y);
            to = new Point(x, gridBounds.y + gridBounds.height);
            startDelay = 0.25f / (float)this.layout.getColumns() * (float)col;
            adjustedFraction = (float)MathUtils.clamp(MathUtils.rangeFraction(fractionComplete, startDelay, 1.0), 0.0, 1.0);
            this.drawLine(g, to, from, adjustedFraction);
        }
        this.borderPainter.setControlRectangle(new Rectangle(gridBounds.x, gridBounds.y, gridBounds.width - 1, gridBounds.height - 1));
        this.borderPainter.paint(g);
        for (col = 0; col < this.layout.getColumns(); ++col) {
            for (int row = 0; row < this.layout.getRows(); ++row) {
                this.paintCellBackground(g, row, col);
            }
        }
    }

    public Rectangle getDeleteButtonBounds(GridCoords coords) {
        Rectangle4d delButtonRect = coords.getCol() == 0 ? (coords.getRow() == 0 ? new Rectangle4d(-0.12, 0.0, 0.06, 0.06) : new Rectangle4d(-0.12, 0.94, 0.06, 0.06)) : (coords.getRow() == 0 ? new Rectangle4d(1.06, 0.0, 0.06, 0.06) : new Rectangle4d(1.06, 0.94, 0.06, 0.06));
        Rectangle cellBounds = this.layout.getCellBounds(this.container, coords);
        Rectangle4d cellRect = new Rectangle4d(cellBounds);
        return cellRect.fromProportional(delButtonRect).asAWTRectangle();
    }

    public void setFractionComplete(float fractionComplete) {
        this.fractionComplete = fractionComplete;
        this.borderPainter.setPercentComplete(this.getAdjustedFractionComplete() * 100.0f);
    }

    public void setInterpFunc(InterpolationFunction interpFunc) {
        this.interpFunc = interpFunc;
    }

    private float getAdjustedFractionComplete() {
        if (this.interpFunc != null) {
            return this.interpFunc.getInterpFraction(this.fractionComplete);
        }
        return this.fractionComplete;
    }

    private void paintCellBackground(Graphics2D g, int row, int col) {
        GridCoords coords = new GridCoords(row, col);
        Rectangle cellBounds = this.layout.getCellBounds(this.container, coords);
        if (this.editMode && coords.equals(this.selectedGridCoords)) {
            this.paintInsertArrow(g, cellBounds);
        }
        if (this.editMode) {
            g.setColor(DELETE_BUTTON_COLOR);
            this.paintDeleteButton(g, this.getDeleteButtonBounds(coords));
        }
    }

    private void paintInsertArrow(Graphics2D g, Rectangle cellBounds) {
        Rectangle4d cellRect = new Rectangle4d(cellBounds);
        g.setColor(INSERT_ARROW_COLOR);
        Point2D.Double[] pointsProportional = new Point2D.Double[]{new Point2D.Double(0.55, 0.5), new Point2D.Double(0.55, 0.4), new Point2D.Double(0.45, 0.4), new Point2D.Double(0.45, 0.5), new Point2D.Double(0.4, 0.5), new Point2D.Double(0.5, 0.6), new Point2D.Double(0.6, 0.5)};
        Polygon arrowShape = new Polygon();
        for (Point2D.Double point : pointsProportional) {
            Point2D.Double proportional = cellRect.fromProportional(point);
            arrowShape.addPoint((int)proportional.x, (int)proportional.y);
        }
        g.fill(arrowShape);
    }

    private void paintDeleteButton(Graphics2D g, Rectangle bounds) {
        Point2D.Double proportional;
        Rectangle4d rect = new Rectangle4d(bounds);
        Point2D.Double[] pointsProportional = new Point2D.Double[]{new Point2D.Double(0.1, 0.0), new Point2D.Double(1.0, 0.9), new Point2D.Double(0.9, 1.0), new Point2D.Double(0.0, 0.1)};
        Polygon strokeShape = new Polygon();
        for (Point2D.Double point : pointsProportional) {
            proportional = rect.fromProportional(point);
            strokeShape.addPoint((int)proportional.x, (int)proportional.y);
        }
        g.fill(strokeShape);
        pointsProportional = new Point2D.Double[]{new Point2D.Double(1.0, 0.1), new Point2D.Double(0.1, 1.0), new Point2D.Double(0.0, 0.9), new Point2D.Double(0.9, 0.0)};
        strokeShape = new Polygon();
        for (Point2D.Double point : pointsProportional) {
            proportional = rect.fromProportional(point);
            strokeShape.addPoint((int)proportional.x, (int)proportional.y);
        }
        g.fill(strokeShape);
    }

    private void drawLine(Graphics2D g, Point from, Point to, float fractionComplete) {
        Point mid = new Point((int)MathUtils.interpolate(fractionComplete, from.x, to.x), (int)MathUtils.interpolate(fractionComplete, from.y, to.y));
        g.drawLine(from.x, from.y, mid.x, mid.y);
    }

    private void paintShelves(Graphics2D g) {
        this.paintShelf(g, GridDirection.EAST);
        this.paintShelf(g, GridDirection.WEST);
    }

    private void paintShelf(Graphics2D g, GridDirection dir) {
        int n = this.layout.getShelfCardCount();
        for (int i = 0; i < n; ++i) {
            Rectangle bounds = this.layout.getShelfCellBounds(this.container, dir, i);
            if (bounds == null) continue;
            if (this.selectedShelfCoords != null && this.selectedShelfCoords.getDir() == dir && this.selectedShelfCoords.getIndex() == i) {
                this.paintInsertArrow(g, bounds);
            }
            g.setColor(SHELF_BORDER_COLOR);
            g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }
}

