/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.scenecomposer.model.GridDirection;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridCoords;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.ShelfCoords;
import com.sodiumarc.patchwork.util.MathUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;

public class PlayingGridLayout
implements LayoutManager {
    private int rows;
    private int cols;
    private final int shelfCellCount;
    private final int margins = 8;
    private final int hGap = 20;
    private final int shelfVGap = 10;
    private final Dimension cardSize;
    private final Dimension shelfCellSize;
    private final Map<Component, GridCoords> componentCoords;
    private final Component[] eastShelfCards;
    private final Component[] westShelfCards;
    private boolean allowGridStretch;

    public PlayingGridLayout(int rows, int cols, int shelfCellCount, Dimension cardSize) {
        if (rows == 0 && cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = rows;
        this.cols = cols;
        this.shelfCellCount = shelfCellCount;
        this.cardSize = cardSize;
        this.eastShelfCards = new Component[shelfCellCount];
        this.westShelfCards = new Component[shelfCellCount];
        this.shelfCellSize = new Dimension(cardSize.width / 4, cardSize.height / 4);
        this.componentCoords = new HashMap<Component, GridCoords>();
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setColumns(int cols) {
        this.cols = cols;
    }

    public int getShelfCardCount() {
        return this.shelfCellCount;
    }

    public boolean isAllowGridStretch() {
        return this.allowGridStretch;
    }

    public void setAllowGridStretch(boolean allowGridStretch) {
        this.allowGridStretch = allowGridStretch;
    }

    public Rectangle getInteriorBounds(Container parent) {
        Insets insets = parent.getInsets();
        int containerWidth = parent.getWidth() - (insets.left + insets.right + 16);
        int containerHeight = parent.getHeight() - (insets.top + insets.bottom + 16);
        return new Rectangle(insets.left + 8, insets.top + 8, containerWidth, containerHeight);
    }

    public Rectangle getGridBounds(Container parent) {
        Rectangle gridBounds;
        Rectangle interiorBounds = this.getInteriorBounds(parent);
        if (!this.allowGridStretch) {
            int gridWidth = this.cols * this.cardSize.width;
            int gridHeight = this.rows * this.cardSize.height;
            gridBounds = new Rectangle(interiorBounds.x + (interiorBounds.width - gridWidth) / 2, interiorBounds.y + (interiorBounds.height - gridHeight) / 2, gridWidth, gridHeight);
        } else {
            gridBounds = interiorBounds.width > interiorBounds.height ? new Rectangle(interiorBounds.x + (interiorBounds.width - interiorBounds.height) / 2, interiorBounds.y, interiorBounds.height, interiorBounds.height) : new Rectangle(interiorBounds.x, interiorBounds.y + (interiorBounds.height - interiorBounds.width) / 2, interiorBounds.width, interiorBounds.width);
        }
        return gridBounds;
    }

    public Rectangle getShelfBounds(Container parent, GridDirection dir) {
        if (dir != GridDirection.EAST && dir != GridDirection.WEST) {
            return null;
        }
        Rectangle gridBounds = this.getGridBounds(parent);
        int height = this.shelfCellSize.height * this.shelfCellCount + 10 * (this.shelfCellCount - 1);
        int x = dir == GridDirection.EAST ? gridBounds.x + gridBounds.width + 20 : gridBounds.x - (this.shelfCellSize.width + 20);
        int y = gridBounds.y + gridBounds.height / 2 - height / 2;
        return new Rectangle(x, y, this.shelfCellSize.width, height);
    }

    public Rectangle getShelfCellBounds(Container parent, GridDirection dir, int index) {
        if (index < 0 || index >= this.shelfCellCount) {
            return null;
        }
        Rectangle shelfBounds = this.getShelfBounds(parent, dir);
        if (shelfBounds == null) {
            return null;
        }
        int y = shelfBounds.y + index * (this.shelfCellSize.height + 10);
        return new Rectangle(shelfBounds.x, y, this.shelfCellSize.width, this.shelfCellSize.height);
    }

    public Rectangle getCellBounds(Container parent, GridCoords coords) {
        Rectangle gridBounds = this.getGridBounds(parent);
        int cellWidth = gridBounds.width / this.cols;
        int cellHeight = gridBounds.height / this.rows;
        return new Rectangle(gridBounds.x + coords.getCol() * cellWidth, gridBounds.y + coords.getRow() * cellHeight, cellWidth, cellHeight);
    }

    public Point getCellLocation(Container parent, GridCoords coords) {
        Rectangle bounds = this.getCellBounds(parent, coords);
        return new Point(bounds.x, bounds.y);
    }

    public GridCoords getCellCoords(Container parent, Point point, boolean includeFractions) {
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                GridCoords coords = new GridCoords(row, col);
                Rectangle cellBounds = this.getCellBounds(parent, coords);
                if (!cellBounds.contains(point)) continue;
                if (includeFractions) {
                    Rectangle nextCellBounds = this.getCellBounds(parent, new GridCoords(coords.getRow() + 1, coords.getCol() + 1));
                    double rowFract = (double)row + MathUtils.rangeFraction(point.y, cellBounds.getY(), nextCellBounds.getY());
                    double colFract = (double)col + MathUtils.rangeFraction(point.x, cellBounds.getX(), nextCellBounds.getX());
                    return new GridCoords(rowFract, colFract);
                }
                return coords;
            }
        }
        return null;
    }

    public GridCoords getClosestCornerCoords(Container parent, Point location) {
        GridCoords closestCoords = null;
        double minDistance = Double.POSITIVE_INFINITY;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                GridCoords coords = new GridCoords(row, col);
                double distance = this.getCellBounds(parent, coords).getLocation().distance(location);
                if (closestCoords != null && !(distance < minDistance)) continue;
                closestCoords = coords;
                minDistance = distance;
            }
        }
        return closestCoords;
    }

    public ShelfCoords getShelfCoords(Container parent, Point point) {
        for (int i = 0; i < this.shelfCellCount; ++i) {
            Rectangle bounds = this.getShelfCellBounds(parent, GridDirection.EAST, i);
            if (bounds.contains(point)) {
                return new ShelfCoords(GridDirection.EAST, i);
            }
            bounds = this.getShelfCellBounds(parent, GridDirection.WEST, i);
            if (!bounds.contains(point)) continue;
            return new ShelfCoords(GridDirection.WEST, i);
        }
        return null;
    }

    public void setComponentCoords(Component component, GridCoords coords) {
        this.componentCoords.put(component, coords);
    }

    public void setComponentCoords(Component component, ShelfCoords coords) {
        GridDirection dir = coords.getDir();
        int index = coords.getIndex();
        switch (dir) {
            case EAST: {
                this.eastShelfCards[index] = component;
                break;
            }
            case WEST: {
                this.westShelfCards[index] = component;
                break;
            }
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.componentCoords.remove(comp);
        for (int i = 0; i < this.shelfCellCount; ++i) {
            if (this.eastShelfCards[i] == comp) {
                this.eastShelfCards[i] = null;
            }
            if (this.westShelfCards[i] != comp) continue;
            this.westShelfCards[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int nrows = this.rows;
            int ncols = this.cols;
            int width = insets.left + insets.right + 16 + ncols * this.cardSize.width;
            int height = insets.top + insets.bottom + 16 + nrows * this.cardSize.height;
            return new Dimension(width, height);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int i;
            int minDimension;
            int ncomponents = parent.getComponentCount();
            int nrows = this.rows;
            int ncols = this.cols;
            if (ncomponents == 0) {
                return;
            }
            Rectangle gridBounds = this.getGridBounds(parent);
            int cellWidth = gridBounds.width / ncols;
            int cellHeight = gridBounds.height / nrows;
            cellWidth = cellHeight = (minDimension = Math.min(cellWidth, cellHeight));
            for (i = 0; i < ncomponents; ++i) {
                Component component = parent.getComponent(i);
                Rectangle cellBounds = this.getComponentBounds(parent, component);
                if (cellBounds == null) continue;
                Point location = cellBounds.getLocation();
                parent.getComponent(i).setBounds(location.x, location.y, cellBounds.width, cellBounds.height);
            }
            for (i = 0; i < this.shelfCellCount; ++i) {
                if (this.eastShelfCards[i] != null) {
                    this.eastShelfCards[i] = null;
                }
                if (this.westShelfCards[i] == null) continue;
                this.westShelfCards[i] = null;
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[rows=" + this.rows + ",cols=" + this.cols + "]";
    }

    private Rectangle getComponentBounds(Container parent, Component component) {
        GridCoords coords = this.getGridCoords(component);
        if (coords != null) {
            return this.getCellBounds(parent, coords);
        }
        int shelfIndex = this.getShelfIndex(component, GridDirection.EAST);
        if (shelfIndex >= 0) {
            return this.getShelfCellBounds(parent, GridDirection.EAST, shelfIndex);
        }
        shelfIndex = this.getShelfIndex(component, GridDirection.WEST);
        if (shelfIndex >= 0) {
            return this.getShelfCellBounds(parent, GridDirection.WEST, shelfIndex);
        }
        return null;
    }

    private GridCoords getGridCoords(Component component) {
        if (this.componentCoords.containsKey(component)) {
            return this.componentCoords.get(component);
        }
        return null;
    }

    private int getShelfIndex(Component component, GridDirection dir) {
        Component[] shelfCards;
        switch (dir) {
            case EAST: {
                shelfCards = this.eastShelfCards;
                break;
            }
            case WEST: {
                shelfCards = this.westShelfCards;
                break;
            }
            default: {
                return -1;
            }
        }
        for (int i = 0; i < this.shelfCellCount; ++i) {
            if (shelfCards[i] != component) continue;
            return i;
        }
        return -1;
    }

    public static enum ShelfSide {
        EAST,
        WEST;

    }
}

