/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponentListener;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.HoleGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.Viewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewer;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridCoords;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.SimulationClockAnimation;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class GraphicAnimator
extends SimulationClockAnimation {
    private ProjectComponentListener listener = new ProjectComponentListener(){

        @Override
        public void modified(List<ProjectComponent> modifiedPath) {
            GraphicAnimator.this.updateDuration();
        }

        @Override
        public void childComponentRemoved(List<ProjectComponent> parentPath, ProjectComponent child, int index) {
            GraphicAnimator.this.updateDuration();
        }

        @Override
        public void childComponentAdded(List<ProjectComponent> parentPath, ProjectComponent child, int index) {
            GraphicAnimator.this.updateDuration();
        }
    };
    private final List<LocationLayerGraphic> graphics = new ArrayList<LocationLayerGraphic>();
    private final CardViewer cardViewer;
    private GridCoords currentGridCoords;
    private BufferedImage compositeImage;

    public GraphicAnimator(LocationLayerGraphic graphic, CardViewer cardViewer, int millisPerTick) {
        this.graphics.add(graphic);
        this.cardViewer = cardViewer;
        this.currentGridCoords = new GridCoords(0, 0);
        if (graphic instanceof HoleGraphic) {
            ((HoleGraphic)graphic).setCardViewer(cardViewer);
        }
        this.updateDuration();
    }

    public SceneLocationLayer getLocationLayer() {
        return this.graphics.get(0).getAncestorByType(SceneLocationLayer.class);
    }

    public void setCurrentGridCoords(GridCoords currentGridCoords) {
        this.currentGridCoords = currentGridCoords;
    }

    public boolean isEffectedByGridCoords() {
        for (LocationLayerGraphic graphic : this.graphics) {
            if (!graphic.isMovingWindow()) continue;
            return true;
        }
        return false;
    }

    public LocationLayerGraphic getGraphic() {
        return this.graphics.get(0);
    }

    public boolean isAnimated() {
        for (LocationLayerGraphic graphic : this.graphics) {
            if (!graphic.isAnimated()) continue;
            return true;
        }
        return false;
    }

    public SceneLayer getSceneLayer() {
        SceneLocationLayer locLayer = this.graphics.get(0).getAncestorByType(SceneLocationLayer.class);
        if (locLayer == null) {
            return null;
        }
        return locLayer.getSceneLayer();
    }

    @Override
    protected void elapsedFractionChanged(float elapsedFraction) {
    }

    public BufferedImage getImage() {
        this.updateDuration();
        return this.graphics.get(0).getImage(this.getElapsedFraction());
    }

    public BufferedImage getImage(Set<LocationLayerGraphic.ImageEffect> effects) {
        this.updateDuration();
        return this.graphics.get(0).getImage(this.getElapsedFraction(), effects);
    }

    public Viewpoint getViewpoint() {
        return this.graphics.get(0).getViewpoint();
    }

    public Point getOffset() {
        return this.graphics.get(0).getCurrentOffset(this.currentGridCoords, this.getElapsedFraction());
    }

    public boolean isEmpty() {
        for (LocationLayerGraphic graphic : this.graphics) {
            if (!graphic.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getGraphic().getIDPath(3);
    }

    private void updateDuration() {
        this.setDurationInMillis(this.graphics.get(0).getDurationInMillis());
    }
}

