/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.scenecomposer.viewer.GameSaveData;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GameStateHistoryListener;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridViewerPanel;
import com.sodiumarc.patchwork.util.CompareUtilities;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class GameStateHistory {
    private final int maxSize;
    private final GridViewerPanel gridViewer;
    private final List<GameStateHistoryListener> listeners;
    private final Deque<GameSaveData> pastStates;
    private final Deque<GameSaveData> futureStates;
    private GameSaveData currentState;

    public GameStateHistory(GridViewerPanel gridViewer, int maxSize) {
        this.gridViewer = gridViewer;
        this.maxSize = maxSize;
        this.listeners = new ArrayList<GameStateHistoryListener>();
        this.pastStates = new ArrayDeque<GameSaveData>();
        this.futureStates = new ArrayDeque<GameSaveData>();
    }

    public void captureCurrentState() {
        GameSaveData state = this.gridViewer.getGameSaveData();
        if (CompareUtilities.equals(state, this.currentState)) {
            return;
        }
        this.futureStates.clear();
        if (this.currentState != null) {
            this.pastStates.push(this.currentState);
        }
        this.currentState = state;
        this.fireStateChanged();
    }

    public boolean canStepBack() {
        return !this.pastStates.isEmpty();
    }

    public void stepBack() {
        if (!this.canStepBack()) {
            return;
        }
        if (this.currentState != null) {
            this.futureStates.push(this.currentState);
            if (this.futureStates.size() > this.maxSize) {
                this.futureStates.removeLast();
            }
        }
        this.currentState = this.pastStates.pop();
        this.applyCurrentState();
        this.fireStateChanged();
    }

    public boolean canStepForward() {
        return !this.futureStates.isEmpty();
    }

    public void stepForward() {
        if (!this.canStepForward()) {
            return;
        }
        if (this.currentState != null) {
            this.pastStates.push(this.currentState);
            if (this.pastStates.size() > this.maxSize) {
                this.pastStates.removeLast();
            }
        }
        this.currentState = this.futureStates.pop();
        this.applyCurrentState();
        this.fireStateChanged();
    }

    public void clear() {
        this.pastStates.clear();
        this.futureStates.clear();
        this.currentState = null;
        this.fireStateChanged();
    }

    public void addListener(GameStateHistoryListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(GameStateHistoryListener listener) {
        this.listeners.remove(listener);
    }

    private void fireStateChanged() {
        for (GameStateHistoryListener listener : this.listeners) {
            listener.stateChanged(this);
        }
    }

    private void applyCurrentState() {
        if (this.currentState != null) {
            this.gridViewer.loadGame(this.currentState);
        }
    }
}

