/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.sound.LayeredAudioSaveData;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardSaveData;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewer;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridViewerPanel;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.xml.SimpleTranscoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class GameSaveData {
    public static final String FILE_EXTENSION = "sav";
    public static javax.swing.filechooser.FileFilter SAVE_GAME_FILE_FILTER = new javax.swing.filechooser.FileFilter(){

        @Override
        public String getDescription() {
            return "Game Save Files";
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return FileUtils.hasFileExtension(file.getName(), GameSaveData.FILE_EXTENSION);
        }
    };
    public static FileFilter SAVE_GAME_IO_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return SAVE_GAME_FILE_FILTER.accept(file);
        }
    };
    private final List<CardSaveData> cardSaveData = new ArrayList<CardSaveData>();
    private LayeredAudioSaveData audioSaveData;
    private boolean inPrologue;
    private String selectedCardGUID;

    public static GameSaveData loadFromFile(File file) throws IOException, ParserConfigurationException, SAXException {
        Document document = XMLUtils.getXMLDocument(file, false);
        GameSaveData gameSaveData = (GameSaveData)new Transcoder().decode(document.getDocumentElement());
        return gameSaveData;
    }

    public GameSaveData(GridViewerPanel grid) {
        for (CardViewer cardViewer : grid.getCardViewers()) {
            this.cardSaveData.add(new CardSaveData(grid, cardViewer));
        }
        CardViewer selectedViewer = grid.getSelectedCardViewer();
        this.selectedCardGUID = selectedViewer == null ? null : selectedViewer.getCard().getGUID();
        this.inPrologue = grid.isInPrologue();
        this.audioSaveData = grid.getAudioPlayer().getSaveData();
    }

    public List<CardSaveData> getCardSaveData(PatchworkProject project) {
        ArrayList<CardSaveData> result = new ArrayList<CardSaveData>(this.cardSaveData.size());
        for (CardSaveData saveData : this.cardSaveData) {
            saveData.setProject(project);
            if (!saveData.isValid()) continue;
            result.add(saveData);
        }
        return result;
    }

    public LayeredAudioSaveData getAudioSaveData(PatchworkProject project) {
        if (this.audioSaveData != null) {
            this.audioSaveData.setProject(project);
        }
        return this.audioSaveData;
    }

    public Card getSelectedCard(PatchworkProject project) {
        ProjectComponent component;
        if (this.selectedCardGUID != null && (component = project.resolveGUID(this.selectedCardGUID)) instanceof Card) {
            return (Card)component;
        }
        return null;
    }

    public boolean isInPrologue() {
        return this.inPrologue;
    }

    public void writeToFile(File file) {
        Document doc;
        assert (file != null) : "file is null";
        try {
            doc = XMLUtils.newXMLDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return;
        }
        doc.appendChild(new Transcoder().encode(doc, this));
        try {
            XMLUtils.writeXMLDocument(doc, file);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private GameSaveData() {
        this.selectedCardGUID = null;
    }

    public static class Transcoder
    extends SimpleTranscoder<GameSaveData> {
        private static final String ELEM_NAME = "GameSaveData";
        private static final String FIELD_CARDS = "cards";
        private static final String FIELD_AUDIO = "adio";
        private static final String ATTR_SELECTED_CARD_GUID = "selectedCardGUID";
        private static final String ATTR_IN_PROLOGUE = "inPrologue";

        protected Transcoder() {
            super(ELEM_NAME, GameSaveData.class);
            this.setFieldTranscoder(FIELD_CARDS, new CardSaveData.Transcoder());
            this.setFieldTranscoder(FIELD_AUDIO, new LayeredAudioSaveData.Transcoder());
        }

        @Override
        protected void getAttributes(GameSaveData object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_IN_PROLOGUE, Boolean.toString(object.inPrologue));
            if (object.selectedCardGUID != null) {
                destination.put(ATTR_SELECTED_CARD_GUID, object.selectedCardGUID);
            }
        }

        @Override
        protected void getChildren(GameSaveData object, MultiMap<String, Object> destination) {
            for (CardSaveData cardSaveData : object.cardSaveData) {
                destination.putLast(FIELD_CARDS, cardSaveData);
            }
            destination.putLast(FIELD_AUDIO, object.audioSaveData);
        }

        @Override
        protected GameSaveData decode(Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            GameSaveData result = new GameSaveData();
            for (Object cardSaveData : decodedChildren.getAll(FIELD_CARDS)) {
                result.cardSaveData.add((CardSaveData)cardSaveData);
            }
            result.audioSaveData = (LayeredAudioSaveData)decodedChildren.getFirst(FIELD_AUDIO);
            if (attributes.containsKey(ATTR_IN_PROLOGUE)) {
                result.inPrologue = Boolean.valueOf(attributes.get(ATTR_IN_PROLOGUE));
            }
            if (attributes.containsKey(ATTR_SELECTED_CARD_GUID)) {
                result.selectedCardGUID = attributes.get(ATTR_SELECTED_CARD_GUID);
            }
            return result;
        }
    }
}

