/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.Viewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewer;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewerListener;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridViewerPanel;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.UnitlessDragSensor;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.util.Filter;
import com.sodiumarc.patchwork.util.GeometricAxis;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.vecmath.Vector3d;

public class CardViewpointControls {
    private final GridViewerPanel parallaxEngine;
    private final UnitlessDragSensor panSensor;
    private final UnitlessDragSensor zoomSensor;
    private final CardViewerListener cardViewerListener;
    private CardViewer cardViewer;
    private final Vector3d currentCameraOffset;
    private Viewpoint viewpoint;

    public CardViewpointControls(GridViewerPanel gridViewer) {
        this.parallaxEngine = gridViewer;
        this.currentCameraOffset = new Vector3d();
        Filter<MouseEvent> panEventFilter = new Filter<MouseEvent>(){

            @Override
            public boolean accept(MouseEvent event) {
                return event.getButton() == 1 && event.isShiftDown() && !event.isControlDown();
            }
        };
        Filter<MouseEvent> zoomEventFilter = new Filter<MouseEvent>(){

            @Override
            public boolean accept(MouseEvent event) {
                if (event instanceof MouseWheelEvent) {
                    return event.isShiftDown() && !event.isControlDown();
                }
                return event.getButton() == 3 && event.isShiftDown() && !event.isControlDown();
            }
        };
        this.panSensor = new UnitlessDragSensor(gridViewer, panEventFilter){

            @Override
            protected void update(float localDeltaX, float localDeltaY, float cumulativeDeltaX, float cumulativeDeltaY) {
                CardViewpointControls.this.currentCameraOffset.setX(cumulativeDeltaX);
                CardViewpointControls.this.currentCameraOffset.setY(cumulativeDeltaY);
                CardViewpointControls.this.setCurrentCameraOffset(CardViewpointControls.this.currentCameraOffset);
            }
        };
        this.panSensor.setInputScaleY(0.1f);
        this.panSensor.setInputScaleX(-0.1f);
        this.zoomSensor = new UnitlessDragSensor(gridViewer, zoomEventFilter){

            @Override
            protected void update(float localDeltaX, float localDeltaY, float cumulativeDeltaX, float cumulativeDeltaY) {
                CardViewpointControls.this.currentCameraOffset.setZ(cumulativeDeltaY);
                CardViewpointControls.this.setCurrentCameraOffset(CardViewpointControls.this.currentCameraOffset);
            }
        };
        this.zoomSensor.setInputScaleY(0.1f);
        this.zoomSensor.setInputScaleX(-0.1f);
        this.zoomSensor.setMouseWheelAxis(GeometricAxis.Y);
        this.cardViewerListener = new CardViewerListener(){

            @Override
            public void targetChanged(CardViewer source) {
                CardViewpointControls.this.reset();
            }

            @Override
            public void infoChanged(CardViewer source) {
            }

            @Override
            public void locationChanged(CardViewer source) {
            }

            @Override
            public void stateChanged(CardViewer source) {
            }
        };
    }

    public void setCardViewer(CardViewer cardViewer) {
        if (this.cardViewer != null) {
            this.cardViewer.removeCardListener(this.cardViewerListener);
        }
        this.cardViewer = cardViewer;
        if (this.cardViewer != null) {
            this.cardViewer.addCardListener(this.cardViewerListener);
        }
        this.reset();
    }

    public void setEnabled(boolean enabled) {
        this.panSensor.setEnabled(enabled);
        this.zoomSensor.setEnabled(enabled);
    }

    public void reset() {
        if (this.cardViewer != null) {
            this.viewpoint = this.cardViewer.getHomeViewpoint();
        }
        this.panSensor.reset();
        this.zoomSensor.reset();
        this.currentCameraOffset.set(0.0, 0.0, 0.0);
        this.setCurrentCameraOffset(this.currentCameraOffset);
    }

    public void setLocationFilter(Filter<Point> locationFilter) {
        this.panSensor.setLocationFilter(locationFilter);
        this.zoomSensor.setLocationFilter(locationFilter);
    }

    private void setCurrentCameraOffset(Vector3d offset) {
        if (this.viewpoint == null || this.cardViewer == null) {
            return;
        }
        Camera offsetCamera = this.viewpoint.getCamera().createOffsetCamera("current", offset, true);
        this.cardViewer.setCurrentViewpoint(offsetCamera, this.viewpoint.getViewport());
    }
}

