/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.scanimport.ImagePanel;
import com.sodiumarc.patchwork.app.scenecomposer.model.GridDirection;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.LocationTransition;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardBorder;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewer;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.SimulationClock;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.SimulationClockListener;
import com.sodiumarc.patchwork.util.CompareUtilities;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;

public class CardViewerPanel
extends JPanel {
    private final String id;
    private final CardViewer target;
    private final ImagePanel imagePanel;
    private final CardBorder border;
    private final Dimension preferredSize;
    private final List<LocationTransition> hotspots;
    private boolean showAllHotspots;
    private boolean selected;
    private Point mouseOverPosition;
    private float buttonPopupFraction;
    private final BufferedImage hsButtonImage;
    private final BufferedImage hsButtonOverImage;

    public CardViewerPanel(String id, CardViewer target, SimulationClock simClock, Dimension size) {
        super(new GridLayout(1, 1));
        this.id = id;
        this.target = target;
        this.preferredSize = size;
        this.hotspots = new ArrayList<LocationTransition>();
        this.imagePanel = new ImagePanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                CardViewerPanel.this.border.paint((Graphics2D)g, this.getOrigin());
                CardViewerPanel.this.paintOverlay((Graphics2D)g);
            }
        };
        this.imagePanel.setFrameSize(size);
        this.imagePanel.setSize(size);
        this.imagePanel.setFillBackground(false);
        this.imagePanel.setCompositeBackgroundColor(PatchworkProject.GRID_BG_COLOR);
        this.imagePanel.setDrawBorder(false);
        this.imagePanel.setOpaque(false);
        this.border = new CardBorder(size);
        this.border.setShowSelection(target.getGridViewerPanel().isEditMode());
        this.add(this.imagePanel);
        this.setOpaque(false);
        simClock.addListener(new SimulationClockListener(){

            @Override
            public void tick(int elapsedTicks, long elapsedMillis) {
                if (CardViewerPanel.this.mouseOverPosition != null) {
                    CardViewerPanel.this.updateButtonDisplay();
                }
            }
        });
        float hsButtonScale = (float)size.width / 6.0f / (float)LocationTransition.HS_BUTTON_IMAGE.getWidth();
        this.hsButtonImage = MathUtils.epsilonEquals(hsButtonScale, 1.0, 1.0E-4) ? LocationTransition.HS_BUTTON_IMAGE : ImageUtils.scale(LocationTransition.HS_BUTTON_IMAGE, hsButtonScale, hsButtonScale);
        this.hsButtonOverImage = MathUtils.epsilonEquals(hsButtonScale, 1.0, 1.0E-4) ? LocationTransition.HS_BUTTON_IMAGE_OVER : ImageUtils.scale(LocationTransition.HS_BUTTON_IMAGE_OVER, hsButtonScale, hsButtonScale);
    }

    public ImagePanel getImagePanel() {
        return this.imagePanel;
    }

    public BufferedImage getSnapshotImage(boolean imagesOnly, boolean includeBackground) {
        return this.imagePanel.paintToImage(imagesOnly, includeBackground);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.border.setSelected(selected);
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setMouseOverPosition(Point position) {
        if (!CompareUtilities.equals(this.mouseOverPosition, position)) {
            if (this.mouseOverPosition == null) {
                this.buttonPopupFraction = 0.0f;
            }
            this.mouseOverPosition = position;
            this.repaint();
        }
    }

    public void clearHotspots(boolean repaint) {
        this.hotspots.clear();
        this.buttonPopupFraction = 0.0f;
        if (repaint) {
            this.repaint();
        }
    }

    public void addHotspot(LocationTransition hotspot, boolean repaint) {
        this.hotspots.add(hotspot);
        this.buttonPopupFraction = 0.0f;
        if (repaint) {
            this.repaint();
        }
    }

    public void removeHotspot(LocationTransition hotspot, boolean repaint) {
        this.hotspots.remove(hotspot);
        this.buttonPopupFraction = 0.0f;
        if (repaint) {
            this.repaint();
        }
    }

    public List<LocationTransition> getHotspots() {
        return this.hotspots;
    }

    public void setShowHotspotLabels(boolean showHotspotLabels) {
        this.showAllHotspots = showHotspotLabels;
    }

    public void clearLinkedDirs() {
        this.border.clearLinkedDirs();
        this.repaint();
    }

    public void addLinkedDir(GridDirection dir) {
        this.border.addLinkedDir(dir);
        this.repaint();
    }

    public void removeLinkedDir(GridDirection dir) {
        this.border.removeLinkedDir(dir);
        this.repaint();
    }

    public Set<GridDirection> getLinkedDirs() {
        return this.border.getLinkedDirs();
    }

    public LocationTransition getHotspotForLocation(Point point) {
        Point origin = this.imagePanel.getOrigin();
        Point localCoords = new Point(point.x - origin.x, point.y - origin.y);
        Rectangle4d destRect = new Rectangle4d(this.preferredSize);
        for (LocationTransition hotspot : this.hotspots) {
            Rectangle4d region = destRect.fromProportional(hotspot.getHotspotRegion());
            if (!region.asRectangle2D().contains(localCoords)) continue;
            return hotspot;
        }
        return null;
    }

    public void setAutoRedraw(boolean autoRedraw) {
        this.imagePanel.setAutoRedraw(autoRedraw);
    }

    public boolean isRedrawNeeded() {
        return this.imagePanel.isRedrawNeeded();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    public String toString() {
        return "CardViewerPanel [id=" + this.id + "]";
    }

    private boolean isEditMode() {
        return this.target.getGridViewerPanel().isEditMode();
    }

    private void paintOverlay(Graphics2D g2) {
        Rectangle4d destination = new Rectangle4d(this.preferredSize);
        if (!this.target.isInTransition()) {
            for (LocationTransition hotspot : this.hotspots) {
                if ((this.mouseOverPosition == null || hotspot.getHotspotStyle() == LocationTransition.HotspotStyle.REGION) && !this.showAllHotspots) continue;
                this.drawHotspot(g2, hotspot, destination, this.showAllHotspots && this.isEditMode());
            }
        }
    }

    private void drawHotspot(Graphics2D graphics, LocationTransition transition, Rectangle4d destination, boolean drawID) {
        Rectangle4d region = destination.fromProportional(transition.getHotspotRegion());
        graphics.setComposite(AlphaComposite.SrcOver);
        if (transition.getHotspotStyle() == LocationTransition.HotspotStyle.REGION) {
            graphics.setColor(Color.GREEN);
            graphics.drawRect((int)region.getX(), (int)region.getY(), (int)region.getWidth(), (int)region.getHeight());
        } else {
            this.drawRasterButton(graphics, transition, region);
        }
        if (drawID) {
            graphics.setColor(Color.GREEN);
            graphics.drawString(transition.getID(), (int)region.getX(), (int)region.getY() - 2);
        }
    }

    private void drawVectorButton(Graphics2D graphics, LocationTransition transition, Rectangle4d region) {
        graphics.setColor(Color.WHITE);
        graphics.fillRect((int)region.getX(), (int)region.getY(), (int)region.getWidth(), (int)region.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.drawRect((int)region.getX(), (int)region.getY(), (int)region.getWidth(), (int)region.getHeight());
        Point2D.Double[] pointsProprtional = new Point2D.Double[]{new Point2D.Double(0.5, 0.2), new Point2D.Double(0.8, 0.5), new Point2D.Double(0.5, 0.8), new Point2D.Double(0.5, 0.6), new Point2D.Double(0.2, 0.6), new Point2D.Double(0.2, 0.4), new Point2D.Double(0.5, 0.4)};
        Polygon arrowShape = new Polygon();
        for (Point2D.Double point : pointsProprtional) {
            Point2D.Double proportional = region.fromProportional(point);
            arrowShape.addPoint((int)proportional.x, (int)proportional.y);
        }
        AffineTransform oldTransform = graphics.getTransform();
        AffineTransform transform = new AffineTransform();
        double rotation = 0.0;
        switch (transition.getHotspotStyle()) {
            case BACK_BUTTON: {
                rotation = 1.5707963267948966;
                break;
            }
            case LEFT_BUTTON: {
                rotation = Math.PI;
                break;
            }
            case RIGHT_BUTTON: {
                rotation = 0.0;
                break;
            }
        }
        transform.rotate(rotation, region.getXCenter(), region.getYCenter());
        graphics.transform(transform);
        graphics.fill(arrowShape);
        graphics.setTransform(oldTransform);
    }

    private void drawRasterButton(Graphics2D graphics, LocationTransition transition, Rectangle4d region) {
        double rotation = 0.0;
        switch (transition.getHotspotStyle()) {
            case BACK_BUTTON: {
                rotation = 0.0;
                break;
            }
            case LEFT_BUTTON: {
                rotation = 1.5707963267948966;
                break;
            }
            case RIGHT_BUTTON: {
                rotation = -1.5707963267948966;
                break;
            }
        }
        AffineTransform transform = new AffineTransform();
        double anchorX = (double)this.hsButtonImage.getWidth() / 2.0;
        double anchorY = (double)this.hsButtonOverImage.getHeight() / 2.0;
        double scale = MathUtils.interpolate(this.buttonPopupFraction, 0.5, 1.0);
        double alpha = MathUtils.interpolate(this.buttonPopupFraction, 0.0, 1.0);
        transform.setToTranslation(region.getX(), region.getY());
        transform.translate(anchorX, anchorY);
        transform.rotate(rotation);
        transform.scale(scale, scale);
        transform.translate(-anchorX, -anchorY);
        Composite wasComposite = graphics.getComposite();
        graphics.setComposite(AlphaComposite.getInstance(3, (float)alpha));
        boolean mouseOverButton = this.mouseOverPosition != null && region.asAWTRectangle().contains(this.mouseOverPosition);
        graphics.drawImage(mouseOverButton ? this.hsButtonOverImage : this.hsButtonImage, transform, null);
        graphics.setComposite(wasComposite);
    }

    private void updateButtonDisplay() {
        if (this.buttonPopupFraction < 1.0f) {
            this.buttonPopupFraction = MathUtils.clamp(this.buttonPopupFraction + 0.2f, 0.0f, 1.0f);
            this.repaint();
        }
    }
}

