/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.animation.AbstractAnimation;
import com.sodiumarc.patchwork.animation.Animation;
import com.sodiumarc.patchwork.animation.AnimationListener;
import com.sodiumarc.patchwork.app.scanimport.ImagePanel;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.GridDirection;
import com.sodiumarc.patchwork.app.scenecomposer.model.LocationTransitionAnimation;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponentListener;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.CardLink;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.LocationTransition;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.HoleGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundClip;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundSequence;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.Viewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.parallax.ParallaxEngine;
import com.sodiumarc.patchwork.app.scenecomposer.sound.LayeredAudioPlayer;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardShadow;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewerListener;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewerPanel;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GraphicAnimator;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridCoords;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridViewerPanel;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.SimulationClock;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.SimulationClockListener;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Collection.MultiHashMap;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.CompareUtilities;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class CardViewer {
    private final Card card;
    private final CardViewerPanel panel;
    private final ParallaxEngine parallaxEngine;
    private final AnimationListener animationListener;
    private final CardViewerListener underCardListener;
    private CardShadow shadow;
    private boolean syncRedraw = true;
    private boolean initialized;
    private ProjectComponent target;
    private final GridViewerPanel gridViewerPanel;
    private final List<CardViewerListener> listeners;
    private final List<LocationTransition> hotspots;
    private GraphicAnimator selectedGraphicAnimator;
    private final MultiMap<SceneLayer, GraphicAnimator> animatedGraphicsBySceneLayer;
    private final MultiMap<SceneLocationLayer, GraphicAnimator> graphicsByLocationLayer;
    private AbstractAnimation transitionAnimation;
    private boolean inTransition;
    private final Map<SceneLayer, SceneLayerState> layerStates;
    private final Set<SceneLayer> changedLayers;
    private boolean inPlay;
    private GridCoords currentGridCoords;
    private boolean onGrid;
    private Viewpoint homeViewpoint;
    private final Set<Option> enabledOptions;
    private final List<CardViewer> underCapturedCards;
    private final List<CardViewer> overCapturedCards;
    private static final int MAX_SHADOW_HEIGHT = 6;
    private static final Logger LOGGER = Logger.getLogger(CardViewer.class);

    public CardViewer(Card card, Dimension size, GridViewerPanel gridViewerPanel) {
        this.card = card;
        this.gridViewerPanel = gridViewerPanel;
        this.enabledOptions = EnumSet.of(Option.SHOW_BACKGROUND);
        this.listeners = new ArrayList<CardViewerListener>();
        this.layerStates = new HashMap<SceneLayer, SceneLayerState>();
        this.underCapturedCards = new ArrayList<CardViewer>();
        this.overCapturedCards = new ArrayList<CardViewer>();
        this.animatedGraphicsBySceneLayer = new MultiHashMap<SceneLayer, GraphicAnimator>();
        this.graphicsByLocationLayer = new MultiHashMap<SceneLocationLayer, GraphicAnimator>();
        this.hotspots = new ArrayList<LocationTransition>();
        this.parallaxEngine = new ParallaxEngine(size);
        this.currentGridCoords = new GridCoords(0, 0);
        this.changedLayers = new HashSet<SceneLayer>();
        final SimulationClock simClock = gridViewerPanel.getSimulationClock();
        this.panel = new CardViewerPanel(card.getID(), this, simClock, size);
        this.setSyncRedraw(true);
        this.animationListener = new AnimationListener(){

            @Override
            public void elapsedFractionChanged(Animation source, float elapsedFraction) {
                if (source instanceof LocationTransitionAnimation) {
                    Viewpoint viewpoint = ((LocationTransitionAnimation)source).getViewPoint();
                    CardViewer.this.parallaxEngine.setCurrentViewpoint(viewpoint.getCamera(), viewpoint.getViewport());
                    CardViewer.this.allLayersNeedUpdate();
                }
                if (source instanceof GraphicAnimator) {
                    Set<SceneLayer> changedLayers = null;
                    GraphicAnimator animator = (GraphicAnimator)source;
                    SceneLayer sceneLayer = animator.getSceneLayer();
                    if (animator.isAnimated() && sceneLayer != null) {
                        changedLayers = Collections.singleton(sceneLayer);
                    }
                    CardViewer.this.layersNeedUpdate(changedLayers);
                }
            }

            @Override
            public void animationStopped(Animation source) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Completing animation " + source + " at: " + simClock.getElapsedTicks());
                }
                CardViewer.this.animationComplete(source);
            }

            @Override
            public void animationStarted(Animation source) {
            }
        };
        this.underCardListener = new CardViewerListener(){

            @Override
            public void targetChanged(CardViewer source) {
            }

            @Override
            public void stateChanged(CardViewer source) {
                CardViewer.this.updateHoleGraphics();
            }

            @Override
            public void locationChanged(CardViewer source) {
                CardViewer.this.updateHoleGraphics();
            }

            @Override
            public void infoChanged(CardViewer source) {
            }
        };
        card.addListener(new ProjectComponentListener(){

            @Override
            public void modified(List<ProjectComponent> modifiedPath) {
            }

            @Override
            public void childComponentRemoved(List<ProjectComponent> parentPath, ProjectComponent child, int index) {
                if (child instanceof SceneLocationLayer) {
                    CardViewer.this.graphicsByLocationLayer.remove(child);
                } else if (child instanceof LocationLayerGraphic) {
                    CardViewer.this.updateGraphicsFromState(null);
                }
                if (child.equals(CardViewer.this.target)) {
                    CardViewer.this.setTarget(CollectionUtils.last(parentPath));
                }
                CardViewer.this.shadow = null;
            }

            @Override
            public void childComponentAdded(List<ProjectComponent> parentPath, ProjectComponent child, int index) {
            }
        });
        simClock.addListener(new SimulationClockListener(){

            @Override
            public void tick(int elapsedTicks, long elapsedMillis) {
                if (CardViewer.this.selectedGraphicAnimator != null) {
                    CardViewer.this.selectedGraphicAnimator.setElapsedTicks(elapsedTicks, elapsedMillis);
                }
                if (!CardViewer.this.animatedGraphicsBySceneLayer.isEmpty()) {
                    ArrayList<GraphicAnimator> animators = new ArrayList<GraphicAnimator>();
                    for (SceneLayer layer : CardViewer.this.animatedGraphicsBySceneLayer.keySet()) {
                        for (GraphicAnimator animator : CardViewer.this.animatedGraphicsBySceneLayer.getAll(layer)) {
                            animators.add(animator);
                        }
                    }
                    for (GraphicAnimator animator : animators) {
                        animator.setElapsedTicks(elapsedTicks, elapsedMillis);
                    }
                }
                if (!CardViewer.this.changedLayers.isEmpty()) {
                    CardViewer.this.updateViewImmediate();
                    CardViewer.this.changedLayers.clear();
                }
                if (CardViewer.this.isSyncRedraw() && CardViewer.this.panel.isRedrawNeeded()) {
                    CardViewer.this.panel.repaint();
                }
            }
        });
    }

    public void prepareForDisplay() {
        if (!this.initialized) {
            this.updateGraphicsFromState(null);
            this.setTarget(this.getCard().getStartingLocation());
            this.resetStates();
            this.initialized = true;
        }
    }

    public Card getCard() {
        return this.card;
    }

    public GridViewerPanel getGridViewerPanel() {
        return this.gridViewerPanel;
    }

    public SceneLayerState getCurrentState(SceneLayer layer) {
        return this.layerStates.get(layer);
    }

    public boolean isCurrentStateComplete(SceneLayer layer) {
        return this.animatedGraphicsBySceneLayer.getAll(layer).isEmpty();
    }

    public boolean isInteractionEnabled() {
        if (this.isInTransition()) {
            return false;
        }
        if (this.animatedGraphicsBySceneLayer.isEmpty()) {
            return true;
        }
        for (SceneLayer layer : this.animatedGraphicsBySceneLayer.keySet()) {
            for (GraphicAnimator graphicAnimator : this.animatedGraphicsBySceneLayer.getAll(layer)) {
                if (graphicAnimator.getGraphic().isInteractiveWhenAnimating()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isAnimating() {
        return !this.animatedGraphicsBySceneLayer.isEmpty();
    }

    public boolean isSyncRedraw() {
        return this.syncRedraw;
    }

    public void setSyncRedraw(boolean syncRedraw) {
        this.syncRedraw = syncRedraw;
        this.panel.setAutoRedraw(!syncRedraw);
    }

    public Map<SceneLayer, SceneLayerState> getCurrentStates() {
        return Collections.unmodifiableMap(this.layerStates);
    }

    public void setState(SceneLayer layer, SceneLayerState state) {
        this.setStates(Collections.singletonMap(layer, state), false);
    }

    public void setStates(Map<SceneLayer, SceneLayerState> states, boolean replaceAll) {
        if (replaceAll) {
            this.layerStates.clear();
        }
        HashSet<SceneLayer> changedLayers = new HashSet<SceneLayer>();
        HashSet<SoundSequence> soundSequences = new HashSet<SoundSequence>();
        for (Map.Entry<SceneLayer, SceneLayerState> entry : states.entrySet()) {
            SceneLayer layer = entry.getKey();
            if (layer == null || !CompareUtilities.equals(layer.getAncestorByType(Card.class), this.card)) {
                LOGGER.warn("layer " + layer + " does not belong to card " + this.card);
                continue;
            }
            SceneLayerState state = entry.getValue();
            if (!CompareUtilities.equals(this.layerStates.get(layer), state) && state != null) {
                this.layerStates.put(layer, state);
                SoundSequence soundSequence = state.getSoundSequence();
                if (soundSequence != null) {
                    soundSequences.add(state.getSoundSequence());
                }
            }
            changedLayers.add(layer);
        }
        this.updateGraphicsFromState(changedLayers);
        this.updateParallaxEngineGraphics();
        Set<LocationTransition> autoTransitions = this.updateTransitions();
        this.updateViewImmediate();
        for (SoundSequence sequence : soundSequences) {
            this.gridViewerPanel.getAudioPlayer().playSequence(sequence, true);
        }
        this.fireStateChanged();
        if (!autoTransitions.isEmpty()) {
            this.activateTransition(CollectionUtils.first(autoTransitions));
        }
        this.shadow = null;
    }

    public void resetStates() {
        HashMap<SceneLayer, SceneLayerState> initialStates = new HashMap<SceneLayer, SceneLayerState>();
        for (SceneLayer sceneLayer : this.card.getDescendantsByType(SceneLayer.class, new ArrayList())) {
            if (sceneLayer.getStates().isEmpty()) continue;
            initialStates.put(sceneLayer, sceneLayer.getInitialState());
        }
        this.setStates(initialStates, true);
    }

    public ImagePanel getImagePanel() {
        return this.panel.getImagePanel();
    }

    public CardViewerPanel getPanel() {
        return this.panel;
    }

    public CardShadow getShadow() {
        if (this.shadow == null) {
            this.shadow = new CardShadow(this, 6, false);
        }
        return this.shadow;
    }

    public ProjectComponent getTarget() {
        return this.target;
    }

    public BufferedImage getSnapshotImage(boolean imagesOnly, boolean includeBackground) {
        this.allLayersNeedUpdate();
        this.updateViewImmediate();
        return this.panel.getSnapshotImage(imagesOnly, includeBackground);
    }

    public Viewpoint getHomeViewpoint() {
        return this.homeViewpoint;
    }

    public void setCurrentViewpoint(Camera currentCamera, Rectangle4d viewport) {
        this.parallaxEngine.setCurrentViewpoint(currentCamera, viewport);
        this.allLayersNeedUpdate();
    }

    public void setSelected(boolean selected) {
        if (selected != this.panel.isSelected()) {
            this.panel.setSelected(selected);
            if (selected) {
                this.updateAmbientSound();
            }
        }
    }

    public void setMouseOverPosition(Point position) {
        this.panel.setMouseOverPosition(position);
    }

    public boolean isInPlay() {
        return this.inPlay;
    }

    public void setInPlay(boolean inPlay) {
        this.inPlay = inPlay;
        this.updateViewImmediate();
    }

    public void setCurrentGridCoords(GridCoords coords, boolean onGrid) {
        assert (coords != null) : "Null coords";
        this.currentGridCoords = coords;
        boolean viewUpdateRequired = onGrid != this.onGrid;
        for (SceneLocationLayer locLayer : this.graphicsByLocationLayer.keySet()) {
            for (GraphicAnimator graphicAnimator : (List)this.graphicsByLocationLayer.get(locLayer)) {
                graphicAnimator.setCurrentGridCoords(coords);
                if (!graphicAnimator.isEffectedByGridCoords()) continue;
                this.changedLayers.add(locLayer.getSceneLayer());
                viewUpdateRequired = true;
            }
        }
        if (this.selectedGraphicAnimator != null) {
            this.selectedGraphicAnimator.setCurrentGridCoords(this.currentGridCoords);
        }
        if (viewUpdateRequired) {
            this.updateViewImmediate();
        }
        this.onGrid = onGrid;
    }

    public void addUnderCapturedCard(CardViewer cardViewer) {
        cardViewer.addCardListener(this.underCardListener);
        this.underCapturedCards.add(cardViewer);
        this.updateHoleGraphics();
    }

    public void removeUnderCapturedCard(CardViewer cardViewer) {
        cardViewer.removeCardListener(this.underCardListener);
        this.underCapturedCards.remove(cardViewer);
        this.updateHoleGraphics();
    }

    public void clearUnderCapturedCards() {
        for (CardViewer cardViewer : this.underCapturedCards) {
            cardViewer.removeCardListener(this.underCardListener);
        }
        this.underCapturedCards.clear();
        this.updateHoleGraphics();
    }

    public boolean isUnderCapturedCard(CardViewer cardViewer) {
        return this.underCapturedCards.contains(cardViewer);
    }

    public List<CardViewer> getUnderCapturedCards() {
        return Collections.unmodifiableList(this.underCapturedCards);
    }

    public void addOverCapturedCard(CardViewer cardViewer) {
        this.overCapturedCards.add(cardViewer);
    }

    public void removeOverCapturedCard(CardViewer cardViewer) {
        this.overCapturedCards.remove(cardViewer);
    }

    public void clearOverCapturedCards() {
        this.overCapturedCards.clear();
    }

    public boolean isOverCapturedCard(CardViewer cardViewer) {
        return this.overCapturedCards.contains(cardViewer);
    }

    public List<CardViewer> getOverCapturedCards() {
        return Collections.unmodifiableList(this.overCapturedCards);
    }

    public void clearLinkedDirs() {
        this.panel.clearLinkedDirs();
    }

    public void addLinkedDir(GridDirection dir) {
        this.panel.addLinkedDir(dir);
    }

    public void removeLinkedDir(GridDirection dir) {
        this.panel.removeLinkedDir(dir);
    }

    public Set<GridDirection> getLinkedDirs() {
        return this.panel.getLinkedDirs();
    }

    public boolean isInTransition() {
        return this.inTransition;
    }

    public boolean isOptionEnabled(Option option) {
        return this.enabledOptions.contains((Object)option);
    }

    public void setOptionEnabled(Option option, boolean enabled) {
        if (enabled) {
            this.enabledOptions.add(option);
        } else {
            this.enabledOptions.remove((Object)option);
        }
        switch (option) {
            case SHOW_BACKGROUND: {
                this.updateParallaxEngine();
                break;
            }
            case SHOW_REFS: {
                this.parallaxEngine.setShowRefs(enabled);
                break;
            }
            case SHOW_BOUNDARIES: {
                this.parallaxEngine.setShowBoundaries(enabled);
                break;
            }
            case SHOW_MARGINS: {
                this.parallaxEngine.setClipToOutput(!enabled);
                break;
            }
            case SHOW_HOTSPOTS: {
                this.panel.setShowHotspotLabels(enabled);
            }
        }
        this.allLayersNeedUpdate();
    }

    public LocationTransition getHotspotForLocation(Point point) {
        return this.panel.getHotspotForLocation(point);
    }

    public void activateTransition(LocationTransition transition) {
        if (transition != null) {
            SceneLocation destination = transition.getDestLocation();
            if (destination != null && transition.getTransitionDuration() == 0) {
                this.setTarget(destination);
            } else {
                this.inTransition = true;
                this.setTarget(transition);
            }
        }
    }

    public void layersNeedUpdate(Collection<SceneLayer> changedLayers) {
        if (changedLayers == null) {
            return;
        }
        this.changedLayers.addAll(changedLayers);
    }

    public void allLayersNeedUpdate() {
        this.layersNeedUpdate(this.parallaxEngine.getLayers());
    }

    public String getInfoText() {
        ProjectComponent target = this.getAdjustedTarget();
        if (target == null) {
            return " ";
        }
        return String.format("%s : %s", target, this.parallaxEngine.getInfo());
    }

    public Icon getInfoIcon() {
        ProjectComponent target = this.getAdjustedTarget();
        return target == null ? null : target.getIcon();
    }

    public void addCardListener(CardViewerListener listener) {
        this.listeners.add(listener);
    }

    public void removeCardListener(CardViewerListener listener) {
        this.listeners.remove(listener);
    }

    public SceneLocation getCurrentLocation() {
        ProjectComponent target = this.getAdjustedTarget();
        if (target == null) {
            return null;
        }
        if (this.inTransition) {
            return null;
        }
        return target.getAncestorByType(SceneLocation.class);
    }

    public List<CardLink> getActiveCardLinks() {
        ArrayList<CardLink> result = new ArrayList<CardLink>();
        SceneLocation location = this.getCurrentLocation();
        if (location != null) {
            for (CardLink cardLink : location.getCardLinks()) {
                if (!cardLink.isActiveForState(this.layerStates)) continue;
                result.add(cardLink);
            }
        }
        return result;
    }

    public boolean isActive(CardLink cardLink) {
        return this.getActiveCardLinks().contains(cardLink);
    }

    public Animation getCurrentAnimation() {
        ProjectComponent target = this.getAdjustedTarget();
        if (target instanceof LocationTransition) {
            return ((LocationTransition)target).getTransitionAnimation();
        }
        return this.selectedGraphicAnimator;
    }

    public boolean isRedrawNeeded() {
        return this.panel.isRedrawNeeded();
    }

    public void redraw() {
        this.panel.repaint();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getCard() + "]";
    }

    public void setTarget(ProjectComponent target) {
        LocationLayerGraphic graphic;
        ProjectComponent parent;
        this.target = target;
        ProjectComponent adjustedTarget = this.getAdjustedTarget();
        this.selectedGraphicAnimator = null;
        if (adjustedTarget instanceof LocationLayerGraphic && (parent = (graphic = (LocationLayerGraphic)adjustedTarget).getParentComponent()) instanceof SceneLocationLayer) {
            this.selectedGraphicAnimator = new GraphicAnimator(graphic, this, 20);
            this.selectedGraphicAnimator.setCurrentGridCoords(this.currentGridCoords);
        }
        this.updateParallaxEngine();
        this.setLocationTransition(null, false);
        if (adjustedTarget instanceof LocationTransition) {
            LocationTransition transition = (LocationTransition)adjustedTarget;
            this.setLocationTransition(transition, this.inTransition);
        }
        Set<LocationTransition> autoTransitions = this.updateTransitions();
        this.updateViewImmediate();
        this.fireLocationChanged();
        this.initialized = true;
        this.shadow = null;
        this.fireTargetChanged();
        this.updateAmbientSound();
        if (!autoTransitions.isEmpty()) {
            LocationTransition transition = CollectionUtils.first(autoTransitions);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Auto-transition: " + transition);
            }
            this.activateTransition(transition);
        }
    }

    private void fireTargetChanged() {
        for (CardViewerListener listener : new ArrayList<CardViewerListener>(this.listeners)) {
            listener.targetChanged(this);
        }
    }

    private void fireInfoChanged() {
        for (CardViewerListener listener : new ArrayList<CardViewerListener>(this.listeners)) {
            listener.infoChanged(this);
        }
    }

    private void fireLocationChanged() {
        for (CardViewerListener listener : new ArrayList<CardViewerListener>(this.listeners)) {
            listener.locationChanged(this);
        }
    }

    private void fireStateChanged() {
        for (CardViewerListener listener : new ArrayList<CardViewerListener>(this.listeners)) {
            listener.stateChanged(this);
        }
    }

    private ProjectComponent getAdjustedTarget() {
        if (this.target == null) {
            return null;
        }
        if (!this.card.equals(this.target.getAncestorByType(Card.class))) {
            return null;
        }
        if (this.target instanceof Scene) {
            this.target = ((Scene)this.target).getParentComponent().getStartingLocation();
        } else if (this.target instanceof Card) {
            this.target = ((Card)this.target).getStartingLocation();
        }
        return this.target;
    }

    private void setLocationTransition(LocationTransition transition, boolean startPlaying) {
        LocationTransitionAnimation animation;
        LocationTransitionAnimation locationTransitionAnimation = animation = transition == null ? null : transition.getTransitionAnimation();
        if (this.transitionAnimation != null) {
            this.transitionAnimation.removeListener(this.animationListener);
        }
        this.transitionAnimation = animation;
        if (this.transitionAnimation != null) {
            this.transitionAnimation.addListener(this.animationListener);
            if (startPlaying) {
                this.transitionAnimation.setElapsedFraction(0.0f);
                this.transitionAnimation.start();
            }
        }
    }

    private void animationComplete(Animation animation) {
        if (animation instanceof LocationTransitionAnimation) {
            if (this.inTransition) {
                this.inTransition = false;
                this.setTarget(((LocationTransition)this.getAdjustedTarget()).getDestLocation());
            }
        } else if (animation instanceof GraphicAnimator) {
            GraphicAnimator graphicAnimator = (GraphicAnimator)animation;
            graphicAnimator.removeListener(this.animationListener);
            SceneLayer sceneLayer = graphicAnimator.getLocationLayer().getSceneLayer();
            boolean found = this.animatedGraphicsBySceneLayer.remove(sceneLayer, graphicAnimator);
            assert (found) : "animated graphic not found";
            if (this.animatedGraphicsBySceneLayer.getAll(sceneLayer).isEmpty()) {
                this.animatedGraphicsBySceneLayer.remove(sceneLayer);
                this.fireStateChanged();
            }
        }
    }

    private void updateViewImmediate() {
        this.updateViewImmediate(false);
    }

    private void updateViewImmediate(boolean allLayers) {
        this.parallaxEngine.render(this.panel.getImagePanel(), allLayers ? null : this.changedLayers);
        if (!this.isSyncRedraw()) {
            this.panel.repaint();
        }
        this.fireInfoChanged();
    }

    private void updateParallaxEngine() {
        SceneLocation location;
        this.parallaxEngine.clearLayers();
        this.homeViewpoint = null;
        ProjectComponent target = this.getAdjustedTarget();
        List<SceneLocation> locations = new ArrayList<SceneLocation>();
        if (target instanceof LocationTransition) {
            LocationTransition hotspot = (LocationTransition)target;
            LocationTransitionAnimation currentTransition = hotspot.getTransitionAnimation();
            if (currentTransition != null) {
                locations = currentTransition.getTransitionLocations();
                this.homeViewpoint = currentTransition.getFromLocation().getViewpoint();
            }
        } else if (target != null && (location = target.getAncestorByType(SceneLocation.class)) != null) {
            locations.add(location);
            this.homeViewpoint = location.getViewpoint();
        }
        for (SceneLocation location2 : locations) {
            this.addLocation(location2, new Transform3D());
        }
        this.updateParallaxEngineGraphics();
        if (this.homeViewpoint != null) {
            this.setCurrentViewpoint(this.homeViewpoint.getCamera(), this.homeViewpoint.getViewport());
        } else {
            this.allLayersNeedUpdate();
        }
    }

    private void updateParallaxEngineGraphics() {
        for (SceneLocationLayer locLayer : this.graphicsByLocationLayer.keySet()) {
            this.parallaxEngine.setLayerGraphics(locLayer, (List)this.graphicsByLocationLayer.get(locLayer));
        }
        if (this.selectedGraphicAnimator != null) {
            SceneLocationLayer locLayer = this.selectedGraphicAnimator.getLocationLayer();
            this.parallaxEngine.setLayerGraphics(locLayer, Collections.singletonList(this.selectedGraphicAnimator));
        }
    }

    private void updateGraphicsFromState(Set<SceneLayer> changedLayers) {
        for (Scene scene : this.getCard().getScenes()) {
            for (SceneLayer sceneLayer : scene.getSceneLayers()) {
                if (changedLayers != null && !changedLayers.contains(sceneLayer)) continue;
                SceneLayerState state = this.layerStates.get(sceneLayer);
                for (GraphicAnimator graphicAnimator : this.animatedGraphicsBySceneLayer.getAll(sceneLayer)) {
                    graphicAnimator.removeListener(this.animationListener);
                    graphicAnimator.stop();
                }
                this.animatedGraphicsBySceneLayer.remove(sceneLayer);
                for (SceneLocationLayer locLayer : scene.getLocationLayers(sceneLayer)) {
                    this.graphicsByLocationLayer.clearValues(locLayer);
                    for (LocationLayerGraphic graphic : locLayer.getGraphicsForState(sceneLayer, state, false)) {
                        if (graphic instanceof HoleGraphic) {
                            graphic.clearCacheImage();
                        }
                        GraphicAnimator graphicAnimator = new GraphicAnimator(graphic, this, 20);
                        graphicAnimator.setCurrentGridCoords(this.currentGridCoords);
                        this.graphicsByLocationLayer.putLast(locLayer, graphicAnimator);
                        if (!graphicAnimator.isAnimated() || changedLayers == null || !changedLayers.contains(sceneLayer)) continue;
                        graphicAnimator.addListener(this.animationListener);
                        this.animatedGraphicsBySceneLayer.putLast(sceneLayer, graphicAnimator);
                        graphicAnimator.setElapsedFraction(0.0f);
                        graphicAnimator.start();
                        SimulationClock clock = this.gridViewerPanel.getSimulationClock();
                        graphicAnimator.setElapsedTicks(clock.getElapsedTicks(), clock.getElapsedMillis());
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("Starting animation " + graphicAnimator + " at: " + clock.getElapsedTicks());
                    }
                }
            }
        }
    }

    private Set<LocationTransition> updateTransitions() {
        this.hotspots.clear();
        HashSet<LocationTransition> autoTransitions = new HashSet<LocationTransition>();
        ProjectComponent target = this.getAdjustedTarget();
        if (target instanceof SceneLocation) {
            ArrayList<LocationTransition> newHotspots = new ArrayList<LocationTransition>();
            ArrayList<LocationTransition> oldHotspots = new ArrayList<LocationTransition>(this.panel.getHotspots());
            for (LocationTransition transition : ((SceneLocation)target).getTransitions()) {
                if (!transition.isActiveForState(this.getCurrentStates())) continue;
                if (transition.getHotspotStyle() == LocationTransition.HotspotStyle.NONE) {
                    autoTransitions.add(transition);
                    continue;
                }
                newHotspots.add(transition);
            }
            for (LocationTransition oldHotspot : oldHotspots) {
                if (newHotspots.contains(oldHotspot)) continue;
                this.panel.removeHotspot(oldHotspot, false);
            }
            for (LocationTransition newHotspot : newHotspots) {
                if (oldHotspots.contains(newHotspot)) continue;
                this.panel.addHotspot(newHotspot, false);
            }
            this.hotspots.addAll(newHotspots);
        } else if (target instanceof LocationTransition) {
            this.panel.clearHotspots(false);
            LocationTransition transition = (LocationTransition)target;
            if (transition.getHotspotStyle() != LocationTransition.HotspotStyle.NONE) {
                this.panel.addHotspot(transition, false);
            }
        }
        this.panel.repaint();
        return autoTransitions;
    }

    private void updateHoleGraphics() {
        HashSet<SceneLayer> changedLayers = new HashSet<SceneLayer>();
        for (SceneLocationLayer locLayer : this.graphicsByLocationLayer.keySet()) {
            for (GraphicAnimator graphicAnimator : (List)this.graphicsByLocationLayer.get(locLayer)) {
                if (!(graphicAnimator.getGraphic() instanceof HoleGraphic)) continue;
                graphicAnimator.getGraphic().clearCacheImage();
                changedLayers.add(locLayer.getSceneLayer());
            }
        }
        if (!changedLayers.isEmpty()) {
            this.layersNeedUpdate(changedLayers);
            this.updateViewImmediate();
        }
    }

    private void updateAmbientSound() {
        if (this.panel.isSelected()) {
            int crossFadeMillis;
            int startDelayMillis;
            ProjectComponent target = this.getTarget();
            if (target instanceof LocationTransition) {
                startDelayMillis = 0;
                crossFadeMillis = ((LocationTransition)target).getTransitionDuration();
            } else {
                startDelayMillis = 600;
                crossFadeMillis = 800;
            }
            LayeredAudioPlayer player = this.gridViewerPanel.getAudioPlayer();
            SoundClip clip = this.getAmbientSoundClip();
            if (!player.isPlaying("Ambient", clip)) {
                player.scheduleClip("Ambient", clip, true, startDelayMillis, crossFadeMillis, true);
            }
        }
    }

    private SoundClip getAmbientSoundClip() {
        ProjectComponent target = this.getTarget();
        SceneLocation location = null;
        if (target instanceof LocationTransition) {
            LocationTransition transition = (LocationTransition)target;
            location = transition.getDestLocation();
        }
        if (target instanceof SceneLocation) {
            location = this.getCurrentLocation();
        }
        SoundClip result = null;
        if (location != null) {
            result = location.getAmbientSound();
        }
        return result;
    }

    private void addLocation(SceneLocation location, Transform3D transform) {
        SceneLocationLayer selectedLayer = this.target instanceof SceneLocationLayer ? (SceneLocationLayer)this.target : null;
        for (SceneLocationLayer locationLayer : location.getLayers()) {
            if (selectedLayer != null && !CompareUtilities.equals(locationLayer.getSceneLayer(), selectedLayer.getSceneLayer())) continue;
            this.parallaxEngine.addLayer(locationLayer, new Transform3D(transform));
        }
        for (SceneLocation siblingLocation : location.getShowOtherLocations()) {
            this.addLocation(siblingLocation, transform);
        }
        SceneLocation bgLocation = location.getBackgroundLocation();
        if (bgLocation != null) {
            Transform3D cumulativeTransform;
            Transform3D bgTransform = location.getBackgroundCoordTransform();
            if (bgTransform == null) {
                cumulativeTransform = transform;
            } else {
                cumulativeTransform = new Transform3D(transform);
                cumulativeTransform.mul(bgTransform);
            }
            this.addLocation(bgLocation, cumulativeTransform);
        }
    }

    public static enum Option {
        SHOW_HOTSPOTS,
        SHOW_REFS,
        SHOW_MARGINS,
        SHOW_BOUNDARIES,
        SHOW_BACKGROUND;

    }
}

