/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class CardStack {
    private final Deque<Card> cards = new ArrayDeque<Card>();

    CardStack() {
    }

    boolean isEmpty() {
        return this.cards.isEmpty();
    }

    int size() {
        return this.cards.size();
    }

    Card getTopCard() {
        return this.cards.peek();
    }

    Card getUnderCard() {
        if (this.cards.size() < 2) {
            return null;
        }
        Iterator<Card> iter = this.cards.iterator();
        iter.next();
        return iter.next();
    }

    Card removeTopCard() {
        return this.cards.pop();
    }

    void removeCard(Card card) {
        this.cards.remove(card);
    }

    void addCard(Card card) {
        assert (card != null) : "Card is null";
        assert (!this.cards.contains(card)) : "Card already in cell";
        this.cards.push(card);
    }

    boolean contains(Card card) {
        return this.cards.contains(card);
    }
}

