/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.GridDirection;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.ShelfCoords;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;

public class CardShelves {
    private final int shelfSize;
    private Map<GridDirection, ArrayList<Card>> shelfMap;

    public CardShelves(Set<GridDirection> dirs, int shelfSize) {
        this.shelfSize = shelfSize;
        this.shelfMap = new EnumMap<GridDirection, ArrayList<Card>>(GridDirection.class);
        for (GridDirection dir : dirs) {
            ArrayList<Object> shelfList = new ArrayList<Object>(shelfSize);
            for (int i = 0; i < shelfSize; ++i) {
                shelfList.add(null);
            }
            this.shelfMap.put(dir, shelfList);
        }
    }

    public void placeCard(Card card, ShelfCoords coords) {
        GridDirection dir = coords.getDir();
        if (!this.shelfMap.containsKey((Object)dir)) {
            throw new IllegalArgumentException("Invalid shelf direction: " + (Object)((Object)dir));
        }
        ArrayList<Card> cards = this.shelfMap.get((Object)coords.getDir());
        cards.set(coords.getIndex(), card);
    }

    public Card removeCard(ShelfCoords coords) {
        GridDirection dir = coords.getDir();
        if (!this.shelfMap.containsKey((Object)dir)) {
            throw new IllegalArgumentException("Invalid shelf direction: " + (Object)((Object)dir));
        }
        ArrayList<Card> cards = this.shelfMap.get((Object)coords.getDir());
        Card removed = cards.get(coords.getIndex());
        cards.set(coords.getIndex(), null);
        return removed;
    }

    public Card getCard(ShelfCoords coords) {
        GridDirection dir = coords.getDir();
        if (!this.shelfMap.containsKey((Object)dir)) {
            throw new IllegalArgumentException("Invalid shelf direction: " + (Object)((Object)dir));
        }
        ArrayList<Card> cards = this.shelfMap.get((Object)coords.getDir());
        return cards.get(coords.getIndex());
    }

    public ShelfCoords getCoords(Card card) {
        for (GridDirection dir : this.shelfMap.keySet()) {
            ArrayList<Card> shelfList = this.shelfMap.get((Object)dir);
            for (int i = 0; i < this.shelfSize; ++i) {
                if (!card.equals(shelfList.get(i))) continue;
                return new ShelfCoords(dir, i);
            }
        }
        return null;
    }

    public ShelfCoords getEmptyCell() {
        for (GridDirection dir : this.shelfMap.keySet()) {
            ArrayList<Card> shelfList = this.shelfMap.get((Object)dir);
            for (int i = 0; i < this.shelfSize; ++i) {
                if (shelfList.get(i) != null) continue;
                return new ShelfCoords(dir, i);
            }
        }
        return null;
    }

    public int getShelfSize() {
        return this.shelfSize;
    }
}

