/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.layeredimage.LayeredImagePanel;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerProperties;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewer;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewerListener;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridViewerListener;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridViewerPanel;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.StateEditorPanel;
import com.sodiumarc.patchwork.util.TargetableDialog;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CardInfoPanel
extends JPanel {
    public static final Icon SNAPSHOT_ICON = IconLoader.loadIcon("silk/camera.png");
    private JLabel cardNameLabel = new JLabel();
    private JLabel cardInfoLabel;
    private JButton stateEditorButton;
    private JButton snapshotButton;
    private final CardViewerListener cardViewerListener;
    private final StateEditorPanel stateEditorPanel;
    private final TargetableDialog<CardViewer> stateEditorDialog;
    private JFileChooser fileChooser;
    private CardViewer cardViewer;

    public CardInfoPanel(GridViewerPanel gridViewer) {
        super(new BorderLayout(8, 0));
        Font labelFont = this.cardNameLabel.getFont();
        Font italFont = new Font(labelFont.getName(), 2, labelFont.getSize());
        this.cardNameLabel.setFont(italFont);
        this.cardNameLabel.setIcon(Card.ICON);
        this.cardInfoLabel = new JLabel();
        this.cardInfoLabel.setFont(italFont);
        this.stateEditorPanel = new StateEditorPanel();
        this.stateEditorDialog = new TargetableDialog<CardViewer>(SwingUtilities.getWindowAncestor(this), "Edit Location State", Dialog.ModalityType.MODELESS, new Dimension(400, 400), this.stateEditorPanel);
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(false);
        gridViewer.addGridListener(new GridViewerListener(){

            @Override
            public void selectionChanged(GridViewerPanel source, CardViewer cardViewer) {
                CardInfoPanel.this.setCardViewer(source.getSelectedCardViewer());
            }

            @Override
            public void gridContentsChanged(GridViewerPanel source) {
            }

            @Override
            public void mouseOverChanged(GridViewerPanel source, CardViewer overCardViewer) {
            }
        });
        this.cardViewerListener = new CardViewerListener(){

            @Override
            public void infoChanged(CardViewer source) {
                CardInfoPanel.this.update();
            }

            @Override
            public void locationChanged(CardViewer source) {
            }

            @Override
            public void stateChanged(CardViewer source) {
            }

            @Override
            public void targetChanged(CardViewer source) {
            }
        };
        this.stateEditorButton = this.createButton(SceneLayerState.ICON);
        this.stateEditorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CardInfoPanel.this.stateEditorDialog.showDialog();
            }
        });
        this.snapshotButton = this.createButton(SNAPSHOT_ICON);
        this.snapshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CardInfoPanel.this.onSnapShot();
            }
        });
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        buttonPanel.add(this.stateEditorButton);
        buttonPanel.add(this.snapshotButton);
        this.add((Component)this.cardNameLabel, "West");
        this.add((Component)this.cardInfoLabel, "Center");
        this.add((Component)buttonPanel, "East");
        this.setCardViewer(gridViewer.getSelectedCardViewer());
    }

    private void setCardViewer(CardViewer cardViewer) {
        if (this.cardViewer != null) {
            this.cardViewer.removeCardListener(this.cardViewerListener);
        }
        this.cardViewer = cardViewer;
        if (this.cardViewer != null) {
            this.cardViewer.addCardListener(this.cardViewerListener);
        }
        this.stateEditorDialog.getTargetablePanel().setTarget(cardViewer);
        this.update();
    }

    private void update() {
        if (this.cardViewer != null) {
            this.cardNameLabel.setText(this.cardViewer.getCard().toString() + ":");
            this.cardNameLabel.setEnabled(true);
            this.cardInfoLabel.setIcon(this.cardViewer.getInfoIcon());
            this.cardInfoLabel.setText(this.cardViewer.getInfoText());
            this.stateEditorButton.setEnabled(this.cardViewer.getCurrentLocation() != null);
            this.snapshotButton.setEnabled(true);
        } else {
            this.cardNameLabel.setText("(no selection)");
            this.cardNameLabel.setEnabled(false);
            this.cardInfoLabel.setIcon(null);
            this.cardInfoLabel.setText("");
            this.stateEditorButton.setEnabled(false);
            this.snapshotButton.setEnabled(false);
        }
    }

    private JButton createButton(Icon icon) {
        JButton result = new JButton(icon);
        result.setPreferredSize(new Dimension(icon.getIconWidth() + 10, icon.getIconHeight() + 8));
        return result;
    }

    protected void onSnapShot() {
        File snapshotDir = PatchworkComposerProperties.getIODirectory(IOFileType.SNAPSHOT);
        this.fileChooser.resetChoosableFileFilters();
        this.fileChooser.addChoosableFileFilter(LayeredImagePanel.IMAGE_FILTER);
        String filename = this.cardViewer.getCard().getDisplayName(false);
        ProjectComponent target = this.cardViewer.getTarget();
        if (target instanceof SceneLocation) {
            filename = target.getParentComponent().getID() + "." + target.getID();
        } else if (target instanceof SceneLocationLayer) {
            filename = target.getParentComponent().getParentComponent().getID() + "." + target.getParentComponent().getID() + "_L" + target.getID();
        }
        filename = filename + ".png";
        this.fileChooser.setSelectedFile(new File(snapshotDir, filename));
        int result = this.fileChooser.showSaveDialog(SwingUtilities.getRoot(this));
        if (result == 0) {
            int confirm;
            File file = this.fileChooser.getSelectedFile();
            if (file.exists() && (confirm = JOptionPane.showConfirmDialog(this, "File exists. Overwrite?", "Confirm Overwrite", 0)) != 0) {
                return;
            }
            BufferedImage snapshot = this.cardViewer.getSnapshotImage(true, false);
            if (snapshot != null) {
                try {
                    ImageUtils.saveImage(snapshot, file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

