/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.scenecomposer.sound.LayeredAudioPlayer;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AudioPlayerControlPanel
extends LabeledRowPanel {
    private final LayeredAudioPlayer audioPlayer;

    public AudioPlayerControlPanel(LayeredAudioPlayer audioPlayer) {
        this.audioPlayer = audioPlayer;
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("Music Volume", (Component)this.makeVolumeSlider("Score Foreground", "Score Background")));
        rows.add(new LabeledRowPanel.LabeledRow("SFX Volume", (Component)this.makeVolumeSlider("SFX")));
        rows.add(new LabeledRowPanel.LabeledRow("Ambience Volume", (Component)this.makeVolumeSlider("Ambient")));
        this.setRows(rows);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private JSlider makeVolumeSlider(final String ... layerIDs) {
        final JSlider result = new JSlider();
        result.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = result.getValue();
                float volume = (float)value / 50.0f;
                for (String layerID : layerIDs) {
                    AudioPlayerControlPanel.this.audioPlayer.setLayerVolume(layerID, volume);
                }
            }
        });
        return result;
    }
}

