/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.table;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.table.ProjectComponentTable;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;

public class LocationLayerGraphicTable
extends ProjectComponentTable<SceneLocationLayer> {
    public static final Icon DELETE_ICON = IconLoader.loadIcon("silk/cross.png");

    public LocationLayerGraphicTable() {
        super(EnumSet.of(ProjectComponentTable.ButtonColumn.Del), "State / Graphic", true);
    }

    @Override
    protected void getRows(SceneLocationLayer target, List<ProjectComponent> tableRows) {
        SceneLayer layer;
        if (target != null && (layer = target.getSceneLayer()) != null) {
            for (SceneLayerState state : layer.getStates(true)) {
                tableRows.add(state);
                for (LocationLayerGraphic graphic : target.getGraphicsForState(layer, state, false)) {
                    tableRows.add(graphic);
                }
            }
        }
    }

    @Override
    protected boolean isSectionHeaderRow(int row, List<ProjectComponent> tableRows) {
        ProjectComponent component = tableRows.get(row);
        return component instanceof SceneLayerState;
    }

    @Override
    protected void removeRow(int row, List<ProjectComponent> tableRows) {
        SceneLayerState state = this.getStateForRow(row, tableRows);
        if (state == null) {
            return;
        }
        ProjectComponent component = tableRows.get(row);
        if (component instanceof LocationLayerGraphic) {
            ((LocationLayerGraphic)component).removeAttachedState(state);
            tableRows.remove(row);
        }
    }

    @Override
    protected boolean isRowRemovable(int row, List<ProjectComponent> tableRows) {
        ProjectComponent projectComponent = tableRows.get(row);
        return !(projectComponent instanceof SceneLayerState);
    }

    @Override
    protected void insertRow(int row, ProjectComponent component, List<ProjectComponent> tableRows) {
        SceneLayerState state = this.getStateForRow(row, tableRows);
        if (state == null) {
            return;
        }
        LocationLayerGraphic graphic = (LocationLayerGraphic)component;
        if (!graphic.getAttachedStates().contains(state)) {
            graphic.addAttachedState(state);
            tableRows.add(row, graphic);
        }
    }

    @Override
    protected boolean isRowDragable(int row, List<ProjectComponent> tableRows) {
        return this.isRowRemovable(row, tableRows);
    }

    private SceneLayerState getStateForRow(int row, List<ProjectComponent> tableRows) {
        for (int i = row - 1; i >= 0; --i) {
            if (!(tableRows.get(i) instanceof SceneLayerState)) continue;
            return (SceneLayerState)tableRows.get(i);
        }
        return null;
    }
}

