/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.sound;

import com.sodiumarc.patchwork.app.scenecomposer.sound.ArrayClip;
import com.sodiumarc.patchwork.app.scenecomposer.sound.CrossFader;
import com.sodiumarc.patchwork.app.scenecomposer.sound.Transitioner;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;

public class SwitchableArrayClip
extends ArrayClip {
    private byte[][] audioData;
    private volatile int activeStream = 0;
    private Queue<Integer> pendingSwitches = new LinkedList<Integer>();
    private Transitioner transitioner = new CrossFader();
    private int transitionLength = 300;
    private int maxOutputBufferLen;

    @Override
    public void open(AudioInputStream stream) throws LineUnavailableException, IOException {
        if (stream.getFormat().getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            stream = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, stream);
        }
        this.frameLength = (int)stream.getFrameLength();
        this.format = stream.getFormat();
        this.frameSize = this.format.getFrameSize();
        int len = this.frameLength * this.frameSize;
        this.audioData = new byte[1][len];
        int numRead = 0;
        int offset = 0;
        while (numRead != -1) {
            numRead = stream.read(this.audioData[0], offset - numRead, len - numRead);
        }
        this.setLoopPoints(0, -1);
        this.framePos = 0;
        this.maxOutputBufferLen = (int)(this.format.getSampleRate() / 20.0f) * this.frameSize;
        this.active = false;
        this.dataLine = AudioSystem.getSourceDataLine(this.format);
        this.dataLine.open(this.format);
    }

    public synchronized void addStreams(AudioInputStream ... streams) throws IOException {
        int i;
        if (!this.isOpen()) {
            throw new IllegalStateException("Clip must be opened first!");
        }
        byte[][] temp = new byte[this.audioData.length + streams.length][];
        for (i = 0; i < this.audioData.length; ++i) {
            temp[i] = this.audioData[i];
        }
        for (i = 0; i < streams.length; ++i) {
            if (streams[i].getFormat().getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                streams[i] = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, streams[i]);
            }
            if (!streams[i].getFormat().matches(this.format) || streams[i].getFrameLength() != (long)this.frameLength) {
                throw new IllegalArgumentException("Audio format and length must be identical to the first audio stream!");
            }
            int len = this.frameLength * this.frameSize;
            temp[this.audioData.length + i] = new byte[len];
            int numRead = 0;
            int offset = 0;
            while (numRead != -1) {
                numRead = streams[i].read(temp[this.audioData.length + i], offset - numRead, len - numRead);
            }
        }
        this.audioData = temp;
    }

    public synchronized void switchStream(int streamNumber) {
        if (streamNumber >= this.audioData.length || streamNumber < 0) {
            throw new IllegalArgumentException("Stream number " + streamNumber + " does not exist!");
        }
        if (!this.active && this.pendingSwitches.isEmpty()) {
            this.activeStream = streamNumber;
        } else {
            this.pendingSwitches.add(streamNumber);
        }
    }

    @Override
    public void start() {
        if (this.active) {
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SwitchableArrayClip.this.dataLine.start();
                SwitchableArrayClip.this.active = true;
                do {
                    SwitchableArrayClip.this.timeStarted = System.currentTimeMillis() * 1000L - SwitchableArrayClip.this.framesToMicroseconds(SwitchableArrayClip.this.getFramePosition());
                    while (SwitchableArrayClip.this.active && (SwitchableArrayClip.this.loopCount > 0 && SwitchableArrayClip.this.framePos <= SwitchableArrayClip.this.loopEnd || SwitchableArrayClip.this.loopCount == 0 && SwitchableArrayClip.this.framePos < SwitchableArrayClip.this.frameLength)) {
                        Integer nextStream;
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            nextStream = (Integer)SwitchableArrayClip.this.pendingSwitches.poll();
                        }
                        if (nextStream != null) {
                            byte[] transitionBuffer = new byte[SwitchableArrayClip.this.transitionLength * SwitchableArrayClip.this.frameSize];
                            SwitchableArrayClip.this.transitioner.process(SwitchableArrayClip.this.audioData[SwitchableArrayClip.this.activeStream], SwitchableArrayClip.this.audioData[nextStream], SwitchableArrayClip.this.framePos * SwitchableArrayClip.this.frameSize, transitionBuffer, 0, SwitchableArrayClip.this.transitionLength, SwitchableArrayClip.this.format);
                            SwitchableArrayClip.this.framePos += SwitchableArrayClip.this.dataLine.write(transitionBuffer, 0, SwitchableArrayClip.this.transitionLength * SwitchableArrayClip.this.frameSize) / SwitchableArrayClip.this.frameSize;
                            SwitchableArrayClip.this.activeStream = nextStream;
                            continue;
                        }
                        int buffered = SwitchableArrayClip.this.dataLine.getBufferSize() - SwitchableArrayClip.this.dataLine.available();
                        if (buffered >= SwitchableArrayClip.this.maxOutputBufferLen) {
                            try {
                                1.sleep(20L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                        int bytePos = SwitchableArrayClip.this.framePos * SwitchableArrayClip.this.frameSize;
                        SwitchableArrayClip.this.framePos = SwitchableArrayClip.this.framePos + SwitchableArrayClip.this.dataLine.write(SwitchableArrayClip.this.audioData[SwitchableArrayClip.this.activeStream], bytePos, Math.min(SwitchableArrayClip.this.maxOutputBufferLen - buffered, (SwitchableArrayClip.this.loopCount > 0 ? (SwitchableArrayClip.this.loopEnd + 1) * SwitchableArrayClip.this.frameSize : SwitchableArrayClip.this.audioData[0].length) - bytePos)) / SwitchableArrayClip.this.frameSize;
                    }
                    if (SwitchableArrayClip.this.loopCount <= 0) continue;
                    SwitchableArrayClip.this.framePos = SwitchableArrayClip.this.loopStart;
                } while (SwitchableArrayClip.this.active && SwitchableArrayClip.this.loopCount > 0 && --SwitchableArrayClip.this.loopCount >= 0);
                SwitchableArrayClip.this.active = false;
            }
        }.start();
    }

    public Transitioner getTransitioner() {
        return this.transitioner;
    }

    public void setTransitioner(Transitioner transitioner) {
        this.transitioner = transitioner;
    }

    public int getTransitionLength() {
        return this.transitionLength;
    }

    public void setTransitionLength(int transitionLength) {
        this.transitionLength = transitionLength;
    }

    @Override
    public void close() {
        this.dataLine.close();
        this.audioData = null;
    }
}

