/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.sound;

import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundClip;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundSequence;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundSequenceEntry;
import com.sodiumarc.patchwork.app.scenecomposer.sound.AudioClip;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.SimulationClock;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.SimulationClockListener;
import com.sodiumarc.patchwork.util.CompareUtilities;
import com.sodiumarc.patchwork.util.MathUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.log4j.Logger;

public class SoundPlayer {
    private boolean isRunning;
    private SoundClip currentClip;
    private final Deque<ClipTransition> scheduledTransitions = new ArrayDeque<ClipTransition>();
    private static final Logger LOGGER = Logger.getLogger(SoundPlayer.class);

    public SoundPlayer(SimulationClock clock) {
        clock.addListener(new SimulationClockListener(){

            @Override
            public void tick(int elapsedTicks, long elapsedMillis) {
                SoundPlayer.this.update(elapsedMillis);
            }
        });
        this.isRunning = true;
    }

    public void playClip(AudioClip clip) {
        clip.play();
    }

    public void playSequence(SoundSequence sequence, boolean jumpQueue) {
        boolean fistClip = true;
        for (SoundSequenceEntry entry : sequence.getEntries()) {
            this.playClip(entry.getSoundClip(), entry.getStartDelayMillis(), entry.getTransitionMillis(), entry.isLoop(), fistClip && jumpQueue);
            fistClip = false;
        }
    }

    public void playClip(SoundClip clip, int startDelayMillis, int transitionMillis, boolean loop, boolean jumpQueue) {
        SoundClip fromClip;
        if (jumpQueue) {
            while (!this.scheduledTransitions.isEmpty() && !this.scheduledTransitions.peekLast().isCrossFadeInProgress()) {
                ClipTransition discarded = this.scheduledTransitions.removeLast();
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Discarding transition to: " + discarded.getToClip());
            }
        }
        SoundClip soundClip = fromClip = this.scheduledTransitions.isEmpty() ? this.currentClip : this.scheduledTransitions.peekLast().getToClip();
        if (CompareUtilities.equals(fromClip, clip)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Scheduling clip: " + clip);
        }
        this.scheduledTransitions.addLast(new ClipTransition(fromClip, clip, startDelayMillis, transitionMillis, loop));
    }

    public void stop() {
        if (!this.isRunning) {
            return;
        }
        if (!this.scheduledTransitions.isEmpty()) {
            this.scheduledTransitions.pop().cancel();
        }
        this.scheduledTransitions.clear();
        if (this.currentClip != null) {
            this.currentClip.stop();
            this.currentClip = null;
        }
        this.isRunning = false;
    }

    public void start() {
        this.isRunning = true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void update(long elapsedMillis) {
        if (!this.isRunning) {
            return;
        }
        if (!this.scheduledTransitions.isEmpty()) {
            ClipTransition nextTransition = this.scheduledTransitions.peek();
            if (nextTransition.isFinished()) {
                this.currentClip = nextTransition.toClip;
                this.scheduledTransitions.pop();
            } else {
                nextTransition.update(elapsedMillis);
            }
        }
    }

    private static class ClipTransition {
        private final SoundClip fromClip;
        private final SoundClip toClip;
        private final int crossFadeMillis;
        private final int startDelayMillis;
        private final boolean loop;
        private long startTime = -1L;
        private boolean transitionInProgress;
        private boolean crossFadeInProgress;

        ClipTransition(SoundClip fromClip, SoundClip toClip, int startDelayMillis, int durationInMillis, boolean loop) {
            this.fromClip = fromClip;
            this.toClip = toClip;
            this.startDelayMillis = startDelayMillis;
            this.crossFadeMillis = durationInMillis;
            this.loop = loop;
        }

        SoundClip getToClip() {
            return this.toClip;
        }

        boolean isInProgress() {
            return this.transitionInProgress;
        }

        boolean isCrossFadeInProgress() {
            return this.crossFadeInProgress;
        }

        boolean isFinished() {
            return this.startTime >= 0L && !this.transitionInProgress;
        }

        void cancel() {
            if (this.crossFadeInProgress) {
                this.toClip.stop();
            }
        }

        void update(long elapsedMillis) {
            if (this.startTime < 0L) {
                this.start(elapsedMillis);
                return;
            }
            if (!this.isInProgress()) {
                return;
            }
            float crossFadeFraction = this.getCrossFadeFraction(elapsedMillis);
            if (crossFadeFraction < 0.0f) {
                return;
            }
            if (crossFadeFraction < 1.0f) {
                if (this.fromClip != null) {
                    this.fromClip.setFadeLevel(1.0f - this.getCrossFadeFraction(elapsedMillis));
                }
                if (this.toClip != null) {
                    this.toClip.setFadeLevel(this.getCrossFadeFraction(elapsedMillis));
                }
                if (!this.crossFadeInProgress) {
                    this.startClip(0.0f);
                    this.crossFadeInProgress = true;
                }
            } else {
                if (this.fromClip != null) {
                    this.fromClip.setFadeLevel(0.0f);
                    this.fromClip.stop();
                }
                if (this.toClip != null) {
                    this.toClip.setFadeLevel(1.0f);
                }
                this.transitionInProgress = false;
                if (!this.crossFadeInProgress) {
                    this.startClip(1.0f);
                }
                this.crossFadeInProgress = false;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Completed transition to: " + this.toClip);
                }
            }
        }

        private float getCrossFadeFraction(long elapsedMillis) {
            if (this.startTime < 0L) {
                return 0.0f;
            }
            long crossFadeStartTime = this.startTime + (long)this.startDelayMillis;
            if (this.crossFadeMillis == 0) {
                return elapsedMillis < crossFadeStartTime ? -1.0f : 1.0f;
            }
            long crossFadeEndTime = crossFadeStartTime + (long)this.crossFadeMillis;
            return (float)MathUtils.rangeFraction(elapsedMillis, crossFadeStartTime, crossFadeEndTime);
        }

        private void startClip(float initialFade) {
            if (this.toClip != null) {
                this.toClip.setFadeLevel(initialFade);
                this.toClip.play(this.loop);
            }
        }

        private void start(long elapsedMillis) {
            this.startTime = elapsedMillis;
            this.transitionInProgress = true;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Beginning transition to: " + this.toClip);
            }
        }
    }
}

