/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.sound;

import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundSequenceEntry;
import com.sodiumarc.patchwork.util.Collection.MultiHashMap;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.Collection.StringMap;
import com.sodiumarc.patchwork.util.Collection.StringMultiMap;
import com.sodiumarc.patchwork.util.xml.SimpleTranscoder;
import com.sodiumarc.patchwork.util.xml.StringMapTranscoder;
import com.sodiumarc.patchwork.util.xml.StringMultiMapTranscoder;
import java.util.HashMap;
import java.util.Map;

public class LayeredAudioSaveData {
    private final StringMap entryGUIDByLayer;
    private final StringMultiMap scheduledEntryGUIDsByLayer;
    private final StringMap transitionTimesByLayer;
    private PatchworkProject project;

    public LayeredAudioSaveData(Map<String, SoundSequenceEntry> currentEntryByLayer, MultiMap<String, SoundSequenceEntry> scheduledEntriesByLayer, Map<String, Long> transitionTimesByLayer, long elapsedMillis) {
        this.entryGUIDByLayer = new StringMap();
        this.scheduledEntryGUIDsByLayer = new StringMultiMap();
        for (Map.Entry<String, SoundSequenceEntry> entry : currentEntryByLayer.entrySet()) {
            this.entryGUIDByLayer.put(entry.getKey(), entry.getValue().getGUID());
        }
        for (String string : scheduledEntriesByLayer.keySet()) {
            for (SoundSequenceEntry sequenceEntry : scheduledEntriesByLayer.getAll(string)) {
                this.scheduledEntryGUIDsByLayer.putLast(string, sequenceEntry.getGUID());
            }
        }
        this.transitionTimesByLayer = new StringMap();
        for (Map.Entry<String, Comparable<ProjectComponent>> entry : transitionTimesByLayer.entrySet()) {
            this.transitionTimesByLayer.put(entry.getKey(), Long.toString((Long)entry.getValue() - elapsedMillis));
        }
    }

    public Map<String, SoundSequenceEntry> getCurrentEntryByLayer() {
        HashMap<String, SoundSequenceEntry> result = new HashMap<String, SoundSequenceEntry>();
        if (this.project != null) {
            for (Map.Entry entry : this.entryGUIDByLayer.entrySet()) {
                ProjectComponent component = this.project.resolveGUID((String)entry.getValue());
                if (!(component instanceof SoundSequenceEntry)) continue;
                result.put((String)entry.getKey(), (SoundSequenceEntry)component);
            }
        }
        return result;
    }

    public Map<String, Long> getTransitionTimesByLayer(long elapsedMillis) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (Map.Entry entry : this.transitionTimesByLayer.entrySet()) {
            result.put((String)entry.getKey(), elapsedMillis + Long.parseLong((String)entry.getValue()));
        }
        return result;
    }

    public MultiMap<String, SoundSequenceEntry> getScheduledEntriesByLayer() {
        MultiHashMap<String, SoundSequenceEntry> result = new MultiHashMap<String, SoundSequenceEntry>();
        if (this.project != null) {
            for (String key : this.scheduledEntryGUIDsByLayer.keySet()) {
                for (String entryGUID : this.scheduledEntryGUIDsByLayer.getAll(key)) {
                    ProjectComponent component = this.project.resolveGUID(entryGUID);
                    result.putLast(key, (SoundSequenceEntry)component);
                }
            }
        }
        return result;
    }

    public void setProject(PatchworkProject project) {
        this.project = project;
    }

    private LayeredAudioSaveData(StringMap entryGUIDByLayer, StringMultiMap scheduledEntryGUIDsByLayer, StringMap transitionTimesByLayer) {
        this.entryGUIDByLayer = entryGUIDByLayer == null ? new StringMap() : entryGUIDByLayer;
        this.scheduledEntryGUIDsByLayer = scheduledEntryGUIDsByLayer == null ? new StringMultiMap() : scheduledEntryGUIDsByLayer;
        this.transitionTimesByLayer = transitionTimesByLayer == null ? new StringMap() : transitionTimesByLayer;
    }

    public static class Transcoder
    extends SimpleTranscoder<LayeredAudioSaveData> {
        private static final String ELEM_NAME = "LayeredAudioSaveData";
        private static final String FIELD_ENTRY_GUID_BY_LAYER = "entryGUIDByLayer";
        private static final String FIELD_SCHEDULED_ENTRY_GUIDS_BY_LAYER = "scheduledEntryGUIDsByLayer";
        private static final String FIELD_TRANSITION_TIMES_BY_LAYER = "transitionTimesByLayer";

        public Transcoder() {
            super(ELEM_NAME, LayeredAudioSaveData.class);
            this.setFieldTranscoder(FIELD_ENTRY_GUID_BY_LAYER, new StringMapTranscoder("StringMap"));
            this.setFieldTranscoder(FIELD_TRANSITION_TIMES_BY_LAYER, new StringMapTranscoder("StringMap"));
            this.setFieldTranscoder(FIELD_SCHEDULED_ENTRY_GUIDS_BY_LAYER, new StringMultiMapTranscoder("StringMultiMap"));
        }

        @Override
        protected void getAttributes(LayeredAudioSaveData object, Map<String, String> destination) {
        }

        @Override
        protected void getChildren(LayeredAudioSaveData object, MultiMap<String, Object> destination) {
            destination.putLast(FIELD_ENTRY_GUID_BY_LAYER, object.entryGUIDByLayer);
            destination.putLast(FIELD_TRANSITION_TIMES_BY_LAYER, object.transitionTimesByLayer);
            destination.putLast(FIELD_SCHEDULED_ENTRY_GUIDS_BY_LAYER, object.scheduledEntryGUIDsByLayer);
        }

        @Override
        protected LayeredAudioSaveData decode(Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            StringMap entryGUIDByLayer = (StringMap)decodedChildren.getFirst(FIELD_ENTRY_GUID_BY_LAYER);
            StringMap transitionTimesByLayer = (StringMap)decodedChildren.getFirst(FIELD_TRANSITION_TIMES_BY_LAYER);
            StringMultiMap scheduledEntryGUIDsByLayer = (StringMultiMap)decodedChildren.getFirst(FIELD_SCHEDULED_ENTRY_GUIDS_BY_LAYER);
            LayeredAudioSaveData result = new LayeredAudioSaveData(entryGUIDByLayer, scheduledEntryGUIDsByLayer, transitionTimesByLayer);
            return result;
        }
    }
}

