/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.sound;

import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundClip;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundSequence;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundSequenceEntry;
import com.sodiumarc.patchwork.app.scenecomposer.sound.AudioPlayer;
import com.sodiumarc.patchwork.app.scenecomposer.sound.LayeredAudioSaveData;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.SimulationClock;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.SimulationClockListener;
import com.sodiumarc.patchwork.util.Collection.MultiHashMap;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.CompareUtilities;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LayeredAudioPlayer {
    public static final String SCORE_BACKGROUND = "Score Background";
    public static final String SCORE_FOREGROUND = "Score Foreground";
    public static final String AMBIENT = "Ambient";
    public static final String SFX = "SFX";
    public static final Set<String> DEFAULT_LAYERS = new HashSet<String>();
    private final AudioPlayer audioPlayer = new AudioPlayer();
    private final SimulationClock clock;
    private final Set<String> layerIDs;
    private final Map<String, String> currentTrackByLayer;
    private final Map<String, Float> trackVolumeByLayer;
    private final Map<String, Float> layerVolumeByLayer;
    private final Map<String, SoundSequenceEntry> currentEntryByLayer;
    private final MultiMap<String, SoundSequenceEntry> scheduledEntriesByLayer;
    private final Map<String, Long> transitionTimesByLayer;
    private static final Logger LOGGER;

    public LayeredAudioPlayer(SimulationClock clock) {
        this(DEFAULT_LAYERS, clock);
    }

    public LayeredAudioPlayer(Set<String> layerIDs, SimulationClock clock) {
        this.clock = clock;
        this.layerIDs = new HashSet<String>();
        this.layerIDs.addAll(layerIDs);
        this.currentTrackByLayer = new HashMap<String, String>();
        this.layerVolumeByLayer = new HashMap<String, Float>();
        this.trackVolumeByLayer = new HashMap<String, Float>();
        this.currentEntryByLayer = new HashMap<String, SoundSequenceEntry>();
        this.scheduledEntriesByLayer = new MultiHashMap<String, SoundSequenceEntry>();
        this.transitionTimesByLayer = new HashMap<String, Long>();
        clock.addListener(new SimulationClockListener(){

            @Override
            public void tick(int elapsedTicks, long elapsedMillis) {
                LayeredAudioPlayer.this.update(elapsedMillis);
            }
        });
    }

    public void start() {
        this.audioPlayer.start();
    }

    public void stop() {
        this.audioPlayer.stopAllTracks();
        this.audioPlayer.stop();
    }

    public void stopAllLayers() {
        this.audioPlayer.stopAllTracks();
        this.currentTrackByLayer.clear();
        this.currentEntryByLayer.clear();
        this.scheduledEntriesByLayer.clear();
        this.transitionTimesByLayer.clear();
    }

    public boolean isPlaying() {
        return !this.currentTrackByLayer.isEmpty() || !this.scheduledEntriesByLayer.isEmpty();
    }

    public boolean isRunning() {
        return this.audioPlayer.isActive();
    }

    public void playClip(String layerID, SoundClip clip, boolean loop, int crossFadeMillis) {
        this.playClip(layerID, clip, loop, clip.getBaseVolume(), crossFadeMillis);
    }

    public void playClip(String layerID, SoundClip clip, boolean loop, float baseVolume, int crossFadeMillis) {
        String newTrackId;
        if (!this.isRunning()) {
            throw new IllegalStateException("Not running");
        }
        if (!this.layerIDs.contains(layerID)) {
            throw new IllegalArgumentException("No such layer: " + layerID);
        }
        this.trackVolumeByLayer.put(layerID, Float.valueOf(baseVolume));
        String currentTrackId = this.currentTrackByLayer.get(layerID);
        String string = newTrackId = clip == null ? null : layerID + "-" + clip.getGUID();
        if (!CompareUtilities.equals(currentTrackId, newTrackId)) {
            byte[] soundData;
            if (currentTrackId != null) {
                this.audioPlayer.stopTrack(currentTrackId, crossFadeMillis);
            }
            this.currentTrackByLayer.remove(layerID);
            if (clip != null && (soundData = clip.getSoundData()) != null) {
                this.audioPlayer.playTrack(newTrackId, soundData, clip.getAudioFormat(), loop ? -1 : 1, this.getAdjustedVolume(layerID), crossFadeMillis);
                this.currentTrackByLayer.put(layerID, newTrackId);
            }
        } else if (currentTrackId != null) {
            this.audioPlayer.setTrackVolume(currentTrackId, this.getAdjustedVolume(layerID));
        }
    }

    public boolean isPlaying(String layerID, SoundClip clip) {
        if (clip == null) {
            return !this.currentTrackByLayer.containsKey(layerID);
        }
        String clipID = clip.getGUID();
        String trackID = layerID + "-" + clipID;
        return trackID.equals(this.currentTrackByLayer.get(layerID));
    }

    public void scheduleClip(String layerID, SoundClip clip, boolean loop, int startDelayMillis, int crossFadeMillis, boolean jumpQueue) {
        SoundSequenceEntry entry = new SoundSequenceEntry("CLIP");
        entry.setSoundClip(clip);
        entry.setStartDelayMillis(startDelayMillis);
        entry.setTransitionMillis(crossFadeMillis);
        entry.setLoop(loop);
        entry.setVolume(clip == null ? 0.0f : clip.getBaseVolume());
        this.scheduleEntry(layerID, entry, jumpQueue);
    }

    public void playSequence(SoundSequence sequence, boolean jumpQueue) {
        boolean firstClip = true;
        for (SoundSequenceEntry entry : sequence.getEntries()) {
            String layerID = entry.getLayerID();
            if (layerID != null) {
                this.scheduleEntry(entry.getLayerID(), entry, firstClip && jumpQueue);
            }
            firstClip = false;
        }
    }

    public void setLayerVolume(String layerID, float volume) {
        this.layerVolumeByLayer.put(layerID, Float.valueOf(volume));
        String trackID = this.currentTrackByLayer.get(layerID);
        if (trackID != null) {
            this.audioPlayer.setTrackVolume(trackID, this.getAdjustedVolume(layerID));
        }
    }

    public LayeredAudioSaveData getSaveData() {
        this.clearExpired();
        return new LayeredAudioSaveData(this.currentEntryByLayer, this.scheduledEntriesByLayer, this.transitionTimesByLayer, this.clock.getElapsedMillis());
    }

    public void loadSaveData(LayeredAudioSaveData saveData) {
        if (this.isPlaying()) {
            this.stopAllLayers();
        }
        if (saveData != null) {
            Map<String, SoundSequenceEntry> savedEntryByLayer = saveData.getCurrentEntryByLayer();
            for (Map.Entry<String, SoundSequenceEntry> entry : savedEntryByLayer.entrySet()) {
                String layerID = entry.getKey();
                SoundSequenceEntry soundSequenceEntry = entry.getValue();
                this.playEntry(layerID, soundSequenceEntry);
            }
            this.transitionTimesByLayer.putAll(saveData.getTransitionTimesByLayer(this.clock.getElapsedMillis()));
            MultiMap<String, SoundSequenceEntry> savedScheduledEntriesByLayer = saveData.getScheduledEntriesByLayer();
            for (String key : savedScheduledEntriesByLayer.keySet()) {
                for (SoundSequenceEntry sequenceEntry : savedScheduledEntriesByLayer.getAll(key)) {
                    this.scheduledEntriesByLayer.putLast(key, sequenceEntry);
                }
            }
        }
    }

    private float getAdjustedVolume(String layerID) {
        float result = 1.0f;
        if (this.trackVolumeByLayer.containsKey(layerID)) {
            result = this.trackVolumeByLayer.get(layerID).floatValue();
        }
        if (this.layerVolumeByLayer.containsKey(layerID)) {
            result *= this.layerVolumeByLayer.get(layerID).floatValue();
        }
        return result;
    }

    private void scheduleEntry(String layerID, SoundSequenceEntry entry, boolean jumpQueue) {
        if (!this.layerIDs.contains(layerID)) {
            throw new IllegalArgumentException("No such layer: " + layerID);
        }
        if (jumpQueue) {
            this.scheduledEntriesByLayer.clearValues("layerID");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Scheduling entry \"" + entry.getSoundClip() + "\" on layer " + layerID);
        }
        this.scheduledEntriesByLayer.putLast(layerID, entry);
    }

    private void playEntry(String layerID, SoundSequenceEntry entry) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Playing entry \"" + entry.getSoundClip() + "\" on layer " + layerID);
        }
        this.currentEntryByLayer.put(layerID, entry);
        this.playClip(layerID, entry.getSoundClip(), entry.isLoop(), entry.getVolume(), entry.getTransitionMillis());
    }

    private void clearExpired() {
        for (String layerID : this.layerIDs) {
            if (this.audioPlayer.isTrackPlaying(layerID)) continue;
            this.currentTrackByLayer.remove(layerID);
            this.currentEntryByLayer.remove(layerID);
        }
    }

    private void update(long elapsedMillis) {
        if (!this.isRunning()) {
            return;
        }
        for (String layerID : this.layerIDs) {
            long transitionTime;
            SoundSequenceEntry newEntry = this.scheduledEntriesByLayer.getFirst(layerID);
            if (newEntry == null) continue;
            if (!this.transitionTimesByLayer.containsKey(layerID)) {
                this.transitionTimesByLayer.put(layerID, elapsedMillis);
            }
            if (elapsedMillis < (transitionTime = this.transitionTimesByLayer.get(layerID).longValue()) + (long)newEntry.getStartDelayMillis()) continue;
            this.scheduledEntriesByLayer.removeFirst(layerID);
            if (this.scheduledEntriesByLayer.getAll(layerID).isEmpty()) {
                this.transitionTimesByLayer.remove(layerID);
            } else {
                this.transitionTimesByLayer.put(layerID, elapsedMillis + (long)newEntry.getTransitionMillis());
            }
            this.playEntry(layerID, newEntry);
        }
    }

    static {
        DEFAULT_LAYERS.add(SCORE_BACKGROUND);
        DEFAULT_LAYERS.add(SCORE_FOREGROUND);
        DEFAULT_LAYERS.add(AMBIENT);
        DEFAULT_LAYERS.add(SFX);
        LOGGER = Logger.getLogger(LayeredAudioPlayer.class);
    }
}

