/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.sound;

import com.sodiumarc.patchwork.app.scenecomposer.resource.ResourceManager;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public enum AudioClip {
    DOG_BARKING("dogbarking.wav"),
    CLAPPING("clapping.wav"),
    SD1("SFX_S_086123_003.aif"),
    SQUEAKY_WHEEL("Squeaks_Rusty_D_01623201.wav");

    private Clip clip;
    private FloatControl gainControl;
    private BooleanControl muteControl;

    private AudioClip(String fileName) {
        try {
            AudioInputStream audioInputStream = this.getInputStream(fileName);
            this.clip = AudioSystem.getClip();
            if (audioInputStream != null) {
                this.clip.open(audioInputStream);
                this.gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
                this.muteControl = (BooleanControl)this.clip.getControl(BooleanControl.Type.MUTE);
            }
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void play() {
        if (this.clip.isRunning()) {
            this.clip.stop();
        }
        this.clip.setFramePosition(0);
        this.clip.loop(1);
    }

    public boolean isPlaying() {
        return this.clip.isRunning();
    }

    public void setVolume(float volume) {
        if (this.gainControl == null) {
            return;
        }
        float dB = (float)(Math.log(volume) / Math.log(10.0) * 20.0);
        this.gainControl.setValue(dB);
    }

    public void setMuted(boolean muted) {
        if (this.muteControl == null) {
            return;
        }
        this.muteControl.setValue(muted);
    }

    public long getDurationMillis() {
        return this.clip.getMicrosecondLength() / 1000L;
    }

    public void addLineListener(LineListener listener) {
        this.clip.addLineListener(listener);
    }

    public void removeLineListener(LineListener listener) {
        this.clip.removeLineListener(listener);
    }

    public void updateFade() {
        int curFrame = this.clip.getFramePosition();
        int totalFrames = this.clip.getFrameLength();
        float fraction = (float)curFrame / (float)totalFrames;
        this.setVolume(fraction);
    }

    static void init() {
        AudioClip.values();
    }

    private AudioInputStream getInputStream(String fileName) throws UnsupportedAudioFileException, IOException {
        URL url = ResourceManager.getURL(fileName);
        if (url == null) {
            return null;
        }
        return AudioSystem.getAudioInputStream(url);
    }
}

