/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.resource;

import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerProperties;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class ResourceManager {
    public static BufferedImage getImageResourceByID(String id) {
        return ResourceManager.getImageResource(id + ".png");
    }

    public static BufferedImage getImageResource(String filename) {
        try {
            URL url = ResourceManager.getURL(filename);
            if (url == null) {
                File resourceFile = new File(PatchworkComposerProperties.getIODirectory(IOFileType.PUBLISH), filename);
                return ImageIO.read(resourceFile);
            }
            return ImageIO.read(url);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static InputStream getInputStream(String filename) {
        try {
            URL url = ResourceManager.getURL(filename);
            if (url != null) {
                return url.openStream();
            }
            File file = new File(PatchworkComposerProperties.getIODirectory(IOFileType.PUBLISH), filename);
            if (file.exists()) {
                return new FileInputStream(file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static File getFile(String filename) {
        try {
            URL url = ResourceManager.getURL(filename);
            if (url == null) {
                return new File(PatchworkComposerProperties.getIODirectory(IOFileType.PUBLISH), filename);
            }
            return new File(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static URL getURL(String name) {
        Class<ResourceManager> type = ResourceManager.class;
        String path = null;
        URL result = null;
        String packageName = type.getName();
        String packagePath = packageName.replace('.', '/');
        int index = packagePath.lastIndexOf(47);
        packageName = packageName.substring(0, index);
        packagePath = packagePath.substring(0, index);
        path = packagePath + "/" + name;
        ClassLoader loader = type.getClassLoader();
        result = loader != null ? loader.getResource(path) : ClassLoader.getSystemResource(path);
        return result;
    }

    public static void publishImageResource(BufferedImage image, String id) throws IOException {
        File resourceFile = new File(ResourceManager.getPublishDir(), id + ".png");
        ImageUtils.saveImage(image, resourceFile);
    }

    public static void publishSoundResource(AudioInputStream stream, String id) throws IOException {
        File resourceFile = new File(ResourceManager.getPublishDir(), id + ".wav");
        AudioSystem.write(stream, AudioFileFormat.Type.WAVE, resourceFile);
    }

    public static File getPublishDir() {
        return PatchworkComposerProperties.getIODirectory(IOFileType.PUBLISH);
    }

    public static long getLastModification(String fileName) {
        File file = new File(ResourceManager.getPublishDir(), fileName);
        if (!file.exists()) {
            return -1L;
        }
        return file.lastModified();
    }

    private ResourceManager() {
    }
}

