/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.parallax;

import com.sodiumarc.patchwork.app.scanimport.OffsetImage;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerApp;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.vecmath.Point3d;

public abstract class ParallaxedImage {
    private Camera homeCamera;
    private Rectangle4d homeViewport;
    private Dimension homeViewportDisplaySize;
    private Point3d refPoint;

    public ParallaxedImage() {
        this(new Camera("Camera"), PatchworkComposerApp.CAMERA_VIEWPORT, new Dimension(100, 100), new Point3d(0.0, 0.0, 0.0));
    }

    public ParallaxedImage(Camera homeCamera, Rectangle4d homeViewport, Dimension viewportDisplaySize, Point3d refPoint) {
        this.homeCamera = homeCamera;
        this.homeViewport = homeViewport;
        this.homeViewportDisplaySize = viewportDisplaySize;
        this.refPoint = refPoint;
    }

    public void getTransformedImage(Camera currentCamera, Rectangle4d currentViewport, Dimension viewportDisplaySize, OffsetImage destination, Composite composite, boolean highQuality) {
        AffineTransform parallaxTransform;
        OffsetImage homeImage = this.getHomeImage();
        if (homeImage == null || homeImage.getImage() == null) {
            return;
        }
        AffineTransform scaleTransform = this.getHomeScaleTransform(homeImage.getImage());
        AffineTransform offsetTransform = new AffineTransform();
        offsetTransform.setToTranslation(homeImage.getXOffset() - destination.getXOffset(), homeImage.getYOffset() - destination.getYOffset());
        Rectangle4d homeRect = this.getRefRect(this.homeCamera, this.homeViewport, this.homeViewportDisplaySize, 1.0f);
        Rectangle4d currentRect = this.getRefRect(currentCamera, currentViewport, viewportDisplaySize, 1.0f);
        AffineTransform fullTransform = parallaxTransform = this.getParallaxTransform(homeRect, currentRect);
        fullTransform.concatenate(offsetTransform);
        fullTransform.concatenate(scaleTransform);
        BufferedImage destImage = destination.getImage();
        Graphics2D g2 = (Graphics2D)destImage.getGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, destImage.getWidth(), destImage.getHeight());
        if (composite != null) {
            g2.setComposite(composite);
        } else {
            g2.setComposite(AlphaComposite.SrcOver);
        }
        if (highQuality) {
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
        g2.drawImage(homeImage.getImage(), fullTransform, null);
        g2.dispose();
    }

    public void setHomeCamera(Camera homeCamera) {
        this.homeCamera = homeCamera;
    }

    public void setHomeViewport(Rectangle4d homeViewport, Dimension displaySize) {
        this.homeViewport = homeViewport;
        this.homeViewportDisplaySize = displaySize;
    }

    public void setRefPoint(Point3d refPoint) {
        this.refPoint = refPoint;
    }

    protected abstract OffsetImage getHomeImage();

    protected final void drawRefRect(Graphics2D graphics, Camera currentCamera, Rectangle4d currentViewport, Dimension viewportDisplaySize, float rectSize, String label) {
        Rectangle4d homeRect = this.getRefRect(this.homeCamera, this.homeViewport, this.homeViewportDisplaySize, rectSize);
        Rectangle4d currentRect = this.getRefRect(currentCamera, currentViewport, viewportDisplaySize, rectSize);
        AffineTransform transform = this.getParallaxTransform(homeRect, currentRect);
        Rectangle4d refRect = homeRect.transform(transform);
        graphics.setColor(Color.RED);
        graphics.drawRect((int)refRect.getX(), (int)refRect.getY(), (int)refRect.getWidth(), (int)refRect.getHeight());
        graphics.drawString(label, (int)refRect.getX(), (int)refRect.getY() - 2);
    }

    private AffineTransform getHomeScaleTransform(BufferedImage homeImage) {
        AffineTransform result = new AffineTransform();
        if (homeImage.getWidth() == this.homeViewportDisplaySize.width && homeImage.getHeight() == this.homeViewportDisplaySize.height) {
            return result;
        }
        double xScale = (double)this.homeViewportDisplaySize.width / (double)homeImage.getWidth();
        double yScale = (double)this.homeViewportDisplaySize.height / (double)homeImage.getHeight();
        result.scale(xScale, yScale);
        return result;
    }

    private AffineTransform getParallaxTransform(Rectangle4d fromRect, Rectangle4d toRect) {
        double scale = toRect.getWidth() / fromRect.getWidth();
        double xTrans = toRect.getX() - fromRect.getX() * scale;
        double yTrans = toRect.getY() - fromRect.getY() * scale;
        AffineTransform transform = new AffineTransform();
        transform.translate(xTrans, yTrans);
        transform.scale(scale, scale);
        return transform;
    }

    private Rectangle4d getRefRect(Camera camera, Rectangle4d viewport, Dimension viewportDisplaySize, float rectSize) {
        Point3d refCamera = camera.globalToCamera(this.refPoint);
        Point3d topLeft = new Point3d(refCamera.getX() - (double)rectSize, refCamera.getY() + (double)rectSize, refCamera.getZ());
        Point3d bottomRight = new Point3d(refCamera.getX() + (double)rectSize, refCamera.getY() - (double)rectSize, refCamera.getZ());
        topLeft = camera.cameraToDisplay(topLeft, viewport, viewportDisplaySize);
        bottomRight = camera.cameraToDisplay(bottomRight, viewport, viewportDisplaySize);
        return new Rectangle4d(topLeft.getX(), topLeft.getY(), bottomRight.getX() - topLeft.getX(), bottomRight.getY() - topLeft.getY());
    }
}

