/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.parallax;

import com.sodiumarc.patchwork.animation.RampInterpFunction;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerApp;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.Viewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.parallax.ParallaxedGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GraphicAnimator;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Collection.MultiHashMap;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.CompareUtilities;
import com.sodiumarc.patchwork.util.Filter;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3d;
import org.apache.log4j.Logger;

public class ParallaxLayerBlender {
    private final SceneLayer sceneLayer;
    private final Set<SceneLocationLayer> sceneLocationLayers;
    private final List<SceneLocationLayer> blendLocationLayers;
    private final MultiMap<SceneLocationLayer, ParallaxedGraphic> graphicsByLocLayer;
    private final List<ParallaxedGraphic> parallaxLayers;
    private List<ParallaxedGraphic> blendParallaxLayers;
    private final Dimension outputSize;
    private final Transform3D coordTransform;
    private Camera currentCamera;
    private Rectangle4d currentViewport;
    private boolean showRefs;
    private boolean clipToOutput = true;
    private boolean showBoundaries;
    private static final DecimalFormat FRACTION_FORMAT = new DecimalFormat("0.000");
    private static final Logger LOGGER = Logger.getLogger(ParallaxLayerBlender.class);

    ParallaxLayerBlender(SceneLayer sceneLayer, SceneLocationLayer locationLayer, Dimension outputSize, Transform3D coordTransform) {
        this(sceneLayer, Collections.singletonList(locationLayer), outputSize, coordTransform);
    }

    ParallaxLayerBlender(SceneLayer sceneLayer, List<SceneLocationLayer> locationLayers, Dimension outputSize, Transform3D coordTransform) {
        this(sceneLayer, outputSize, coordTransform);
        assert (locationLayers.size() >= 1) : "Empty layer list";
        for (SceneLocationLayer locationLayer : locationLayers) {
            this.addLayer(locationLayer);
        }
    }

    ParallaxLayerBlender(SceneLayer sceneLayer, Dimension outputSize, Transform3D coordTransform) {
        this.sceneLayer = sceneLayer;
        this.outputSize = outputSize;
        this.coordTransform = coordTransform;
        this.sceneLocationLayers = new HashSet<SceneLocationLayer>();
        this.blendLocationLayers = new ArrayList<SceneLocationLayer>();
        this.graphicsByLocLayer = new MultiHashMap<SceneLocationLayer, ParallaxedGraphic>();
        this.parallaxLayers = new ArrayList<ParallaxedGraphic>();
        this.blendParallaxLayers = new ArrayList<ParallaxedGraphic>();
    }

    public SceneLayer getSceneLayer() {
        return this.sceneLayer;
    }

    public void addLayer(SceneLocationLayer locationLayer) {
        assert (locationLayer.getSceneLayer() == this.sceneLayer) : "Wrong scene layer: " + locationLayer;
        if (!this.sceneLocationLayers.contains(locationLayer)) {
            this.sceneLocationLayers.add(locationLayer);
            this.setLayerGraphics(locationLayer, null);
        }
    }

    public void setLayerGraphics(SceneLocationLayer locationLayer, List<? extends GraphicAnimator> graphics) {
        if (!this.sceneLocationLayers.contains(locationLayer)) {
            return;
        }
        for (ParallaxedGraphic parallaxedGraphic : new ArrayList<ParallaxedGraphic>(this.graphicsByLocLayer.getAll(locationLayer))) {
            this.parallaxLayers.remove(parallaxedGraphic);
            this.graphicsByLocLayer.remove(locationLayer, parallaxedGraphic);
        }
        if (graphics == null) {
            return;
        }
        for (GraphicAnimator graphicAnimator : graphics) {
            ParallaxedGraphic parallaxLayer = new ParallaxedGraphic(locationLayer, graphicAnimator, this.outputSize, this.coordTransform);
            parallaxLayer.setClipToOutput(this.clipToOutput);
            parallaxLayer.setShowBoundaries(this.showBoundaries);
            parallaxLayer.setShowRef(this.showRefs);
            this.parallaxLayers.add(parallaxLayer);
            this.graphicsByLocLayer.putLast(locationLayer, parallaxLayer);
        }
        this.updateBlendLayers();
    }

    public void setClipToOutput(boolean clipToOutput) {
        this.clipToOutput = clipToOutput;
        for (ParallaxedGraphic layer : this.parallaxLayers) {
            layer.setClipToOutput(clipToOutput);
        }
    }

    public void setShowRefs(boolean showRefs) {
        this.showRefs = showRefs;
        for (ParallaxedGraphic layer : this.parallaxLayers) {
            layer.setShowRef(showRefs);
        }
    }

    public void setShowBoundaries(boolean showBoundaries) {
        this.showBoundaries = showBoundaries;
        for (ParallaxedGraphic layer : this.parallaxLayers) {
            layer.setShowBoundaries(showBoundaries);
        }
    }

    public void setCurrentViewpoint(Camera camera, Rectangle4d viewport) {
        boolean viewportChanged;
        boolean cameraChanged = this.currentCamera == null || !this.currentCamera.getCumulativeTransform().equals(camera.getCumulativeTransform());
        boolean bl = viewportChanged = this.currentViewport == null || !this.currentViewport.equals(viewport);
        if (!cameraChanged && !viewportChanged) {
            return;
        }
        this.currentCamera = camera;
        this.currentViewport = viewport;
        this.updateBlendLayers();
    }

    public boolean isDisplayable() {
        return !this.blendParallaxLayers.isEmpty();
    }

    public double getCameraDistance(Camera camera) {
        if (this.parallaxLayers.isEmpty()) {
            return 0.0;
        }
        return this.parallaxLayers.get(0).getCameraZDistance(camera);
    }

    public List<ParallaxedGraphic> getBlendLayers() {
        return this.blendParallaxLayers;
    }

    public int getXOffset() {
        return this.parallaxLayers.isEmpty() ? 0 : this.parallaxLayers.get(0).getXOffset();
    }

    public int getYOffset() {
        return this.parallaxLayers.isEmpty() ? 0 : this.parallaxLayers.get(0).getYOffset();
    }

    public String getInfo() {
        StringBuilder infoBuilder = new StringBuilder();
        if (this.blendParallaxLayers.size() == 1) {
            infoBuilder.append(String.format("%s", this.blendParallaxLayers.get(0)));
        } else if (this.blendParallaxLayers.size() == 2) {
            ParallaxedGraphic b0 = this.blendParallaxLayers.get(0);
            ParallaxedGraphic b1 = this.blendParallaxLayers.get(1);
            infoBuilder.append(String.format("%s (%s) + %s (%s)", b0, FRACTION_FORMAT.format(b0.getAlpha()), b1, FRACTION_FORMAT.format(b1.getAlpha())));
        }
        return infoBuilder.toString();
    }

    public String toString() {
        ParallaxedGraphic layer = CollectionUtils.first(this.parallaxLayers);
        return this.getClass().getSimpleName() + "[" + (layer == null ? "" : layer.getID()) + "]";
    }

    private void updateBlendLayers() {
        SceneLocationLayer layer0;
        this.blendParallaxLayers.clear();
        if (this.currentCamera == null || this.currentViewport == null) {
            return;
        }
        Point3d currentPosition = this.currentCamera.getGlobalPosition();
        this.getClosestLocationLayers(this.currentCamera, this.currentViewport, this.blendLocationLayers);
        if (this.blendLocationLayers.size() == 1) {
            layer0 = this.blendLocationLayers.get(0);
            this.setAlpha(layer0, 1.0f);
            Color hazeBlendColor = layer0.getHazeBlendColor();
            this.setHazeColor(layer0, hazeBlendColor);
        } else if (this.blendLocationLayers.size() == 2) {
            boolean swap;
            double d0to1;
            double d1;
            double d0;
            layer0 = this.blendLocationLayers.get(0);
            SceneLocationLayer layer1 = this.blendLocationLayers.get(1);
            boolean sameCamera = this.sameCamera(layer0, layer1);
            boolean lateral = false;
            if (sameCamera) {
                Rectangle4d v0 = this.getViewport(layer0);
                Rectangle4d v1 = this.getViewport(layer1);
                Point2D.Double vpos = this.currentViewport.getMinCorner();
                Point2D.Double vpos0 = v0.getMinCorner();
                Point2D.Double vpos1 = v1.getMinCorner();
                d0 = vpos.distance(vpos0);
                d1 = vpos.distance(vpos1);
                d0to1 = vpos0.distance(vpos1);
                swap = v0.getWidth() < v1.getWidth();
                lateral = MathUtils.epsilonEquals(v0.getWidth(), v1.getWidth(), 0.001) && MathUtils.epsilonEquals(v0.getHeight(), v1.getHeight(), 0.001);
            } else {
                Point3d cpos0 = this.getCameraPosition(layer0);
                Point3d cpos1 = this.getCameraPosition(layer1);
                d0 = currentPosition.distance(cpos0);
                d1 = currentPosition.distance(cpos1);
                d0to1 = cpos0.distance(cpos1);
                double z0 = this.currentCamera.globalToCamera(cpos0).getZ();
                double z1 = this.currentCamera.globalToCamera(cpos1).getZ();
                swap = z1 > z0;
            }
            double dSum = d0 + d1;
            ArrayList<Float> weights = new ArrayList<Float>();
            weights.add(Float.valueOf(lateral ? 1.0f : (float)(d1 / dSum)));
            weights.add(Float.valueOf(lateral ? 1.0f : (float)(d0 / dSum)));
            if (LOGGER.isDebugEnabled()) {
                String str = String.format("%s = %f, %s = %f, d0to1 = %f", layer0.getIDPath(1, "."), weights.get(0), layer1.getIDPath(1, "."), weights.get(1), d0to1);
                if (sameCamera) {
                    str = "(same camera) " + str;
                }
                if (lateral) {
                    str = "(lateral) " + str;
                }
                LOGGER.debug(str);
            }
            if (!lateral && MathUtils.epsilonEquals(((Float)weights.get(0)).floatValue(), 1.0, 0.001)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Close enough: elminating second blend layer.");
                }
                this.blendLocationLayers.remove(1);
                this.setAlpha(layer0, 1.0f);
                this.setHazeColor(layer0, layer0.getHazeBlendColor());
            } else if (d1 >= d0to1) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Camera outside range: elminating second blend layer.");
                }
                this.blendLocationLayers.remove(1);
                this.setAlpha(layer0, 1.0f);
                this.setHazeColor(layer0, layer0.getHazeBlendColor());
            } else {
                if (swap) {
                    Collections.reverse(this.blendLocationLayers);
                    Collections.reverse(weights);
                    layer0 = this.blendLocationLayers.get(0);
                    layer1 = this.blendLocationLayers.get(1);
                }
                float transitionPoint = this.blendLocationLayers.get(1).getApproachTransition();
                float alpha0 = RampInterpFunction.getInterpFraction(((Float)weights.get(0)).floatValue(), 0.0f, 1.0f - transitionPoint);
                float alpha1 = RampInterpFunction.getInterpFraction(((Float)weights.get(1)).floatValue(), 0.0f, transitionPoint);
                this.setAlpha(layer0, alpha0);
                this.setAlpha(layer1, alpha1);
                Color hazeColor = ColorUtils.blend(layer0.getHazeBlendColor(), layer1.getHazeBlendColor(), ((Float)weights.get(1)).floatValue());
                this.setHazeColor(layer0, null);
                this.setHazeColor(layer1, hazeColor);
            }
        }
        for (SceneLocationLayer locationLayer : this.blendLocationLayers) {
            this.setCurrentViewpoint(locationLayer, this.currentCamera, this.currentViewport);
            this.blendParallaxLayers.addAll(this.graphicsByLocLayer.getAll(locationLayer));
        }
    }

    private List<SceneLocationLayer> getClosestLocationLayers(final Camera camera, Rectangle4d viewport, List<SceneLocationLayer> result) {
        final Point3d cameraPosition = camera.getGlobalPosition();
        final Point2D.Double viewportPosition = viewport.getMinCorner();
        List<SceneLocationLayer> displayableLayers = CollectionUtils.filterList(this.sceneLocationLayers, new Filter<SceneLocationLayer>(){

            @Override
            public boolean accept(SceneLocationLayer layer) {
                return ParallaxLayerBlender.this.isDisplayable(layer, camera);
            }
        });
        Collections.sort(displayableLayers, new Comparator<SceneLocationLayer>(){

            @Override
            public int compare(SceneLocationLayer o1, SceneLocationLayer o2) {
                if (ParallaxLayerBlender.this.sameCamera(o1, o2)) {
                    Double d1 = viewportPosition.distance(ParallaxLayerBlender.this.getViewport(o1).getMinCorner());
                    Double d2 = viewportPosition.distance(ParallaxLayerBlender.this.getViewport(o2).getMinCorner());
                    return d1.compareTo(d2);
                }
                Double d1 = ParallaxLayerBlender.this.getCameraPosition(o1).distance(cameraPosition);
                Double d2 = ParallaxLayerBlender.this.getCameraPosition(o2).distance(cameraPosition);
                return d1.compareTo(d2);
            }
        });
        int blendLayerCount = Math.min(displayableLayers.size(), 2);
        result.clear();
        for (int i = 0; i < blendLayerCount; ++i) {
            result.add(displayableLayers.get(i));
        }
        return result;
    }

    private Point3d getCameraPosition(SceneLocationLayer layer) {
        ParallaxedGraphic pLayer = this.graphicsByLocLayer.getFirst(layer);
        if (pLayer != null) {
            return pLayer.getHomeCameraPosition();
        }
        return null;
    }

    private Rectangle4d getViewport(SceneLocationLayer layer) {
        ParallaxedGraphic graphic = this.graphicsByLocLayer.getFirst(layer);
        if (graphic != null) {
            return graphic.getHomeViewport(false);
        }
        assert (false) : "No parallax layer for location layer: layer";
        return PatchworkComposerApp.BLENDER_VIEWPORT;
    }

    private Point3d getRefPoint(SceneLocationLayer layer) {
        ParallaxedGraphic pLayer = this.graphicsByLocLayer.getFirst(layer);
        if (!layer.isBackground() && pLayer != null) {
            return pLayer.getRefPoint();
        }
        return new Point3d();
    }

    private void setAlpha(SceneLocationLayer layer, float alpha) {
        for (ParallaxedGraphic pLayer : this.graphicsByLocLayer.getAll(layer)) {
            pLayer.setAlpha(alpha);
        }
    }

    private void setHazeColor(SceneLocationLayer layer, Color hazeColor) {
        List<ParallaxedGraphic> graphics = this.graphicsByLocLayer.getAll(layer);
        if (graphics.size() > 0) {
            graphics.get(graphics.size() - 1).setHazeColor(hazeColor);
        }
    }

    private void setCurrentViewpoint(SceneLocationLayer layer, Camera camera, Rectangle4d viewport) {
        for (ParallaxedGraphic pLayer : this.graphicsByLocLayer.getAll(layer)) {
            pLayer.setCurrentViewpoint(camera, viewport);
        }
    }

    private boolean sameCamera(SceneLocationLayer layer0, SceneLocationLayer layer1) {
        return CompareUtilities.equals(this.getCameraPosition(layer0), this.getCameraPosition(layer1));
    }

    private boolean isDisplayable(SceneLocationLayer layer, Camera camera) {
        List<ParallaxedGraphic> graphics = this.graphicsByLocLayer.getAll(layer);
        if (graphics.isEmpty()) {
            return false;
        }
        SceneLocation location = layer.getParentComponent();
        Viewpoint viewpoint = location.getViewpoint();
        if (viewpoint == null) {
            return false;
        }
        if (layer.isBackground()) {
            return true;
        }
        Point3d refPoint = this.getRefPoint(layer);
        Point3d refCamera = camera.globalToCamera(refPoint);
        return !(refCamera.z > -viewpoint.getClipDistance());
    }
}

