/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.parallax;

import com.sodiumarc.patchwork.app.scanimport.ImagePanel;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.parallax.ParallaxLayerBlender;
import com.sodiumarc.patchwork.app.scenecomposer.parallax.ParallaxedGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GraphicAnimator;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.VectorUtils;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParallaxEngine {
    private final List<ParallaxLayerBlender> layers = new ArrayList<ParallaxLayerBlender>();
    private final Map<SceneLayer, ParallaxLayerBlender> blendersBySceneLayer = new HashMap<SceneLayer, ParallaxLayerBlender>();
    private final Dimension size;
    private Camera currentCamera;
    private boolean showRefs;
    private boolean clipToOutput = true;
    private boolean showBoundaries;
    private static final DecimalFormat COORD_FORMAT = new DecimalFormat("0.000");

    public ParallaxEngine(Dimension size) {
        this.size = size;
    }

    public void setCurrentViewpoint(Camera currentCamera, Rectangle4d viewport) {
        this.currentCamera = currentCamera;
        for (ParallaxLayerBlender layer : this.layers) {
            layer.setCurrentViewpoint(currentCamera, viewport);
        }
    }

    public void addLayer(SceneLocationLayer locationLayer, Transform3D coordTransform) {
        SceneLayer sceneLayer = locationLayer.getSceneLayer();
        ParallaxLayerBlender blender = this.blendersBySceneLayer.get(sceneLayer);
        if (blender == null) {
            blender = new ParallaxLayerBlender(sceneLayer, this.size, coordTransform);
            blender.setClipToOutput(this.clipToOutput);
            blender.setShowBoundaries(this.showBoundaries);
            blender.setShowRefs(this.showRefs);
            this.blendersBySceneLayer.put(sceneLayer, blender);
            this.layers.add(blender);
        }
        blender.addLayer(locationLayer);
    }

    public Set<SceneLayer> getLayers() {
        return this.blendersBySceneLayer.keySet();
    }

    public void setLayerGraphics(SceneLocationLayer locationLayer, List<? extends GraphicAnimator> graphics) {
        ParallaxLayerBlender blender = this.blendersBySceneLayer.get(locationLayer.getSceneLayer());
        if (blender != null) {
            blender.setLayerGraphics(locationLayer, graphics);
        }
    }

    public void clearLayers() {
        this.blendersBySceneLayer.clear();
        this.layers.clear();
    }

    public void render(ImagePanel destination, Set<SceneLayer> sceneLayers) {
        this.orderLayers();
        destination.clear();
        ArrayList<ImagePanel.ImagePanelLayer> imageLayers = new ArrayList<ImagePanel.ImagePanelLayer>();
        for (ParallaxLayerBlender layerBlender : this.layers) {
            boolean forceUpdate;
            boolean bl = forceUpdate = sceneLayers == null || sceneLayers.contains(layerBlender.getSceneLayer());
            if (!layerBlender.isDisplayable()) continue;
            for (ParallaxedGraphic blendLayer : layerBlender.getBlendLayers()) {
                if (blendLayer.isEmpty()) continue;
                imageLayers.add(new ImagePanel.ImagePanelLayer(blendLayer.getCurrentImage(forceUpdate), blendLayer.getXOffset(), blendLayer.getYOffset(), blendLayer.getAlphaComposite()));
            }
        }
        destination.setLayers(imageLayers);
    }

    public void setClipToOutput(boolean clipToOutput) {
        for (ParallaxLayerBlender layer : this.layers) {
            layer.setClipToOutput(clipToOutput);
        }
        this.clipToOutput = clipToOutput;
    }

    public void setShowRefs(boolean showRefs) {
        for (ParallaxLayerBlender layer : this.layers) {
            layer.setShowRefs(showRefs);
        }
        this.showRefs = showRefs;
    }

    public void setShowBoundaries(boolean showBoundaries) {
        for (ParallaxLayerBlender layer : this.layers) {
            layer.setShowBoundaries(showBoundaries);
        }
        this.showBoundaries = showBoundaries;
    }

    public String getInfo() {
        if (this.currentCamera == null) {
            return "Position: (none)";
        }
        if (this.layers.size() == 1) {
            return this.layers.get(0).getInfo();
        }
        return "Position: (" + VectorUtils.toString(this.currentCamera.getGlobalPosition(), COORD_FORMAT) + ")";
    }

    private void orderLayers() {
        if (this.currentCamera == null) {
            return;
        }
        Collections.sort(this.layers, new Comparator<ParallaxLayerBlender>(){

            @Override
            public int compare(ParallaxLayerBlender o1, ParallaxLayerBlender o2) {
                Double d1 = o1.getCameraDistance(ParallaxEngine.this.currentCamera);
                Double d2 = o2.getCameraDistance(ParallaxEngine.this.currentCamera);
                return d2.compareTo(d1);
            }
        });
    }
}

