/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint;

import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerApp;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.AbstractViewpoint;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraph;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.VectorUtils;
import java.util.Map;
import javax.vecmath.Vector3d;

public class StandardViewpoint
extends AbstractViewpoint {
    public static final String FRAME_PREFIX = "FRAME";
    public static final String CAMERA_PREFIX = "CAM";
    private String cameraID;
    private String frameMeshID;
    private Camera camera;
    private Rectangle4d viewport;
    private final Vector3d cameraOffset;

    public static String getFrameMeshPrefix(String cameraID) {
        return cameraID + ";" + FRAME_PREFIX;
    }

    public static String getFrameMeshPattern(String cameraID) {
        return StandardViewpoint.getFrameMeshPrefix(cameraID) + "[^;]*";
    }

    public static String toLocationID(String cameraID, String frameMeshID) {
        String meshName;
        String cameraName = cameraID;
        if (cameraName.startsWith(CAMERA_PREFIX)) {
            cameraName = cameraName.substring(CAMERA_PREFIX.length());
        }
        if ((meshName = frameMeshID.substring(StandardViewpoint.getFrameMeshPrefix(cameraID).length())).startsWith("_")) {
            meshName = meshName.substring(1);
        }
        if (cameraName.equals(meshName)) {
            return cameraName;
        }
        return meshName;
    }

    public StandardViewpoint(String id) {
        this(id, null, null);
    }

    public StandardViewpoint(String id, String cameraID, String frameMeshID) {
        super(id);
        this.cameraID = cameraID;
        this.frameMeshID = frameMeshID;
        this.cameraOffset = new Vector3d();
    }

    public String getCameraID() {
        return this.cameraID;
    }

    public void setCameraID(String cameraID) {
        this.cameraID = cameraID;
        this.updateFromSceneGraph();
        this.fireModified(this.getPath());
    }

    public void setCameraLocation(Vector3d translation) {
        assert (this.cameraID == null || this.frameMeshID == null) : "Can't set manual camera: linked to COLLADA";
        Transform3D camTransform = new Transform3D();
        camTransform.setTranslation(translation);
        this.camera = new Camera(this.getID(), camTransform);
        this.fireModified();
    }

    public String getFrameMeshID() {
        return this.frameMeshID;
    }

    public void setFrameMeshID(String frameMeshID) {
        this.frameMeshID = frameMeshID;
        this.updateFromSceneGraph();
        this.fireModified(this.getPath());
    }

    public void setViewport(Rectangle4d viewport) {
        assert (this.cameraID == null || this.frameMeshID == null) : "Can't set manual viewport: linked to COLLADA";
        this.viewport = viewport;
        this.fireModified();
    }

    public Vector3d getCameraOffset() {
        return this.cameraOffset;
    }

    public void setCameraOffset(Vector3d offset) {
        this.cameraOffset.set(offset);
        this.fireModified();
    }

    public void updateFromSceneGraph() {
        this.camera = null;
        this.viewport = null;
        this.fireModified();
    }

    @Override
    public Camera getCamera() {
        if (this.cameraOffset.length() > 0.0) {
            return this.getBaseCamera().createOffsetCamera(this.getID(), this.cameraOffset, true);
        }
        return this.getBaseCamera();
    }

    @Override
    public Rectangle4d getViewport() {
        if (this.viewport == null) {
            PolyMesh3D frameMesh;
            SceneGraph sceneGraph = this.getAncestorByType(Scene.class).getSceneGraph();
            if (sceneGraph != null && this.cameraID != null && this.frameMeshID != null && (frameMesh = sceneGraph.getMeshInCameraCoords(this.frameMeshID, this.cameraID)) != null) {
                this.viewport = this.getCamera().getProjectedBounds(frameMesh);
            }
            if (this.viewport == null) {
                this.viewport = PatchworkComposerApp.BLENDER_VIEWPORT;
            }
        }
        return this.viewport;
    }

    public Camera getBaseCamera() {
        if (this.camera == null) {
            SceneGraph sceneGraph = this.getAncestorByType(Scene.class).getSceneGraph();
            if (sceneGraph != null && this.cameraID != null) {
                this.camera = sceneGraph.getCamera(this.cameraID);
            }
            if (this.camera == null) {
                this.camera = new Camera(this.getID());
            }
        }
        return this.camera;
    }

    public static class Transcoder
    extends ProjectComponent.Transcoder<StandardViewpoint> {
        private static final String ELEMENT_NAME = "StandardViewpoint";
        private static final String ATTR_CAMERA_ID = "cameraId";
        private static final String ATTR_CAMERA = "camera";
        private static final String ATTR_FRAME_ID = "frameId";
        private static final String ATTR_VIEWPORT = "viewport";
        private static final String ATTR_CAMERA_OFFSET = "cameraOffset";

        public Transcoder() {
            super(ELEMENT_NAME, StandardViewpoint.class);
        }

        @Override
        protected StandardViewpoint decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            String viewportStr;
            StandardViewpoint result = new StandardViewpoint(id, attributes.get(ATTR_CAMERA_ID), attributes.get(ATTR_FRAME_ID));
            String cameraStr = attributes.get(ATTR_CAMERA);
            if (cameraStr != null) {
                Transform3D camTransform = VectorUtils.decodeTransform3D(cameraStr);
                result.camera = new Camera(id, camTransform);
            }
            if ((viewportStr = attributes.get(ATTR_VIEWPORT)) != null) {
                result.viewport = new Rectangle4d(viewportStr);
            }
            if (attributes.containsKey(ATTR_CAMERA_OFFSET)) {
                result.cameraOffset.set(VectorUtils.decodeVector3d(attributes.get(ATTR_CAMERA_OFFSET)));
            }
            return result;
        }

        @Override
        protected void getAttributes(StandardViewpoint object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_CAMERA_ID, object.cameraID);
            destination.put(ATTR_FRAME_ID, object.frameMeshID);
            if (object.camera != null) {
                destination.put(ATTR_CAMERA, VectorUtils.toString(object.camera.getCumulativeTransform()));
            }
            if (object.viewport != null) {
                destination.put(ATTR_VIEWPORT, object.viewport.encode());
            }
            destination.put(ATTR_CAMERA_OFFSET, VectorUtils.toString(object.cameraOffset));
        }
    }
}

