/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint;

import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerApp;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.AbstractViewpoint;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.VectorUtils;
import java.util.Map;
import javax.vecmath.Vector3d;

public class InterpolatedViewpoint
extends AbstractViewpoint {
    private Reference<SceneLocation> fromLocation = new Reference();
    private Reference<SceneLocation> toLocation = new Reference();
    private double interpFraction = 0.5;

    public InterpolatedViewpoint(String id) {
        super(id);
    }

    public void setFromLocation(SceneLocation fromLocation) {
        this.fromLocation = new Reference<SceneLocation>((ProjectComponent)this, fromLocation);
        this.fireModified(this.getPath());
    }

    public void setToLocation(SceneLocation toLocation) {
        this.toLocation = new Reference<SceneLocation>((ProjectComponent)this, toLocation);
        this.fireModified(this.getPath());
    }

    public SceneLocation getFromLocation() {
        return this.fromLocation.resolve();
    }

    public SceneLocation getToLocation() {
        return this.toLocation.resolve();
    }

    public double getInterpFraction() {
        return this.interpFraction;
    }

    public void setInterpFraction(double interpFraction) {
        this.interpFraction = interpFraction;
        this.fireModified(this.getPath());
    }

    @Override
    public Camera getCamera() {
        SceneLocation fromLocation = this.getFromLocation();
        SceneLocation toLocation = this.getToLocation();
        if (fromLocation == null || toLocation == null) {
            return new Camera(this.getID());
        }
        Camera fromCamera = fromLocation.getCamera();
        Camera toCamera = toLocation.getCamera();
        if (fromCamera == null || toCamera == null) {
            return new Camera(this.getID());
        }
        Vector3d deltaVector = VectorUtils.scaledDelataVector(fromCamera.getGlobalPosition(), toCamera.getGlobalPosition(), this.interpFraction);
        Camera result = fromCamera.createOffsetCamera(this.getID(), deltaVector, false);
        return result;
    }

    @Override
    public Rectangle4d getViewport() {
        SceneLocation fromLocation = this.getFromLocation();
        SceneLocation toLocation = this.getToLocation();
        if (fromLocation == null || toLocation == null) {
            return PatchworkComposerApp.BLENDER_VIEWPORT;
        }
        Rectangle4d fromViewport = fromLocation.getViewport(false);
        Rectangle4d toViewport = toLocation.getViewport(false);
        if (fromViewport == null || toViewport == null) {
            return PatchworkComposerApp.BLENDER_VIEWPORT;
        }
        return fromViewport.interpolate(toViewport, this.interpFraction);
    }

    public static class Transcoder
    extends ProjectComponent.Transcoder<InterpolatedViewpoint> {
        private static final String ELEMENT_NAME = "InterpViewpoint";
        private static final String ATTR_FROM = "fromLocation";
        private static final String ATTR_TO = "toLocation";
        private static final String ATTR_FRACTION = "interpFraction";

        public Transcoder() {
            super(ELEMENT_NAME, InterpolatedViewpoint.class);
        }

        @Override
        protected InterpolatedViewpoint decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            InterpolatedViewpoint result = new InterpolatedViewpoint(id);
            result.fromLocation = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_FROM));
            result.toLocation = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_TO));
            result.interpFraction = Double.valueOf(attributes.get(ATTR_FRACTION));
            return result;
        }

        @Override
        protected void getAttributes(InterpolatedViewpoint object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_FROM, object.fromLocation.encode());
            destination.put(ATTR_TO, object.toLocation.encode());
            destination.put(ATTR_FRACTION, Double.toString(object.getInterpFraction()));
        }
    }
}

