/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.sound;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundSequenceEntry;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.Icon;

public class SoundSequence
extends ProjectComponent {
    public static final Icon ICON = IconLoader.loadIcon("silk/sound_add.png");
    private final List<SoundSequenceEntry> entries = new ArrayList<SoundSequenceEntry>();

    public SoundSequence(String id) {
        super(id);
    }

    public List<SoundSequenceEntry> getEntries() {
        return this.entries;
    }

    public void addEntry(SoundSequenceEntry entry) {
        this.addEntry(entry, true);
    }

    public void addEntry(SoundSequenceEntry entry, int index) {
        this.addEntry(entry, index, true);
    }

    public void addEntry() {
        this.addEntry(new SoundSequenceEntry(UUID.randomUUID().toString()));
    }

    public void removeEntry(SoundSequenceEntry entry) {
        this.removeEntry(entry, true);
    }

    public void moveEntry(SoundSequenceEntry entry, int newIndex) {
        if (this.entries.contains(entry)) {
            int oldIndex = this.entries.indexOf(entry);
            if (newIndex == oldIndex) {
                return;
            }
            this.removeEntry(entry);
            this.addEntry(entry, newIndex);
        }
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    private void addEntry(SoundSequenceEntry entry, boolean notify) {
        this.entries.add(entry);
        this.registerChild(entry, false, notify);
    }

    private void addEntry(SoundSequenceEntry entry, int index, boolean notify) {
        if (index >= this.entries.size()) {
            this.entries.add(entry);
        } else {
            this.entries.add(index, entry);
        }
        this.registerChild(entry, false, notify);
    }

    private void removeEntry(SoundSequenceEntry entry, boolean notify) {
        this.entries.remove(entry);
        this.removeChild(entry, notify);
    }

    public static class Transcoder
    extends ProjectComponent.Transcoder<SoundSequence> {
        private static final String ELEMENT_NAME = "SoundSequence";
        private static final String FIELD_ENTRIES = "entries";

        public Transcoder() {
            super(ELEMENT_NAME, SoundSequence.class);
            this.setFieldTranscoder(FIELD_ENTRIES, new SoundSequenceEntry.Transcoder());
        }

        @Override
        protected void getAttributes(SoundSequence object, Map<String, String> destination) {
            super.getAttributes(object, destination);
        }

        @Override
        protected void getChildren(SoundSequence object, MultiMap<String, Object> destination) {
            for (SoundSequenceEntry entry : object.getEntries()) {
                destination.putLast(FIELD_ENTRIES, entry);
            }
        }

        @Override
        protected final SoundSequence decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            SoundSequence result = new SoundSequence(id);
            for (Object entry : decodedChildren.getAll(FIELD_ENTRIES)) {
                result.addEntry((SoundSequenceEntry)entry, false);
            }
            return result;
        }
    }
}

