/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.sound;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerProperties;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.resource.ResourceManager;
import com.sodiumarc.patchwork.app.scenecomposer.sound.ArrayClip;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class SoundClip
extends ProjectComponent {
    public static final Icon ICON = IconLoader.loadIcon("silk/sound.png");
    public static final String SOUND_FILE_EXTENSION = "wav";
    private File inputFile;
    private float baseVolume = 1.0f;
    private AudioFormat format;
    private byte[] soundData;
    private float fadeLevel = 1.0f;
    private Clip clip;
    private FloatControl gainControl;
    private BooleanControl muteControl;
    private static final Logger LOGGER = Logger.getLogger(SoundClip.class);

    public SoundClip(String id) {
        super(id);
    }

    public String getInputFilename() {
        File file = this.getInputFile();
        return file == null ? null : file.getName();
    }

    public void setInputFilename(String inputFilename) {
        this.inputFile = inputFilename == null ? null : new File(this.getIODirectory(IOFileType.COLLADA), inputFilename);
        this.soundData = null;
        this.format = null;
        this.clip = null;
        this.gainControl = null;
        this.muteControl = null;
        this.fireModified();
    }

    public AudioInputStream getInputStream() throws UnsupportedAudioFileException, IOException {
        if (this.inputFile == null) {
            return null;
        }
        AudioInputStream result = null;
        InputStream istream = null;
        PatchworkProject project = (PatchworkProject)this.getPath().get(0);
        if (project.isPublished()) {
            istream = ResourceManager.getInputStream(this.getPublishedFilename());
            BufferedInputStream bufferedIn = new BufferedInputStream(istream);
            result = AudioSystem.getAudioInputStream(bufferedIn);
        } else if (this.inputFile != null) {
            File file = new File(this.getIODirectory(IOFileType.SOUND), this.inputFile.getName());
            result = AudioSystem.getAudioInputStream(file);
        }
        if (result != null) {
            this.format = result.getFormat();
        }
        return result;
    }

    public Clip getClip() {
        if (this.clip != null) {
            return this.clip;
        }
        try {
            AudioInputStream audioInputStream = this.getInputStream();
            if (LOGGER.isDebugEnabled()) {
                AudioFormat format = audioInputStream.getFormat();
                LOGGER.debug("Encoding: " + format.getEncoding());
                LOGGER.debug("Frames Per Second: " + format.getFrameRate());
                LOGGER.debug("Samples per Second: " + format.getSampleRate());
                LOGGER.debug("Frames Size (bytes): " + format.getFrameSize());
                LOGGER.debug("Sample Size in bits: " + format.getSampleSizeInBits());
                LOGGER.debug("Big-endian: " + format.isBigEndian());
            }
            this.clip = new ArrayClip();
            if (audioInputStream != null) {
                this.clip.open(audioInputStream);
                this.gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
                this.muteControl = (BooleanControl)this.clip.getControl(BooleanControl.Type.MUTE);
                this.updateGain();
            }
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
        return this.clip;
    }

    public void setBaseVolume(float volume) {
        this.baseVolume = volume;
        this.updateGain();
        this.fireModified();
    }

    public float getBaseVolume() {
        return this.baseVolume;
    }

    public void play(boolean loop) {
        Clip clip = this.getClip();
        if (clip == null) {
            return;
        }
        if (clip.isRunning()) {
            this.stop();
        }
        this.updateGain();
        clip.setFramePosition(0);
        clip.loop(loop ? -1 : 0);
    }

    public void stop() {
        this.updateGain();
        Clip clip = this.getClip();
        if (clip == null) {
            return;
        }
        if (clip.isRunning()) {
            clip.stop();
        }
    }

    public boolean isPlaying() {
        Clip clip = this.getClip();
        if (clip == null) {
            return false;
        }
        return clip.isRunning();
    }

    public float getFadeLevel() {
        return this.fadeLevel;
    }

    public void setFadeLevel(float fadeLevel) {
        this.fadeLevel = fadeLevel;
        this.updateGain();
    }

    public void setMuted(boolean muted) {
        this.getClip();
        if (this.muteControl == null) {
            return;
        }
        this.muteControl.setValue(muted);
    }

    public boolean isMuted() {
        this.getClip();
        if (this.muteControl == null) {
            return false;
        }
        return this.muteControl.getValue();
    }

    public boolean isActive() {
        Clip clip = this.getClip();
        if (clip == null) {
            return false;
        }
        return clip.isActive();
    }

    public int getDurationInMillis() {
        Clip clip = this.getClip();
        if (clip == null) {
            return 0;
        }
        return (int)(clip.getMicrosecondLength() / 1000L);
    }

    public byte[] getSoundData() {
        if (this.soundData != null) {
            return this.soundData;
        }
        AudioInputStream stream = null;
        try {
            stream = this.getInputStream();
            if (stream != null) {
                int frameLength = (int)stream.getFrameLength();
                int frameSize = stream.getFormat().getFrameSize();
                int len = frameLength * frameSize;
                this.soundData = new byte[len];
                int numRead = 0;
                int offset = 0;
                while (numRead != -1) {
                    numRead = stream.read(this.soundData, offset, len);
                    offset += numRead;
                }
            }
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.soundData;
    }

    public AudioFormat getAudioFormat() {
        if (this.format == null) {
            try {
                this.getInputStream();
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.format;
    }

    public boolean publish() {
        long fileLastModified;
        long lastModified = this.getLastModified();
        if (lastModified > (fileLastModified = ResourceManager.getLastModification(this.getGUID() + ".wav"))) {
            try {
                AudioInputStream inputStream = this.getInputStream();
                if (inputStream != null) {
                    ResourceManager.publishSoundResource(inputStream, this.getGUID());
                    return true;
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to publish " + this.getID() + ": " + e.getMessage());
            }
            catch (UnsupportedAudioFileException e) {
                LOGGER.warn("Failed to publish " + this.getID() + ": " + e.getMessage());
            }
        }
        return false;
    }

    public void preload() {
        this.getSoundData();
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    public void updateGain() {
        float adjustedVolume = this.baseVolume * this.fadeLevel;
        if (this.gainControl != null) {
            float dB = (float)(Math.log(adjustedVolume) * (20.0 / Math.log(10.0)));
            this.gainControl.setValue(dB);
        }
    }

    private File getInputFile() {
        if (this.inputFile == null) {
            return null;
        }
        return new File(PatchworkComposerProperties.getIODirectory(IOFileType.SOUND), this.inputFile.getName());
    }

    private String getPublishedFilename() {
        return this.getGUID() + ".wav";
    }

    public static class Transcoder
    extends ProjectComponent.Transcoder<SoundClip> {
        private static final String ELEMENT_NAME = "SoundClip";
        private static final String ATTR_ANIM_FILENAME = "animationFilename";
        private static final String ATTR_VOLUME = "volume";

        public Transcoder() {
            super(ELEMENT_NAME, SoundClip.class);
        }

        @Override
        protected SoundClip decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            SoundClip result = new SoundClip(id);
            String animFilename = attributes.get(ATTR_ANIM_FILENAME);
            if (animFilename != null) {
                result.inputFile = new File(animFilename);
            }
            if (attributes.containsKey(ATTR_VOLUME)) {
                result.baseVolume = Float.valueOf(attributes.get(ATTR_VOLUME)).floatValue();
            }
            return result;
        }

        @Override
        protected void getAttributes(SoundClip object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            if (object.inputFile != null) {
                destination.put(ATTR_ANIM_FILENAME, object.inputFile.toString());
            }
            destination.put(ATTR_VOLUME, Float.toString(object.baseVolume));
        }
    }
}

