/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.graphic;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridCoords;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.StringUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.Icon;

public class ShadowGraphic
extends LocationLayerGraphic {
    public static final Icon ICON = IconLoader.loadIcon("silk/shading.png");
    private Reference<LocationLayerGraphic> castingGraphic = new Reference();
    private Reference<LocationLayerGraphic> receivingGraphic = new Reference();
    private Point shadowOffset = new Point();
    private float shadowAlpha = 0.5f;

    public ShadowGraphic(String id) {
        super(id);
    }

    public LocationLayerGraphic getCastingGraphic() {
        return this.castingGraphic.resolve();
    }

    public void setCastingGraphic(LocationLayerGraphic castingGraphic) {
        this.castingGraphic = new Reference<LocationLayerGraphic>((ProjectComponent)this, castingGraphic);
        this.fireModified();
    }

    public LocationLayerGraphic getReceivingGraphic() {
        return this.receivingGraphic.resolve();
    }

    public void setReceivingGraphic(LocationLayerGraphic receivingGraphic) {
        this.receivingGraphic = new Reference<LocationLayerGraphic>((ProjectComponent)this, receivingGraphic);
        this.fireModified();
    }

    public Point getShadowOffset() {
        return this.shadowOffset;
    }

    public void setShadowOffset(Point shadowOffset) {
        this.shadowOffset.setLocation(shadowOffset);
        this.fireModified();
    }

    public float getShadowAlpha() {
        return this.shadowAlpha;
    }

    public void setShadowAlpha(float shadowAlpha) {
        this.shadowAlpha = shadowAlpha;
        this.fireModified();
    }

    public void refresh() {
    }

    @Override
    public boolean isAnimated() {
        LocationLayerGraphic casting = this.getCastingGraphic();
        if (casting != null && casting.isAnimated()) {
            return true;
        }
        LocationLayerGraphic receiving = this.getReceivingGraphic();
        return receiving != null && receiving.isAnimated();
    }

    @Override
    public boolean isEmpty() {
        LocationLayerGraphic casting = this.getCastingGraphic();
        return casting == null || casting.isEmpty();
    }

    @Override
    public int getDurationInMillis() {
        LocationLayerGraphic receiving;
        int result = 0;
        LocationLayerGraphic casting = this.getCastingGraphic();
        if (casting != null) {
            result = casting.getDurationInMillis();
        }
        if ((receiving = this.getReceivingGraphic()) != null) {
            result = Math.max(receiving.getDurationInMillis(), result);
        }
        return result;
    }

    @Override
    protected BufferedImage getImageImpl(float elapsedFraction, boolean doScale) {
        LocationLayerGraphic casting = this.getCastingGraphic();
        if (casting == null) {
            return null;
        }
        BufferedImage castingImage = casting.getImage(elapsedFraction);
        if (castingImage == null) {
            return null;
        }
        Rectangle4d outputBounds = this.getOutputBounds();
        Rectangle4d castingBounds = casting.getOutputBounds();
        AffineTransform castingTransform = new AffineTransform();
        castingTransform.translate(this.shadowOffset.x, this.shadowOffset.y);
        castingTransform.translate(castingBounds.getX() - outputBounds.getX(), castingBounds.getY() - outputBounds.getY());
        Point castingSourceOffset = casting.getCurrentOffset(GridCoords.ORIGIN, elapsedFraction);
        castingTransform.translate(castingSourceOffset.x, castingSourceOffset.y);
        BufferedImage result = this.getDestinationImage();
        Graphics2D g2 = result.createGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, result.getWidth(), result.getHeight());
        g2.setComposite(AlphaComposite.SrcOver);
        g2.drawImage(castingImage, castingTransform, null);
        g2.setColor(Color.BLACK);
        g2.setComposite(AlphaComposite.getInstance(5, this.shadowAlpha));
        g2.fillRect(0, 0, result.getWidth(), result.getHeight());
        this.clipToReceiving(g2, elapsedFraction);
        g2.dispose();
        return result;
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    private void clipToReceiving(Graphics2D g2, float elapsedFraction) {
        BufferedImage receivingImage;
        LocationLayerGraphic receiving = this.getReceivingGraphic();
        if (receiving != null && (receivingImage = receiving.getImage(elapsedFraction)) != null) {
            Rectangle4d outputBounds = this.getOutputBounds();
            Rectangle4d receivingBounds = receiving.getOutputBounds();
            AffineTransform receivingTransform = new AffineTransform();
            receivingTransform.translate(receivingBounds.getX() - outputBounds.getX(), receivingBounds.getY() - outputBounds.getY());
            Point receivingSourceOffset = receiving.getCurrentOffset(GridCoords.ORIGIN, elapsedFraction);
            receivingTransform.translate(receivingSourceOffset.x, receivingSourceOffset.y);
            g2.setComposite(AlphaComposite.DstIn);
            g2.drawImage(receivingImage, receivingTransform, null);
        }
    }

    public static class Transcoder
    extends LocationLayerGraphic.Transcoder<ShadowGraphic> {
        private static final String ELEMENT_NAME = "ShadowGraphic";
        private static final String ATTR_CASTING_GRAPHIC = "castingGraphic";
        private static final String ATTR_RECEIVING_GRAPHIC = "receivingGraphic";
        private static final String ATTR_SHADOW_OFFSET = "shadowOffset";
        private static final String ATTR_SHADOW_ALPHA = "shadowAlpha";

        public Transcoder() {
            super(ELEMENT_NAME, ShadowGraphic.class);
        }

        @Override
        protected void getAttributes(ShadowGraphic object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_CASTING_GRAPHIC, object.castingGraphic.encode());
            destination.put(ATTR_RECEIVING_GRAPHIC, object.receivingGraphic.encode());
            destination.put(ATTR_SHADOW_OFFSET, StringUtils.encodePoint(object.shadowOffset));
            destination.put(ATTR_SHADOW_ALPHA, Float.toString(object.shadowAlpha));
        }

        @Override
        protected ShadowGraphic decodeGraphic(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            ShadowGraphic result = new ShadowGraphic(id);
            result.castingGraphic = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_CASTING_GRAPHIC));
            result.receivingGraphic = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_RECEIVING_GRAPHIC));
            if (attributes.containsKey(ATTR_SHADOW_OFFSET)) {
                result.shadowOffset = StringUtils.decodePoint(attributes.get(ATTR_SHADOW_OFFSET));
            }
            if (attributes.containsKey(ATTR_SHADOW_ALPHA)) {
                result.shadowAlpha = Float.valueOf(attributes.get(ATTR_SHADOW_ALPHA)).floatValue();
            }
            return result;
        }
    }
}

