/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.graphic;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.animation.MultiPropertyKeyframes;
import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerProperties;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LayeredImageGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.MotionKeyframes;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.SpriteSequenceGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.resource.ResourceManager;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridCoords;
import com.sodiumarc.patchwork.render.BoundingBox3D;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.COLLADALoader;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraph;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraphNode;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.GeometricAxis;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.VectorUtils;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class MotionKeyframesGraphic
extends LocationLayerGraphic {
    public static final String ORTHO_FRAME_PREFIX = "OFRAME";
    public static final String CUTOUT_FRAME_PREFIX = "CFRAME";
    public static final Icon ICON = IconLoader.loadIcon("silk/chart_line.png");
    private File animationColladaFile;
    private List<String> animationNodeNames;
    private String orthoFrameMeshID;
    private String cutoutFrameMeshID;
    private Reference<LocationLayerGraphic> graphic;
    private KeyframeMode translationKeyframeMode = KeyframeMode.ABSOLUTE;
    private KeyframeMode rotationKeyframeMode = KeyframeMode.ABSOLUTE;
    private boolean pixelSnapEnabled = true;
    private SceneGraph sceneGraph;
    private final List<String> nodeNamesOrderedByDistance;
    private final Map<String, MotionKeyframes> keyframesByNodeName;
    private final Map<String, Rectangle4d> cutoutBoundsByNodeName;
    private final Map<String, BufferedImage> partImagesByNodeName;
    private double maxKeyframe;
    private boolean animationNeedsUpdate;
    private GeometricAxis normalAxis = GeometricAxis.Y;
    private GeometricAxis cutoutNormalAxis = GeometricAxis.Y;
    private Rectangle4d orthoFrame;
    private Rectangle4d cutoutFrame;
    private MultiPropertyKeyframes keyframes;
    private static final Logger LOGGER = Logger.getLogger(MotionKeyframesGraphic.class);

    public MotionKeyframesGraphic(String id) {
        super(id);
        this.animationNodeNames = new ArrayList<String>();
        this.graphic = new Reference();
        this.keyframesByNodeName = new HashMap<String, MotionKeyframes>();
        this.cutoutBoundsByNodeName = new HashMap<String, Rectangle4d>();
        this.partImagesByNodeName = new HashMap<String, BufferedImage>();
        this.nodeNamesOrderedByDistance = new ArrayList<String>();
        this.clearAnimation();
    }

    public String getInputFilename() {
        File file = this.getInputFile();
        return file == null ? null : file.getName();
    }

    public void setInputFilename(String inputFilename) {
        this.animationColladaFile = inputFilename == null ? null : new File(this.getIODirectory(IOFileType.COLLADA), inputFilename);
        this.sceneGraph = null;
        this.clearAnimation();
        this.fireModified();
    }

    public List<String> getAnimationNodeNames() {
        return this.animationNodeNames;
    }

    public void setAnimationNodeNames(Collection<String> names) {
        this.animationNodeNames.clear();
        if (names != null) {
            this.animationNodeNames.addAll(names);
        }
        this.clearAnimation();
        this.fireModified();
    }

    public void addAnimationNodeName(String nodeName) {
        this.animationNodeNames.add(nodeName);
        this.clearAnimation();
        this.fireModified();
    }

    public List<String> getPossibleAnimationNodeNames() {
        ArrayList<String> result = new ArrayList<String>();
        SceneGraph sceneGraph = this.getSceneGraph();
        if (sceneGraph != null) {
            for (SceneGraphNode node : sceneGraph.getAnimatedNodes()) {
                result.add(node.getName());
            }
        }
        return result;
    }

    public String getOrthoFrameMeshID() {
        return this.orthoFrameMeshID;
    }

    public void setOrthoFrameMeshID(String orthoFrameName) {
        this.orthoFrameMeshID = orthoFrameName;
        this.updateOrthoFrame();
        this.fireModified();
    }

    public String getCutoutFrameMeshID() {
        return this.cutoutFrameMeshID;
    }

    public void setCutoutFrameMeshID(String cutoutFrameMeshID) {
        this.cutoutFrameMeshID = cutoutFrameMeshID;
        this.updateCutoutFrame();
        this.fireModified();
    }

    public List<String> getPossibleOrthoFrameMeshIDs() {
        ArrayList<String> result = new ArrayList<String>();
        SceneGraph sceneGraph = this.getSceneGraph();
        if (sceneGraph != null) {
            Pattern namePattern = Pattern.compile("OFRAME.*");
            for (SceneGraphNode node : sceneGraph.getNodes(namePattern)) {
                result.add(node.getName());
            }
        }
        return result;
    }

    public List<String> getPossibleCutoutFrameMeshIDs() {
        ArrayList<String> result = new ArrayList<String>();
        SceneGraph sceneGraph = this.getSceneGraph();
        if (sceneGraph != null) {
            Pattern namePattern = Pattern.compile("CFRAME.*");
            for (SceneGraphNode node : sceneGraph.getNodes(namePattern)) {
                result.add(node.getName());
            }
        }
        return result;
    }

    public LocationLayerGraphic getGraphic() {
        return this.graphic.resolve();
    }

    public void setGraphic(LocationLayerGraphic graphic) {
        this.graphic = new Reference<LocationLayerGraphic>((ProjectComponent)this, graphic);
        this.fireModified();
    }

    public KeyframeMode getTranslationKeyframeMode() {
        return this.translationKeyframeMode;
    }

    public void setTranslationKeyframeMode(KeyframeMode translationKeyframeMode) {
        this.translationKeyframeMode = translationKeyframeMode;
        this.fireModified();
    }

    public KeyframeMode getRotationKeyframeMode() {
        return this.rotationKeyframeMode;
    }

    public void setRotationKeyframeMode(KeyframeMode rotationKeyframeMode) {
        this.rotationKeyframeMode = rotationKeyframeMode;
        this.fireModified();
    }

    public boolean isPixelSnapEnabled() {
        return this.pixelSnapEnabled;
    }

    public void setPixelSnapEnabled(boolean pixelSnapEnabled) {
        this.pixelSnapEnabled = pixelSnapEnabled;
        this.fireModified();
    }

    public void refresh() {
        this.clearAnimation();
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public boolean isAnimated() {
        return true;
    }

    @Override
    public BufferedImage getImageImpl(float elapsedFraction, boolean doScale) {
        this.updateAnimation();
        BufferedImage result = this.getDestinationImage();
        this.getImage(elapsedFraction, result);
        return result;
    }

    @Override
    public int getDurationInMillis() {
        this.updateAnimation();
        return (int)(1000.0 * this.maxKeyframe);
    }

    @Override
    public boolean isEmpty() {
        return this.getGraphic() == null || this.getGraphic().isEmpty();
    }

    @Override
    public boolean publish() {
        long fileLastModified;
        File inputFile = this.getInputFile();
        if (inputFile == null) {
            return false;
        }
        String publishedFilename = this.getPublishedFilename();
        long lastModified = this.getLastModified();
        if (lastModified > (fileLastModified = ResourceManager.getLastModification(publishedFilename))) {
            try {
                FileUtils.copyNIO(inputFile, new File(ResourceManager.getPublishDir(), publishedFilename));
                return true;
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("File not found: " + inputFile);
            }
            catch (IOException e) {
                LOGGER.warn(e);
            }
        }
        return false;
    }

    @Override
    public void preload() {
        this.updateAnimation();
    }

    public void saveSamples() {
        this.updateAnimation();
        int durationInMillis = this.getDurationInMillis();
        int sampleFrames = durationInMillis / 41;
        float sampleStepSize = 1.0f / (float)sampleFrames;
        ArrayList<Float> sampleFractions = new ArrayList<Float>();
        for (float f = 0.0f; f < 1.0f; f += sampleStepSize) {
            sampleFractions.add(Float.valueOf(f));
        }
        sampleFractions.add(Float.valueOf(1.0f));
        File snapshotDir = PatchworkComposerProperties.getIODirectory(IOFileType.SNAPSHOT);
        DecimalFormat indexFormat = new DecimalFormat("000");
        for (int i = 0; i < sampleFractions.size(); ++i) {
            float fraction = ((Float)sampleFractions.get(i)).floatValue();
            Dimension size = this.getOutputSize();
            BufferedImage frameImage = new BufferedImage(size.width, size.height, 2);
            this.getImage(fraction, frameImage);
            String filename = this.getID() + indexFormat.format(i) + ".png";
            try {
                ImageUtils.saveImage(frameImage, new File(snapshotDir, filename));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void getImage(float elapsedFraction, BufferedImage destination) {
        BufferedImage graphicImage;
        Graphics2D g2 = (Graphics2D)destination.getGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, destination.getWidth(), destination.getHeight());
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setComposite(AlphaComposite.SrcOver);
        LocationLayerGraphic graphic = this.getGraphic();
        BufferedImage bufferedImage = graphicImage = graphic == null ? null : graphic.getImage(elapsedFraction);
        if (graphicImage != null) {
            for (String nodeName : this.nodeNamesOrderedByDistance) {
                MotionKeyframes keyframes = this.keyframesByNodeName.get(nodeName);
                if (keyframes == null || !this.isVisible(elapsedFraction, keyframes)) continue;
                BufferedImage subImage = this.partImagesByNodeName.get(nodeName);
                if (subImage == null) {
                    subImage = this.getPartImage(elapsedFraction, graphicImage, nodeName);
                }
                if (subImage == null) continue;
                if (LOGGER.isDebugEnabled()) {
                    // empty if block
                }
                Rectangle4d cutoutBounds = this.cutoutBoundsByNodeName.get(nodeName);
                AffineTransform transform = this.getCurrentTransform(elapsedFraction, keyframes, cutoutBounds);
                g2.drawImage(subImage, transform, null);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            // empty if block
        }
        g2.dispose();
    }

    private BufferedImage getPartImage(float elapsedFraction, BufferedImage fullImage, String nodeName) {
        Rectangle4d cutoutBoundsProportional = this.cutoutBoundsByNodeName.get(nodeName);
        if (cutoutBoundsProportional == null) {
            return fullImage;
        }
        Dimension graphicSize = this.getGraphic().getOutputSize();
        Rectangle4d sourceImageBounds = new Rectangle4d(0.0, 0.0, graphicSize.width, graphicSize.height).fromProportional(cutoutBoundsProportional);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(nodeName + " graphic bounds: " + this.getGraphic().getOutputBounds());
            LOGGER.debug(nodeName + " sub bounds: " + cutoutBoundsProportional);
        }
        int fluff = 5;
        Rectangle rect = sourceImageBounds.asAWTRectangle();
        rect.grow(fluff, fluff);
        BufferedImage result = null;
        try {
            result = ImageUtils.safeSubimage(fullImage, rect.x, rect.y, rect.width, rect.height);
        }
        catch (RasterFormatException ex) {
            LOGGER.warn("Raster Format Exception: ", ex);
        }
        MotionKeyframes keyframes = this.keyframesByNodeName.get(nodeName);
        if (keyframes != null) {
            Point2D.Double partScale = this.getPartScale(elapsedFraction, keyframes);
            if (partScale.x != 1.0 || partScale.y != 1.0) {
                result = ImageUtils.scale(result, (float)partScale.x, (float)partScale.y);
            }
        }
        return result;
    }

    private void clearAnimation() {
        this.animationNeedsUpdate = true;
    }

    private void updateAnimation() {
        if (!this.animationNeedsUpdate) {
            return;
        }
        this.keyframesByNodeName.clear();
        this.cutoutBoundsByNodeName.clear();
        this.nodeNamesOrderedByDistance.clear();
        this.partImagesByNodeName.clear();
        this.maxKeyframe = 0.0;
        LocationLayerGraphic graphic = this.getGraphic();
        BufferedImage graphicImage = null;
        if (graphic != null && !graphic.isAnimated()) {
            graphicImage = graphic.getImage(0.0f);
        }
        this.updateOrthoFrame();
        this.updateCutoutFrame();
        SceneGraph sceneGraph = this.getSceneGraph();
        if (sceneGraph != null && !this.animationNodeNames.isEmpty()) {
            for (String nodeName : this.animationNodeNames) {
                try {
                    double thisMaxKeyframe;
                    MotionKeyframes keyframes = new MotionKeyframes(sceneGraph, nodeName);
                    Rectangle4d cutoutBounds = this.getCutoutBounds(keyframes);
                    this.keyframesByNodeName.put(nodeName, keyframes);
                    if (cutoutBounds != null) {
                        this.cutoutBoundsByNodeName.put(nodeName, cutoutBounds);
                    }
                    if (graphicImage != null && keyframes.getScaleKeyframeCount() < 2) {
                        BufferedImage partImage = this.getPartImage(0.0f, graphicImage, nodeName);
                        this.partImagesByNodeName.put(nodeName, partImage);
                    }
                    if (!((thisMaxKeyframe = keyframes.getMaxKeyframe()) > this.maxKeyframe)) continue;
                    this.maxKeyframe = thisMaxKeyframe;
                }
                catch (IllegalArgumentException ex) {}
            }
        }
        this.nodeNamesOrderedByDistance.addAll(this.animationNodeNames);
        Collections.sort(this.nodeNamesOrderedByDistance, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Double.compare(MotionKeyframesGraphic.this.getZDistance(o2), MotionKeyframesGraphic.this.getZDistance(o1));
            }
        });
        this.animationNeedsUpdate = false;
    }

    private File getInputFile() {
        if (this.animationColladaFile == null) {
            return null;
        }
        return new File(PatchworkComposerProperties.getIODirectory(IOFileType.COLLADA), this.animationColladaFile.getName());
    }

    private SceneGraph getSceneGraph() {
        if (this.sceneGraph == null) {
            PatchworkProject project = (PatchworkProject)this.getPath().get(0);
            if (project.isPublished()) {
                InputStream inputStream = ResourceManager.getInputStream(this.getPublishedFilename());
                if (inputStream != null) {
                    this.sceneGraph = new COLLADALoader().load(inputStream);
                } else {
                    LOGGER.warn("Failed to load scenegraph: " + this.getPublishedFilename());
                }
            } else if (this.animationColladaFile != null) {
                File inputFile = new File(this.getIODirectory(IOFileType.COLLADA), this.animationColladaFile.getName());
                this.sceneGraph = new COLLADALoader().load(inputFile);
            }
        }
        return this.sceneGraph;
    }

    private void drawIndicator(Graphics2D graphics, AffineTransform transform) {
        graphics.setComposite(AlphaComposite.SrcOver);
        graphics.setTransform(transform);
        int size = 8;
        int topLength = 3 * size;
        graphics.setColor(Color.BLACK);
        int x = 0;
        int y = 0;
        graphics.drawLine(x - size, y, x + size, y);
        graphics.drawLine(x, y - topLength, x, y + size);
        graphics.setColor(Color.YELLOW);
        graphics.drawLine(x - size, y - 1, x - 1, y - 1);
        graphics.drawLine(x - size, y + 1, x - 1, y + 1);
        graphics.drawLine(x + 1, y - 1, x + size, y - 1);
        graphics.drawLine(x + 1, y + 1, x + size, y + 1);
        graphics.drawLine(x - 1, y - topLength, x - 1, y - 1);
        graphics.drawLine(x + 1, y - topLength, x + 1, y - 1);
        graphics.drawLine(x - 1, y + 1, x - 1, y + size);
        graphics.drawLine(x + 1, y + 1, x + 1, y + size);
    }

    private AffineTransform getCurrentTransform(float elapsedFraction, MotionKeyframes motionKeyframes, Rectangle4d cutoutBounds) {
        Point3d currentPosition = new Point3d();
        motionKeyframes.getPosition(elapsedFraction, currentPosition);
        Point3d positionDisplay = this.globalToDisplay(currentPosition);
        Point3d startingDisplay = this.globalToDisplay(motionKeyframes.getStartingPosition());
        Point3d endingDisplay = this.globalToDisplay(motionKeyframes.getEndingPosition());
        if (this.isPixelSnapEnabled() && (positionDisplay.distance(startingDisplay) < 0.001 || positionDisplay.distance(endingDisplay) < 0.001)) {
            positionDisplay.setX(Math.round(positionDisplay.getX()));
            positionDisplay.setY(Math.round(positionDisplay.getY()));
        }
        EnumMap<GeometricAxis, Double> currentAngles = new EnumMap<GeometricAxis, Double>(GeometricAxis.class);
        motionKeyframes.getRotation(elapsedFraction, currentAngles);
        double angle = (Double)currentAngles.get((Object)this.normalAxis);
        switch (this.translationKeyframeMode) {
            case RELATIVE_TO_START: {
                positionDisplay.sub(startingDisplay);
                break;
            }
            case RELATIVE_TO_END: {
                positionDisplay.sub(endingDisplay);
                break;
            }
        }
        switch (this.rotationKeyframeMode) {
            case RELATIVE_TO_START: {
                angle -= motionKeyframes.getStartingAngle(this.normalAxis);
                break;
            }
            case RELATIVE_TO_END: {
                angle -= motionKeyframes.getEndingAngle(this.normalAxis);
                break;
            }
        }
        if (this.normalAxis == GeometricAxis.Z) {
            angle = -angle;
        }
        AffineTransform transform = new AffineTransform();
        transform.translate(positionDisplay.getX(), positionDisplay.getY());
        transform.rotate(angle);
        Point offset = this.getGraphicOffset(elapsedFraction, motionKeyframes, cutoutBounds);
        Rectangle4d outputBounds = this.getOutputBounds();
        offset.translate((int)(-outputBounds.getX()), (int)(-outputBounds.getY()));
        AffineTransform offsetTransform = new AffineTransform();
        offsetTransform.setToTranslation(offset.x, offset.y);
        transform.concatenate(offsetTransform);
        return transform;
    }

    private Point getGraphicOffset(float elapsedFraction, MotionKeyframes motionKeyframes, Rectangle4d cutoutBounds) {
        Point result = new Point();
        LocationLayerGraphic graphic = this.getGraphic();
        if (graphic == null) {
            return result;
        }
        result.setLocation(graphic.getCurrentOffset(GridCoords.ORIGIN, 0.0f));
        if (motionKeyframes != null) {
            Point3d pivotGlobalLocation = motionKeyframes.getPivotGlobalLocation();
            if (pivotGlobalLocation != null && cutoutBounds != null) {
                Rectangle pivotRect;
                Point3d pivotDisplay3D;
                if (this.cutoutFrame != null) {
                    pivotDisplay3D = this.globalToPixels(pivotGlobalLocation, this.cutoutFrame, graphic.getOutputSize(), this.cutoutNormalAxis);
                    pivotRect = new Rectangle4d(graphic.getOutputSize()).fromProportional(cutoutBounds).asAWTRectangle();
                } else {
                    pivotDisplay3D = this.globalToDisplay(pivotGlobalLocation);
                    pivotRect = new Rectangle4d(this.getOutputSize()).fromProportional(cutoutBounds).asAWTRectangle();
                }
                Point pivotCenter = new Point((int)pivotDisplay3D.getX(), (int)pivotDisplay3D.getY());
                Point2D.Double childScale = this.getChildScale(elapsedFraction, motionKeyframes);
                int cutoutX = (int)(childScale.x * (double)(pivotRect.x - pivotCenter.x));
                int cutoutY = (int)(childScale.y * (double)(pivotRect.y - pivotCenter.y));
                result.translate(cutoutX, cutoutY);
            } else {
                Rectangle4d graphicBounds = graphic.getOutputBounds();
                result.translate((int)graphicBounds.getX(), (int)graphicBounds.getY());
            }
        }
        return result;
    }

    private Point2D.Double getPartScale(float elapsedFraction, MotionKeyframes motionKeyframes) {
        Point2D.Double childScale = this.getChildScale(elapsedFraction, motionKeyframes);
        Point2D.Double parentScale = this.getParentScale();
        return new Point2D.Double(childScale.x * parentScale.x, childScale.y * parentScale.y);
    }

    private Point2D.Double getParentScale() {
        Rectangle4d sourcePixelBounds = this.getGraphic().getOutputBounds();
        Rectangle4d destPixelBounds = this.getOutputBounds();
        Rectangle4d destWorldBounds = this.orthoFrame == null ? Rectangle4d.UNIT_RECTANGLE : this.orthoFrame;
        Rectangle4d sourceWorldBounds = this.cutoutFrame == null ? destWorldBounds : this.cutoutFrame;
        double xPixelsPerUnitSource = sourcePixelBounds.getWidth() / sourceWorldBounds.getWidth();
        double yPixelsPerUnitSource = sourcePixelBounds.getHeight() / sourceWorldBounds.getHeight();
        double xPixelsPerUnitDest = destPixelBounds.getWidth() / destWorldBounds.getWidth();
        double yPixelsPerUnitDest = destPixelBounds.getHeight() / destWorldBounds.getHeight();
        double xScale = xPixelsPerUnitDest / xPixelsPerUnitSource;
        double yScale = yPixelsPerUnitDest / yPixelsPerUnitSource;
        xScale = MathUtils.snap(xScale, 1.0, 0.01);
        yScale = MathUtils.snap(yScale, 1.0, 0.01);
        return new Point2D.Double(xScale, yScale);
    }

    private Point2D.Double getChildScale(float elapsedFraction, MotionKeyframes motionKeyframes) {
        Vector3d scale = new Vector3d();
        motionKeyframes.getScale(elapsedFraction, scale);
        if (LOGGER.isDebugEnabled()) {
            // empty if block
        }
        double xScale = VectorUtils.getComponent(scale, this.getVirtualXAxis(this.normalAxis));
        double yScale = VectorUtils.getComponent(scale, this.getVirtualYAxis(this.normalAxis));
        return new Point2D.Double(xScale, yScale);
    }

    private boolean isVisible(float elapsedFraction, MotionKeyframes motionKeyframes) {
        double yScale;
        double xScale;
        Vector3d scale = new Vector3d();
        motionKeyframes.getScale(elapsedFraction, scale);
        if (LOGGER.isDebugEnabled()) {
            // empty if block
        }
        return Math.min(xScale = VectorUtils.getComponent(scale, this.getVirtualXAxis(this.normalAxis)), yScale = VectorUtils.getComponent(scale, this.getVirtualYAxis(this.normalAxis))) > 0.2;
    }

    private double getZDistance(String nodeName) {
        Point3d pivotGlobalLocation;
        MotionKeyframes motionKeyframes = this.keyframesByNodeName.get(nodeName);
        if (motionKeyframes != null && (pivotGlobalLocation = motionKeyframes.getPivotGlobalLocation()) != null) {
            return VectorUtils.getComponent(pivotGlobalLocation, this.normalAxis);
        }
        return 0.0;
    }

    private Rectangle4d getCutoutBounds(MotionKeyframes motionKeyframes) {
        if (motionKeyframes == null) {
            return null;
        }
        PolyMesh3D pivotMesh = motionKeyframes.getPivotMesh();
        if (pivotMesh == null) {
            return null;
        }
        LocationLayerGraphic graphic = this.getGraphic();
        if (graphic == null) {
            return null;
        }
        Rectangle4d frame = this.cutoutFrame == null ? this.orthoFrame : this.cutoutFrame;
        GeometricAxis normalAxis = this.cutoutFrame == null ? this.normalAxis : this.cutoutNormalAxis;
        Rectangle4d pivotBounds = this.getPolyMeshBounds(pivotMesh, normalAxis);
        Rectangle4d boundsProportional = frame.toProportional(pivotBounds);
        Rectangle4d boundsFlipped = new Rectangle4d(boundsProportional.getX(), 1.0 - (boundsProportional.getY() + boundsProportional.getHeight()), boundsProportional.getWidth(), boundsProportional.getHeight());
        return boundsFlipped;
    }

    private Point3d globalToDisplay(Point3d globalPoint) {
        if (this.orthoFrame != null) {
            return this.globalToPixels(globalPoint, this.orthoFrame, this.getOutputSize(), this.normalAxis);
        }
        SceneLocation location = this.getAncestorByType(SceneLocation.class);
        Rectangle4d viewport = this.getViewport(true);
        return location.getCamera().globalToDisplay(globalPoint, viewport, this.getOutputSize());
    }

    private Point3d globalToPixels(Point3d globalPoint, Rectangle4d globalBounds, Dimension pixelBounds, GeometricAxis normalAxis) {
        Point2D.Double point2D = this.toPoint2D(globalPoint, normalAxis);
        point2D = globalBounds.toProportional(point2D);
        point2D.y = 1.0 - point2D.y;
        point2D = new Rectangle4d(pixelBounds).fromProportional(point2D);
        return new Point3d(point2D.getX(), point2D.getY(), 0.0);
    }

    private Point2D.Double toPoint2D(Tuple3d tuple3d, GeometricAxis normalAxis) {
        GeometricAxis virtualXAxis = this.getVirtualXAxis(normalAxis);
        GeometricAxis virtualYAxis = this.getVirtualYAxis(normalAxis);
        return new Point2D.Double(VectorUtils.getComponent(tuple3d, virtualXAxis), VectorUtils.getComponent(tuple3d, virtualYAxis));
    }

    private void updateOrthoFrame() {
        this.orthoFrame = null;
        this.normalAxis = GeometricAxis.Y;
        PolyMesh3D mesh = this.getMeshInGlobalCoords(this.orthoFrameMeshID);
        if (mesh != null) {
            this.normalAxis = this.getMinDimension(mesh);
            this.orthoFrame = this.getPolyMeshBounds(mesh, this.normalAxis);
        }
    }

    private void updateCutoutFrame() {
        this.cutoutFrame = null;
        this.cutoutNormalAxis = GeometricAxis.Y;
        PolyMesh3D mesh = this.getMeshInGlobalCoords(this.cutoutFrameMeshID);
        if (mesh != null) {
            this.cutoutNormalAxis = this.getMinDimension(mesh);
            this.cutoutFrame = this.getPolyMeshBounds(mesh, this.cutoutNormalAxis);
        }
    }

    private PolyMesh3D getMeshInGlobalCoords(String meshID) {
        if (meshID == null) {
            return null;
        }
        SceneGraph sceneGraph = this.getSceneGraph();
        if (sceneGraph == null) {
            return null;
        }
        return sceneGraph.getMeshInGlobalCoords(meshID);
    }

    private GeometricAxis getMinDimension(PolyMesh3D mesh) {
        BoundingBox3D bbox = mesh.getBoundingBox();
        Vector3d diagonal = bbox.getDiagonal();
        return VectorUtils.getMinDimension(diagonal);
    }

    private Rectangle4d getPolyMeshBounds(PolyMesh3D mesh, GeometricAxis normalAxis) {
        BoundingBox3D bbox = mesh.getBoundingBox();
        Point3d minPoint = new Point3d();
        Point3d maxPoint = new Point3d();
        bbox.getLower(minPoint);
        bbox.getUpper(maxPoint);
        return new Rectangle4d(this.toPoint2D(minPoint, normalAxis), this.toPoint2D(maxPoint, normalAxis));
    }

    private GeometricAxis getVirtualXAxis(GeometricAxis normalAxis) {
        switch (normalAxis) {
            case X: {
                return GeometricAxis.Z;
            }
            case Y: {
                return GeometricAxis.X;
            }
            case Z: {
                return GeometricAxis.X;
            }
        }
        return GeometricAxis.values()[(normalAxis.ordinal() + 1) % 3];
    }

    private GeometricAxis getVirtualYAxis(GeometricAxis normalAxis) {
        switch (normalAxis) {
            case X: {
                return GeometricAxis.Y;
            }
            case Y: {
                return GeometricAxis.Z;
            }
            case Z: {
                return GeometricAxis.Y;
            }
        }
        return GeometricAxis.values()[(normalAxis.ordinal() + 2) % 3];
    }

    private String getPublishedFilename() {
        return this.getGUID() + ".dae";
    }

    public static class Transcoder
    extends LocationLayerGraphic.Transcoder<MotionKeyframesGraphic> {
        private static final String ELEMENT_NAME = "MotionKeyframesGraphic";
        private static final String ATTR_ANIM_FILENAME = "animationFilename";
        private static final String ATTR_ANIM_NODE_NAME = "animationNodeName";
        private static final String ATTR_ORTHO_FRAME_MESH_ID = "orthoFrameMeshID";
        private static final String ATTR_CUTOUT_FRAME_MESH_ID = "cutoutFrameMeshID";
        private static final String ATTR_GRAPHIC = "graphic";
        private static final String ATTR_ROTATION_KF_MODE = "rotationKeyframeMode";
        private static final String ATTR_TRANSLATION_KF_MODE = "translationKeyframeMode";
        private static final String ATTR_PIXEL_SNAP = "pixelSnapEnabled";
        private static final String FIELD_CHILD_GRAPHIC = "graphic";

        public Transcoder() {
            super(ELEMENT_NAME, MotionKeyframesGraphic.class);
            this.setFieldTranscoder("graphic", new SpriteSequenceGraphic.Transcoder(), this, new LayeredImageGraphic.Transcoder());
        }

        @Override
        protected void getAttributes(MotionKeyframesGraphic object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            if (object.animationColladaFile != null) {
                destination.put(ATTR_ANIM_FILENAME, object.animationColladaFile.toString());
            }
            if (!object.animationNodeNames.isEmpty()) {
                destination.put(ATTR_ANIM_NODE_NAME, StringUtils.toDelimitedList(object.animationNodeNames, "|"));
            }
            destination.put(ATTR_ORTHO_FRAME_MESH_ID, object.orthoFrameMeshID);
            destination.put(ATTR_CUTOUT_FRAME_MESH_ID, object.cutoutFrameMeshID);
            destination.put("graphic", object.graphic.encode());
            destination.put(ATTR_TRANSLATION_KF_MODE, object.translationKeyframeMode.name());
            destination.put(ATTR_ROTATION_KF_MODE, object.rotationKeyframeMode.name());
            destination.put(ATTR_PIXEL_SNAP, Boolean.toString(object.pixelSnapEnabled));
        }

        @Override
        protected MotionKeyframesGraphic decodeGraphic(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            MotionKeyframesGraphic result = new MotionKeyframesGraphic(id);
            String animFilename = attributes.get(ATTR_ANIM_FILENAME);
            if (animFilename != null) {
                result.animationColladaFile = new File(animFilename);
            }
            if (attributes.containsKey(ATTR_ANIM_NODE_NAME)) {
                List<String> names = Arrays.asList(StringUtils.decodeStringArray(attributes.get(ATTR_ANIM_NODE_NAME), "\\|"));
                result.animationNodeNames.addAll(names);
            }
            result.orthoFrameMeshID = attributes.get(ATTR_ORTHO_FRAME_MESH_ID);
            result.cutoutFrameMeshID = attributes.get(ATTR_CUTOUT_FRAME_MESH_ID);
            if (attributes.containsKey(ATTR_TRANSLATION_KF_MODE)) {
                result.translationKeyframeMode = KeyframeMode.valueOf(attributes.get(ATTR_TRANSLATION_KF_MODE));
            }
            if (attributes.containsKey(ATTR_ROTATION_KF_MODE)) {
                result.rotationKeyframeMode = KeyframeMode.valueOf(attributes.get(ATTR_ROTATION_KF_MODE));
            }
            if (attributes.containsKey(ATTR_PIXEL_SNAP)) {
                result.pixelSnapEnabled = Boolean.valueOf(attributes.get(ATTR_PIXEL_SNAP));
            }
            result.graphic = new Reference<String>((ProjectComponent)result, attributes.get("graphic"));
            return result;
        }
    }

    public static enum KeyframeMode {
        RELATIVE_TO_START{

            public String toString() {
                return "Relative to Start";
            }
        }
        ,
        RELATIVE_TO_END{

            public String toString() {
                return "Relative to End";
            }
        }
        ,
        ABSOLUTE{

            public String toString() {
                return "Absolute";
            }
        };

    }
}

