/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.graphic;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.ReferenceList;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.CardLink;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewer;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridViewerPanel;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.CompareUtilities;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class HoleGraphic
extends LocationLayerGraphic {
    public static final Icon ICON = IconLoader.loadIcon("silk/door_open.png");
    private ReferenceList<SceneLayerState> blankFillStates = new ReferenceList();
    private Reference<LocationLayerGraphic> maskGraphic = new Reference();
    private Reference<Card> showCard = new Reference();
    private CardViewer cardViewer;
    private BufferedImage blankImage;
    private static final Logger LOGGER = Logger.getLogger(HoleGraphic.class);

    public HoleGraphic(String id) {
        super(id);
    }

    public List<SceneLayerState> getBlankFillStates() {
        return this.blankFillStates.resolve();
    }

    public void clearBlankFillStates() {
        this.blankFillStates.resolve().clear();
        this.fireModified();
    }

    public void addBlankFillState(SceneLayerState state) {
        this.blankFillStates.resolve().add(state);
        this.fireModified();
    }

    public void removeBlankFillState(SceneLayerState state) {
        this.blankFillStates.resolve().remove(state);
        this.fireModified();
    }

    public void setCardViewer(CardViewer cardViewer) {
        this.cardViewer = cardViewer;
    }

    public LocationLayerGraphic getMaskGraphic() {
        return this.maskGraphic.resolve();
    }

    public void setMaskGraphic(LocationLayerGraphic maskGraphic) {
        this.maskGraphic = new Reference<LocationLayerGraphic>((ProjectComponent)this, maskGraphic);
        this.fireModified();
    }

    public Card getShowCard() {
        return this.showCard.resolve();
    }

    public void setShowCard(Card showCard) {
        this.showCard = new Reference<Card>((ProjectComponent)this, showCard);
        this.fireModified();
    }

    public boolean isSealed() {
        if (this.cardViewer == null) {
            return true;
        }
        SceneLocationLayer locLayer = this.getAncestorByType(SceneLocationLayer.class);
        SceneLayerState state = this.cardViewer.getCurrentState(locLayer.getSceneLayer());
        if (this.getBlankFillStates().contains(state)) {
            return true;
        }
        if (this.getCapturedCardViewers().isEmpty()) {
            Card card;
            if (this.cardViewer.isInTransition()) {
                return true;
            }
            GridViewerPanel gridViewer = this.cardViewer.getGridViewerPanel();
            if (!gridViewer.isInPlay(card = this.getAncestorByType(Card.class))) {
                return true;
            }
            SceneLocation sceneLocation = this.getAncestorByType(SceneLocation.class);
            if (!CompareUtilities.equals(sceneLocation, this.cardViewer.getCurrentLocation())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAnimated() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public BufferedImage getImageImpl(float elapsedFraction, boolean doScale) {
        BufferedImage unMasked = this.getUnmaskedImage();
        LocationLayerGraphic maskGraphic = this.getMaskGraphic();
        if (maskGraphic == null) {
            return unMasked;
        }
        BufferedImage maskImage = maskGraphic.getImage(elapsedFraction);
        if (maskImage == null) {
            return unMasked;
        }
        BufferedImage result = new BufferedImage(maskImage.getWidth(), maskImage.getHeight(), 2);
        Rectangle imageRect = PatchworkProject.CARD_RECT.fromProportional(this.getMarginsRegion()).asAWTRectangle();
        Graphics2D g2 = result.createGraphics();
        g2.drawImage((Image)maskImage, 0, 0, null);
        if (unMasked != null) {
            g2.setComposite(AlphaComposite.SrcIn);
            g2.drawImage((Image)unMasked, -imageRect.x, -imageRect.y, null);
        }
        g2.dispose();
        return result;
    }

    @Override
    public AlphaComposite getAlphaComposite() {
        if (!this.isSealed() && this.getUnderCardViewer() == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this.getAncestorByType(Card.class) + ": " + this.getIDPath(1) + " is transparent.");
            }
            return AlphaComposite.DstOut;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.getAncestorByType(Card.class) + ": " + this.getIDPath(1) + " is opaque.");
        }
        return super.getAlphaComposite();
    }

    @Override
    public int getDurationInMillis() {
        return 0;
    }

    @Override
    public void setMarginsRegion(Rectangle4d renderRegion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Rectangle4d getMarginsRegion() {
        LocationLayerGraphic maskGraphic = this.getMaskGraphic();
        if (maskGraphic != null) {
            return maskGraphic.getMarginsRegion();
        }
        return new Rectangle4d(0.0, 0.0, 1.0, 1.0);
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    private BufferedImage getUnmaskedImage() {
        if (this.cardViewer == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this.getAncestorByType(Card.class) + ": " + this.getIDPath(1) + " has no viewer.");
            }
            return null;
        }
        if (this.isSealed()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this.getAncestorByType(Card.class) + ": " + this.getIDPath(1) + " is sealed.");
            }
            return this.getBlankImage();
        }
        CardViewer underCardViewer = this.getUnderCardViewer();
        if (underCardViewer != null) {
            underCardViewer.prepareForDisplay();
            BufferedImage result = underCardViewer.getSnapshotImage(true, true);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this.getIDPath(1) + " shows undercard: " + underCardViewer.getCard().getID());
            }
            return result;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.getAncestorByType(Card.class) + ": " + this.getIDPath(1) + " is blank fill.");
        }
        return this.getBlankImage();
    }

    private CardViewer getUnderCardViewer() {
        GridViewerPanel gridViewer = this.cardViewer.getGridViewerPanel();
        Card ownerCard = this.getAncestorByType(Card.class);
        List<CardViewer> capturedCardViewers = this.getCapturedCardViewers();
        Card showCard = this.getShowCard();
        if (showCard != null) {
            CardViewer showCardViewer = gridViewer.getCardViewer(showCard);
            if (capturedCardViewers.contains(showCardViewer)) {
                return showCardViewer;
            }
            return null;
        }
        if (!capturedCardViewers.isEmpty()) {
            return capturedCardViewers.get(0);
        }
        Card underCard = gridViewer.getUnderCard(ownerCard);
        if (underCard != null) {
            return gridViewer.getCardViewer(underCard);
        }
        return null;
    }

    private List<CardViewer> getCapturedCardViewers() {
        ArrayList<CardViewer> result = new ArrayList<CardViewer>();
        SceneLocation sceneLocation = this.getAncestorByType(SceneLocation.class);
        GridViewerPanel gridViewer = this.cardViewer.getGridViewerPanel();
        result.addAll(this.cardViewer.getUnderCapturedCards());
        for (CardLink cardLink : sceneLocation.getCardLinks()) {
            CardViewer otherCardViewer;
            Card otherCard;
            if (!cardLink.isOriginating() || (otherCard = cardLink.getOtherCard()) == null || (otherCardViewer = gridViewer.getCardViewer(otherCard)).isInPlay() || gridViewer.isCaptured(otherCard)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this.getIDPath(1) + " adding implicit capture card: " + otherCard.getID());
            }
            result.add(otherCardViewer);
        }
        return result;
    }

    private BufferedImage getBlankImage() {
        if (this.blankImage == null) {
            this.blankImage = new BufferedImage(PatchworkProject.CARD_SIZE, PatchworkProject.CARD_SIZE, 2);
            Graphics2D g2 = this.blankImage.createGraphics();
            g2.setColor(PatchworkProject.GRID_BG_COLOR);
            g2.fillRect(0, 0, PatchworkProject.CARD_SIZE, PatchworkProject.CARD_SIZE);
            g2.dispose();
        }
        return this.blankImage;
    }

    public static class Transcoder
    extends LocationLayerGraphic.Transcoder<HoleGraphic> {
        private static final String ELEMENT_NAME = "HoleGraphic";
        private static final String ATTR_MASK_GRAPHIC = "maskGraphic";
        private static final String ATTR_SHOW_CARD = "showCard";
        private static final String ATTR_BLANK_FILL_STATES = "blankFillStates";

        public Transcoder() {
            super(ELEMENT_NAME, HoleGraphic.class);
        }

        @Override
        protected void getAttributes(HoleGraphic object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_BLANK_FILL_STATES, object.blankFillStates.encode());
            destination.put(ATTR_MASK_GRAPHIC, object.maskGraphic.encode());
            destination.put(ATTR_SHOW_CARD, object.showCard.encode());
        }

        @Override
        protected HoleGraphic decodeGraphic(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            HoleGraphic result = new HoleGraphic(id);
            result.maskGraphic = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_MASK_GRAPHIC));
            result.showCard = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_SHOW_CARD));
            result.blankFillStates = new ReferenceList(result, attributes.get(ATTR_BLANK_FILL_STATES));
            return result;
        }
    }
}

