/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.behavior;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.LocationTransitionAnimation;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.ReferenceList;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.AbstractViewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.resource.ResourceManager;
import com.sodiumarc.patchwork.render.scenegraph.COLLADALoader;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraph;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraphNode;
import com.sodiumarc.patchwork.render.scenegraph.TransformAnimator;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.vecmath.Vector3d;

public class LocationTransition
extends ProjectComponent {
    public static final BufferedImage HS_BUTTON_IMAGE = ResourceManager.getImageResource("system/hs_button.png");
    public static final BufferedImage HS_BUTTON_IMAGE_OVER = ResourceManager.getImageResource("system/hs_button_over.png");
    public static final Icon ICON = IconLoader.loadIcon("silk/arrow_in.png");
    public static final int DEFAULT_TRANSITION_DURATION = 800;
    private Rectangle4d hotspotRegion = new Rectangle4d(0.25, 0.25, 0.5, 0.5);
    private Reference<SceneLocation> destLocation = new Reference();
    private Reference<AbstractViewpoint> animStartViewpoint = new Reference();
    private Reference<AbstractViewpoint> animEndViewpoint = new Reference();
    private Reference<SceneLocation> animStartLocation = new Reference();
    private Reference<SceneLocation> animEndLocation = new Reference();
    private HotspotStyle hotspotStyle = HotspotStyle.REGION;
    private File animationColladaFile;
    private String animationNodeName;
    private int animationStartFrame;
    private int transitionDuration = 800;
    private SceneGraph sceneGraph;
    private LocationTransitionAnimation transitionAnimation;
    private ReferenceList<SceneLayerState> attachedStates = new ReferenceList();

    public LocationTransition(String id) {
        super(id);
    }

    public void setHotspotRegion(Rectangle4d region) {
        this.hotspotRegion = region;
        this.fireModified(this.getPath());
    }

    public Rectangle4d getHotspotRegion() {
        switch (this.getHotspotStyle()) {
            case BACK_BUTTON: 
            case LEFT_BUTTON: 
            case RIGHT_BUTTON: {
                return new Rectangle4d(this.hotspotRegion.getX(), this.hotspotRegion.getY(), (double)HS_BUTTON_IMAGE.getWidth() / (double)PatchworkProject.CARD_SIZE, (double)HS_BUTTON_IMAGE.getHeight() / (double)PatchworkProject.CARD_SIZE);
            }
        }
        return this.hotspotRegion;
    }

    public void setDestLocation(SceneLocation location) {
        this.destLocation = new Reference<SceneLocation>((ProjectComponent)this, location);
        this.updateTransitionAnimation();
        this.fireModified();
    }

    public SceneLocation getDestLocation() {
        return this.destLocation.resolve();
    }

    public AbstractViewpoint getAnimStartViewpoint() {
        return this.animStartViewpoint.resolve();
    }

    public void setAnimStartViewpoint(AbstractViewpoint animStartLocation) {
        this.animStartViewpoint = new Reference<AbstractViewpoint>((ProjectComponent)this, animStartLocation);
        this.fireModified();
    }

    public AbstractViewpoint getAnimEndViewpoint() {
        return this.animEndViewpoint.resolve();
    }

    public void setAnimEndViewpoint(AbstractViewpoint animEndLocation) {
        this.animEndViewpoint = new Reference<AbstractViewpoint>((ProjectComponent)this, animEndLocation);
        this.fireModified();
    }

    public SceneLocation getAnimStartLocation() {
        return this.animStartLocation.resolve();
    }

    public void setAnimStartLocation(SceneLocation animStartLocation) {
        this.animStartLocation = new Reference<SceneLocation>((ProjectComponent)this, animStartLocation);
        this.updateTransitionAnimation();
        this.fireModified();
    }

    public SceneLocation getAnimEndLocation() {
        return this.animEndLocation.resolve();
    }

    public void setAnimEndLocation(SceneLocation animEndLocation) {
        this.animEndLocation = new Reference<SceneLocation>((ProjectComponent)this, animEndLocation);
        this.updateTransitionAnimation();
        this.fireModified();
    }

    public SceneLocation getOriginLocation() {
        return this.getAncestorByType(SceneLocation.class);
    }

    public void setHotspotStyle(HotspotStyle style) {
        this.hotspotStyle = style;
        this.updateTransitionAnimation();
        this.fireModified();
    }

    public HotspotStyle getHotspotStyle() {
        return this.hotspotStyle;
    }

    public List<SceneLayerState> getAttachedStates() {
        return this.attachedStates.resolve();
    }

    public boolean isActiveForState(Map<SceneLayer, SceneLayerState> currentStates) {
        List<SceneLayerState> attachedStates = this.getAttachedStates();
        if (attachedStates.isEmpty()) {
            return true;
        }
        for (SceneLayerState state : attachedStates) {
            if (currentStates.get(state.getParentComponent()) != state) continue;
            return true;
        }
        return false;
    }

    public void clearAttachedStates() {
        this.attachedStates.resolve().clear();
        this.fireModified();
    }

    public void addAttachedState(SceneLayerState state) {
        this.attachedStates.resolve().add(state);
        this.fireModified();
    }

    public int getTransitionDuration() {
        return this.transitionDuration;
    }

    public void setTransitionDuration(int transitionDuration) {
        this.transitionDuration = transitionDuration;
        this.updateTransitionAnimation();
        this.fireModified();
    }

    public LocationTransitionAnimation getTransitionAnimation() {
        if (this.transitionAnimation == null) {
            this.updateTransitionAnimation();
        }
        return this.transitionAnimation;
    }

    public String getInputFilename() {
        File file = this.getInputFile();
        return file == null ? null : file.getName();
    }

    public void setInputFilename(String inputFilename) {
        this.animationColladaFile = inputFilename == null ? null : new File(this.getIODirectory(IOFileType.COLLADA), inputFilename);
        this.sceneGraph = null;
        this.updateTransitionAnimation();
        this.fireModified();
    }

    public String getAnimationNodeName() {
        return this.animationNodeName;
    }

    public void setAnimationNodeName(String nodeName) {
        this.animationNodeName = nodeName;
        this.updateTransitionAnimation();
        this.fireModified();
    }

    public List<String> getAnimatedNodeNames() {
        ArrayList<String> result = new ArrayList<String>();
        SceneGraph sceneGraph = this.getSceneGraph();
        if (sceneGraph != null) {
            for (SceneGraphNode node : sceneGraph.getAnimatedNodes()) {
                result.add(node.getName());
            }
        }
        return result;
    }

    public int getAnimationStartFrame() {
        return this.animationStartFrame;
    }

    public void setAnimationStartFrame(int frame) {
        this.animationStartFrame = frame;
        this.updateTransitionAnimation();
        this.fireModified();
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    private File getInputFile() {
        if (this.animationColladaFile != null) {
            return this.animationColladaFile;
        }
        Scene scene = this.getAncestorByType(Scene.class);
        if (scene == null) {
            return null;
        }
        return scene.getInputFile();
    }

    private SceneGraph getSceneGraph() {
        File inputFile = this.getInputFile();
        if (inputFile == null) {
            return this.getAncestorByType(Scene.class).getSceneGraph();
        }
        if (this.sceneGraph == null) {
            inputFile = new File(this.getIODirectory(IOFileType.COLLADA), inputFile.getName());
            this.sceneGraph = new COLLADALoader().load(inputFile);
        }
        return this.sceneGraph;
    }

    private TransformAnimator<Vector3d> getPositionKeyframes() {
        return null;
    }

    private void updateTransitionAnimation() {
        Scene destScene;
        Scene originScene;
        if (this.transitionAnimation == null) {
            this.transitionAnimation = new LocationTransitionAnimation(this.getID());
        }
        SceneLocation animStartLocation = this.getAnimStartLocation();
        SceneLocation animEndLocation = this.getAnimEndLocation();
        SceneLocation origin = this.getAncestorByType(SceneLocation.class);
        if (animStartLocation != null) {
            origin = animStartLocation;
        }
        SceneLocation destination = this.getDestLocation();
        if (animEndLocation != null) {
            destination = animEndLocation;
        }
        if (origin != null && destination != null && (originScene = origin.getParentComponent()) != (destScene = destination.getParentComponent())) {
            if (this.hotspotStyle == HotspotStyle.BACK_BUTTON) {
                SceneLocation byWayOfLocation = null;
                for (SceneLocation location : destScene.getLocations()) {
                    if (!origin.equals(location.getBackgroundLocation())) continue;
                    byWayOfLocation = location;
                    break;
                }
                if (byWayOfLocation != null) {
                    origin = byWayOfLocation;
                }
            } else {
                SceneLocation byWayOfLocation = null;
                for (SceneLocation location : originScene.getLocations()) {
                    if (!destination.equals(location.getBackgroundLocation())) continue;
                    byWayOfLocation = location;
                    break;
                }
                if (byWayOfLocation != null) {
                    destination = byWayOfLocation;
                }
            }
        }
        this.transitionAnimation.setPositionKeyframes(this.getPositionKeyframes());
        this.transitionAnimation.setStartKeyframe(this.animationStartFrame);
        this.transitionAnimation.setFromLocation(origin);
        this.transitionAnimation.setToLocation(destination);
        this.transitionAnimation.setFromViewpoint(this.animStartViewpoint.resolve());
        this.transitionAnimation.setToViewpoint(this.animEndViewpoint.resolve());
        this.transitionAnimation.setDurationInMillis(this.transitionDuration);
    }

    public static enum HotspotStyle {
        NONE{

            public String toString() {
                return "None";
            }
        }
        ,
        REGION{

            public String toString() {
                return "Region";
            }
        }
        ,
        BACK_BUTTON{

            public String toString() {
                return "Back Button";
            }
        }
        ,
        LEFT_BUTTON{

            public String toString() {
                return "Left Button";
            }
        }
        ,
        RIGHT_BUTTON{

            public String toString() {
                return "Right Button";
            }
        };

    }

    public static class Transcoder
    extends ProjectComponent.Transcoder<LocationTransition> {
        private static final String ELEMENT_NAME = "LocationTransition";
        private static final String ATTR_HOTSPOT_STYLE = "hotspotStyle";
        private static final String ATTR_HOTSPOT_REGION = "hotspotRegion";
        private static final String ATTR_DEST = "destLocation";
        private static final String ATTR_ANIM_START_VP = "animStartViewpoint";
        private static final String ATTR_ANIM_END_VP = "animEndViewpoint";
        private static final String ATTR_ANIM_START_LOC = "animStartLocation";
        private static final String ATTR_ANIM_END_LOC = "animEndLocation";
        private static final String ATTR_DURATION = "transitionDuration";
        private static final String ATTR_ATTACHED_STATES = "attachedStates";
        private static final String ATTR_ANIM_FILENAME = "animationFilename";
        private static final String ATTR_ANIM_NODE_NAME = "animationNodeName";
        private static final String ATTR_ANIM_START_FRAME = "animationStartFrame";

        public Transcoder() {
            super(ELEMENT_NAME, LocationTransition.class);
        }

        @Override
        protected LocationTransition decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            String durationString;
            LocationTransition result = new LocationTransition(id);
            if (attributes.containsKey(ATTR_HOTSPOT_REGION)) {
                result.setHotspotRegion(new Rectangle4d(attributes.get(ATTR_HOTSPOT_REGION)));
            }
            result.destLocation = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_DEST));
            result.animStartViewpoint = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_ANIM_START_VP));
            result.animEndViewpoint = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_ANIM_END_VP));
            result.animStartLocation = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_ANIM_START_LOC));
            result.animEndLocation = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_ANIM_END_LOC));
            String styleString = attributes.get(ATTR_HOTSPOT_STYLE);
            if (styleString != null) {
                result.hotspotStyle = HotspotStyle.valueOf(styleString);
            }
            if ((durationString = attributes.get(ATTR_DURATION)) != null) {
                result.transitionDuration = Integer.valueOf(durationString);
            }
            result.attachedStates = new ReferenceList(result, attributes.get(ATTR_ATTACHED_STATES));
            String animFilename = attributes.get(ATTR_ANIM_FILENAME);
            if (animFilename != null) {
                result.animationColladaFile = new File(animFilename);
            }
            result.animationNodeName = attributes.get(ATTR_ANIM_NODE_NAME);
            if (attributes.containsKey(ATTR_ANIM_START_FRAME)) {
                result.animationStartFrame = Integer.valueOf(attributes.get(ATTR_ANIM_START_FRAME));
            }
            return result;
        }

        @Override
        protected void getAttributes(LocationTransition object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_HOTSPOT_REGION, object.getHotspotRegion().encode());
            destination.put(ATTR_DEST, object.destLocation.encode());
            destination.put(ATTR_ANIM_START_VP, object.animStartViewpoint.encode());
            destination.put(ATTR_ANIM_END_VP, object.animEndViewpoint.encode());
            destination.put(ATTR_ANIM_START_LOC, object.animStartLocation.encode());
            destination.put(ATTR_ANIM_END_LOC, object.animEndLocation.encode());
            destination.put(ATTR_HOTSPOT_STYLE, object.hotspotStyle.name());
            destination.put(ATTR_DURATION, Integer.toString(object.transitionDuration));
            destination.put(ATTR_ATTACHED_STATES, object.attachedStates.encode());
            if (object.animationColladaFile != null) {
                destination.put(ATTR_ANIM_FILENAME, object.animationColladaFile.toString());
            }
            destination.put(ATTR_ANIM_NODE_NAME, object.animationNodeName);
            destination.put(ATTR_ANIM_START_FRAME, Integer.toString(object.animationStartFrame));
        }

        @Override
        protected void getChildren(LocationTransition object, MultiMap<String, Object> destination) {
        }
    }
}

