/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model.behavior;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.GridDirection;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.ReferenceList;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.Predicate;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class CardLink
extends ProjectComponent {
    public static final Icon ICON = IconLoader.loadIcon("silk/picture_link.png");
    private Reference<Card> otherCard;
    private GridDirection direction = GridDirection.UNDER;
    private boolean isOriginator;
    private ReferenceList<SceneLayerState> attachedStates;
    private final List<Predicate> predicates;
    private Predicate.Operator predicateOperator = Predicate.Operator.ALL;
    private String predicateFormula = null;

    public CardLink(String id) {
        super(id);
        this.otherCard = new Reference();
        this.attachedStates = new ReferenceList();
        this.predicates = new ArrayList<Predicate>();
        this.registerChildType(Predicate.class, Predicate.ICON, true);
    }

    public Card getOtherCard() {
        return this.otherCard.resolve();
    }

    public void setOtherCard(Card otherCard) {
        this.otherCard = new Reference<Card>((ProjectComponent)this, otherCard);
        this.fireModified();
    }

    public GridDirection getDirection() {
        return this.direction;
    }

    public void setDirection(GridDirection direction) {
        assert (direction != null) : "Null direction not allowed";
        this.direction = direction;
        this.fireModified();
    }

    public boolean isAbsorbant() {
        return this.isOriginator;
    }

    public boolean isOriginating() {
        return this.isOriginator;
    }

    public void setOriginator(boolean isOriginator) {
        this.isOriginator = isOriginator;
        this.fireModified();
    }

    public List<SceneLayerState> getAttachedStates() {
        return this.attachedStates.resolve();
    }

    public boolean isActiveForState(Map<SceneLayer, SceneLayerState> currentStates) {
        List<SceneLayerState> attachedStates = this.getAttachedStates();
        if (attachedStates.isEmpty()) {
            return true;
        }
        for (SceneLayerState state : attachedStates) {
            if (currentStates.get(state.getParentComponent()) != state) continue;
            return true;
        }
        return false;
    }

    public void clearAttachedStates() {
        this.attachedStates.resolve().clear();
        this.fireModified();
    }

    public void addAttachedState(SceneLayerState state) {
        this.attachedStates.resolve().add(state);
        this.fireModified();
    }

    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    public Predicate.Operator getPredicateOperator() {
        return this.predicateOperator;
    }

    public void setPredicateOperator(Predicate.Operator predicateOperator) {
        this.predicateOperator = predicateOperator;
        this.fireModified();
    }

    public String getPredicateFormula() {
        return this.predicateFormula;
    }

    public void setPredicateFormula(String booleanFormula) {
        this.predicateFormula = booleanFormula;
        this.fireModified();
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public void addChildComponent(String id, Class<? extends ProjectComponent> type) {
        if (type.equals(Predicate.class)) {
            this.addPredicate(new Predicate(id), true);
        }
    }

    @Override
    public void removeChildComponent(ProjectComponent child) {
        if (child instanceof Predicate) {
            this.removePredicate((Predicate)child, true);
        }
    }

    private void addPredicate(Predicate predicate, boolean notify) {
        this.predicates.add(predicate);
        this.registerChild(predicate, notify);
    }

    private void removePredicate(Predicate predicate, boolean notify) {
        this.predicates.remove(predicate);
        this.removeChild(predicate, notify);
    }

    public static class Transcoder
    extends ProjectComponent.Transcoder<CardLink> {
        private static final String ELEMENT_NAME = "CardLink";
        private static final String ATTR_OTHER_CARD = "otherCard";
        private static final String ATTR_DIRECTION = "direction";
        private static final String ATTR_IS_ORIGINATOR = "isOriginator";
        private static final String ATTR_ATTACHED_STATES = "attachedStates";
        private static final String ATTR_PREDICATE_OPERATOR = "predicateOperator";
        private static final String ATTR_PREDICATE_FORMULA = "predicateFormula";
        private static final String FIELD_PREDICATES = "predicates";

        public Transcoder() {
            super(ELEMENT_NAME, CardLink.class);
            this.setFieldTranscoder(FIELD_PREDICATES, new Predicate.Transcoder());
        }

        @Override
        protected CardLink decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            CardLink result = new CardLink(id);
            result.otherCard = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_OTHER_CARD));
            if (attributes.containsKey(ATTR_DIRECTION)) {
                result.direction = GridDirection.valueOf(attributes.get(ATTR_DIRECTION));
            }
            if (attributes.containsKey(ATTR_IS_ORIGINATOR)) {
                result.isOriginator = Boolean.valueOf(attributes.get(ATTR_IS_ORIGINATOR));
            }
            result.attachedStates = new ReferenceList(result, attributes.get(ATTR_ATTACHED_STATES));
            if (attributes.containsKey(ATTR_PREDICATE_OPERATOR)) {
                result.predicateOperator = Predicate.Operator.valueOf(attributes.get(ATTR_PREDICATE_OPERATOR));
            }
            result.predicateFormula = attributes.get(ATTR_PREDICATE_FORMULA);
            for (Object predicate : decodedChildren.getAll(FIELD_PREDICATES)) {
                result.addPredicate((Predicate)predicate, false);
            }
            return result;
        }

        @Override
        protected void getAttributes(CardLink object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_OTHER_CARD, object.otherCard.encode());
            destination.put(ATTR_DIRECTION, object.direction.name());
            destination.put(ATTR_IS_ORIGINATOR, Boolean.toString(object.isOriginator));
            destination.put(ATTR_ATTACHED_STATES, object.attachedStates.encode());
            destination.put(ATTR_PREDICATE_OPERATOR, object.predicateOperator.name());
            if (object.predicateFormula != null) {
                destination.put(ATTR_PREDICATE_FORMULA, object.predicateFormula);
            }
        }

        @Override
        protected void getChildren(CardLink object, MultiMap<String, Object> destination) {
            for (Predicate predicate : object.getPredicates()) {
                destination.putLast(FIELD_PREDICATES, predicate);
            }
        }
    }
}

