/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.layeredimage.LayeredImage;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.HoleGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LayeredImageGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LinkedGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.MotionKeyframesGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.PlayListGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.ShadowGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.SlideGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.SpriteSequenceGraphic;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.vecmath.Point3d;

public class SceneLocationLayer
extends ProjectComponent {
    public static final Icon MULTI_ICON = IconLoader.loadIcon("silk/photos.png");
    private final List<LocationLayerGraphic> graphics;
    private Reference<SceneLayer> sceneLayer;
    private float approachTransition = 0.5f;
    private Color hazeColor = Color.WHITE;
    private float hazeAmount = 0.0f;
    private boolean graphicsInitialized;

    public static String toLocationLayerID(String refMeshID) {
        String result = refMeshID;
        if (refMeshID.startsWith("REF")) {
            result = refMeshID.substring("REF".length());
        }
        return result;
    }

    public SceneLocationLayer(String id) {
        this(id, null);
    }

    public SceneLocationLayer(SceneLayer sceneLayer) {
        this(sceneLayer.getID(), sceneLayer);
    }

    @Override
    public Icon getIcon() {
        if (this.graphics.size() > 1) {
            return MULTI_ICON;
        }
        if (this.graphics.isEmpty()) {
            return LayeredImageGraphic.EMPTY_ICON;
        }
        return this.getDefaultGraphic().getIcon();
    }

    public SceneLayer getSceneLayer() {
        return this.sceneLayer.resolve();
    }

    public void setSceneLayer(SceneLayer sceneLayer) {
        this.sceneLayer = new Reference<SceneLayer>((ProjectComponent)this, sceneLayer);
        this.fireModified();
    }

    public float getApproachTransition() {
        return this.approachTransition;
    }

    public void setApproachTransition(float approachTransition) {
        this.approachTransition = approachTransition;
        this.fireModified();
    }

    public Color getHazeColor() {
        return this.hazeColor;
    }

    public Color getHazeBlendColor() {
        int hazeAlpha = (int)(this.hazeAmount * 255.0f);
        return new Color(this.hazeColor.getRed(), this.hazeColor.getGreen(), this.hazeColor.getBlue(), hazeAlpha);
    }

    public void setHazeColor(Color hazeColor) {
        assert (hazeColor != null) : "hazeColor is null";
        this.hazeColor = hazeColor;
        for (LocationLayerGraphic graphic : this.graphics) {
            graphic.clearCacheImage();
        }
        this.fireModified();
    }

    public float getHazeAmount() {
        return this.hazeAmount;
    }

    public void setHazeAmount(float hazeAmount) {
        this.hazeAmount = hazeAmount;
        for (LocationLayerGraphic graphic : this.graphics) {
            graphic.clearCacheImage();
        }
        this.fireModified();
    }

    public String getSceneLayerID() {
        SceneLayer sceneLayer = this.getSceneLayer();
        return sceneLayer == null ? null : sceneLayer.getID();
    }

    public Point3d getRefPoint() {
        SceneLayer sceneLayer = this.getSceneLayer();
        return sceneLayer == null ? new Point3d() : sceneLayer.getOffsetRefPoint();
    }

    public boolean isBackground() {
        SceneLayer sceneLayer = this.getSceneLayer();
        return sceneLayer == null ? true : sceneLayer.isBackground();
    }

    public LocationLayerGraphic getDefaultGraphic() {
        if (!this.graphicsInitialized) {
            this.updateImages();
            this.graphicsInitialized = true;
        }
        return CollectionUtils.first(this.graphics);
    }

    public List<LocationLayerGraphic> getGraphics() {
        return this.graphics;
    }

    public void addGraphic(LocationLayerGraphic graphic) {
        this.addGraphic(graphic, true);
    }

    public void moveGraphic(LocationLayerGraphic graphic, int newIndex) {
        if (this.graphics.contains(graphic)) {
            int oldIndex = this.graphics.indexOf(graphic);
            if (newIndex == oldIndex) {
                return;
            }
            this.removeGraphic(graphic, true);
            this.addGraphic(graphic, newIndex < oldIndex ? newIndex : newIndex - 1, true);
        }
    }

    public List<LocationLayerGraphic> getGraphicsForState(SceneLayer layer, SceneLayerState state, boolean useDefaultIfEmpty) {
        ArrayList<LocationLayerGraphic> result = new ArrayList<LocationLayerGraphic>();
        if (state != null) {
            for (LocationLayerGraphic graphic : this.graphics) {
                if (!graphic.getAttachedStates().contains(state)) continue;
                result.add(graphic);
            }
        }
        if (result.isEmpty()) {
            if (layer.getStates().isEmpty()) {
                result.addAll(this.graphics);
            } else if (useDefaultIfEmpty) {
                CollectionUtils.addIfNotNull(result, this.getDefaultGraphic());
            }
        }
        return result;
    }

    public boolean isEmpty() {
        return this.graphics.isEmpty() || this.getDefaultGraphic().isEmpty() && this.graphics.size() == 1;
    }

    public Rectangle4d getMarginsRegion() {
        return this.getParentComponent().getMarginsRegion();
    }

    @Override
    public SceneLocation getParentComponent() {
        return (SceneLocation)super.getParentComponent();
    }

    @Override
    public void addChildComponent(String id, Class<? extends ProjectComponent> type) {
        LocationLayerGraphic graphic;
        if (LocationLayerGraphic.class.isAssignableFrom(type) && (graphic = LocationLayerGraphic.newInstanceForID(id, type)) != null) {
            this.addGraphic(graphic, true);
        }
    }

    @Override
    public void addChildComponent(ProjectComponent child, int insertIndex) {
        if (child instanceof LocationLayerGraphic) {
            this.addGraphic((LocationLayerGraphic)child, insertIndex, true);
        }
    }

    @Override
    public void removeChildComponent(ProjectComponent child) {
        if (child instanceof LocationLayerGraphic) {
            this.removeGraphic((LocationLayerGraphic)child, true);
        }
    }

    @Override
    public String toString() {
        return this.getParentComponent().getDisplayName(false) + "." + this.getDisplayName(false);
    }

    protected void autoLoadImages(IOFileType type, File[] files) {
        LocationLayerGraphic defaultGraphic = this.getDefaultGraphic();
        if (defaultGraphic instanceof LayeredImageGraphic) {
            ((LayeredImageGraphic)defaultGraphic).autoLoadImages(type, this.getParentComponent().getFilenameFormat(type), files);
        }
    }

    protected void updateImages() {
        LocationLayerGraphic defaultGraphic = CollectionUtils.first(this.graphics);
        if (defaultGraphic instanceof LayeredImageGraphic) {
            ((LayeredImageGraphic)defaultGraphic).updateImages();
        }
        for (LayeredImageGraphic graphic : this.getDescendantsByType(LayeredImageGraphic.class, new ArrayList())) {
            graphic.updateImages();
        }
    }

    private SceneLocationLayer(String id, SceneLayer sceneLayer) {
        super(id);
        this.graphics = new ArrayList<LocationLayerGraphic>();
        this.sceneLayer = sceneLayer == null ? new Reference() : new Reference<SceneLayer>((ProjectComponent)this, sceneLayer);
        this.registerChildType(LayeredImageGraphic.class, LayeredImageGraphic.ICON, true);
        this.registerChildType(SpriteSequenceGraphic.class, SpriteSequenceGraphic.ICON, true);
        this.registerChildType(MotionKeyframesGraphic.class, MotionKeyframesGraphic.ICON, true);
        this.registerChildType(PlayListGraphic.class, PlayListGraphic.ICON, true);
        this.registerChildType(HoleGraphic.class, HoleGraphic.ICON, true);
        this.registerChildType(LinkedGraphic.class, LinkedGraphic.ICON, true);
        this.registerChildType(SlideGraphic.class, SlideGraphic.ICON, true);
        this.registerChildType(ShadowGraphic.class, ShadowGraphic.ICON, true);
        this.setChildComparator(new Comparator<ProjectComponent>(){

            @Override
            public int compare(ProjectComponent o1, ProjectComponent o2) {
                return Integer.valueOf(SceneLocationLayer.this.graphics.indexOf(o1)).compareTo(SceneLocationLayer.this.graphics.indexOf(o2));
            }
        });
    }

    private void addGraphic(LocationLayerGraphic graphic, boolean notify) {
        this.graphics.add(graphic);
        this.registerChild(graphic, notify);
    }

    private void addGraphic(LocationLayerGraphic graphic, int index, boolean notify) {
        if (index < 0 || index > this.graphics.size()) {
            this.graphics.add(graphic);
        } else {
            this.graphics.add(index, graphic);
        }
        this.registerChild(graphic, notify);
    }

    private void removeGraphic(LocationLayerGraphic graphic, boolean notify) {
        this.graphics.remove(graphic);
        this.removeChild(graphic, notify);
    }

    public static class Transcoder
    extends ProjectComponent.Transcoder<SceneLocationLayer> {
        private static final String ELEMENT_NAME = "LocationLayer";
        private static final String ATTR_SCENE_LAYER = "sceneLayer";
        private static final String ATTR_APPROACH_TRANSITION = "approachTransition";
        private static final String ATTR_HAZE_COLOR = "hazeColor";
        private static final String ATTR_HAZE_AMOUNT = "hazeAmount";
        private static final String FIELD_IMAGES = "layeredImages";
        private static final String FIELD_GRAPHICS = "graphics";

        public Transcoder() {
            super(ELEMENT_NAME, SceneLocationLayer.class);
            this.setFieldTranscoder(FIELD_IMAGES, new LayeredImage.Transcoder());
            this.setFieldTranscoder(FIELD_GRAPHICS, new SpriteSequenceGraphic.Transcoder(), new MotionKeyframesGraphic.Transcoder(), new LayeredImageGraphic.Transcoder(), new PlayListGraphic.Transcoder(), new HoleGraphic.Transcoder(), new LinkedGraphic.Transcoder(), new SlideGraphic.Transcoder(), new ShadowGraphic.Transcoder());
        }

        @Override
        protected SceneLocationLayer decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            List<Object> graphics = decodedChildren.getAll(FIELD_GRAPHICS);
            SceneLocationLayer result = new SceneLocationLayer(id, null);
            for (int i = 0; i < graphics.size(); ++i) {
                result.addGraphic((LocationLayerGraphic)graphics.get(i), false);
            }
            result.sceneLayer = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_SCENE_LAYER));
            if (attributes.containsKey(ATTR_APPROACH_TRANSITION)) {
                result.approachTransition = Float.valueOf(attributes.get(ATTR_APPROACH_TRANSITION)).floatValue();
            }
            if (attributes.containsKey(ATTR_HAZE_COLOR)) {
                result.hazeColor = ColorUtils.toColor(Integer.valueOf(attributes.get(ATTR_HAZE_COLOR)));
            }
            if (attributes.containsKey(ATTR_HAZE_AMOUNT)) {
                result.hazeAmount = Float.valueOf(attributes.get(ATTR_HAZE_AMOUNT)).floatValue();
            }
            return result;
        }

        @Override
        protected void getAttributes(SceneLocationLayer object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_SCENE_LAYER, object.sceneLayer.encode());
            destination.put(ATTR_APPROACH_TRANSITION, Float.toString(object.approachTransition));
            destination.put(ATTR_HAZE_COLOR, Integer.toString(ColorUtils.toIntARGB(object.hazeColor)));
            destination.put(ATTR_HAZE_AMOUNT, Float.toString(object.hazeAmount));
        }

        @Override
        protected void getChildren(SceneLocationLayer object, MultiMap<String, Object> destination) {
            for (LocationLayerGraphic graphic : object.graphics) {
                destination.putLast(FIELD_GRAPHICS, graphic);
            }
        }
    }
}

