/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerApp;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.ReferenceList;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.CardLink;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.LocationTransition;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LayeredImageGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundClip;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundSequence;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.AbstractViewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.InterpolatedViewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.SimpleViewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.StandardViewpoint;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.Viewpoint;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.xml.EnumMapTranscoder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class SceneLocation
extends ProjectComponent {
    public static final Icon LOCATION_ICON = IconLoader.loadIcon("silk/house.png");
    private AbstractViewpoint viewpoint;
    private final List<SceneLocationLayer> locationLayers = new ArrayList<SceneLocationLayer>();
    private Rectangle4d marginsRegion;
    private final EnumMap<IOFileType, String> filenameFormats = new EnumMap(IOFileType.class);
    private Reference<SceneLocation> backgroundLocation = new Reference();
    private Reference<SoundClip> ambientSound = new Reference();
    private ReferenceList<SceneLocation> showOtherLocations = new ReferenceList();
    private final List<LocationTransition> transition = new ArrayList<LocationTransition>();
    private final List<CardLink> cardLinks = new ArrayList<CardLink>();
    private final List<SoundClip> soundClips = new ArrayList<SoundClip>();
    private final List<SoundSequence> soundSequences = new ArrayList<SoundSequence>();

    public SceneLocation(String id) {
        super(id);
        this.registerChildType(StandardViewpoint.class, AbstractViewpoint.ICON, true);
        this.registerChildType(InterpolatedViewpoint.class, AbstractViewpoint.ICON, true);
        this.registerChildType(SceneLocationLayer.class, LayeredImageGraphic.EMPTY_ICON, true);
        this.registerChildType(LocationTransition.class, LocationTransition.ICON, true);
        this.registerChildType(CardLink.class, CardLink.ICON, true);
        this.registerChildType(SoundClip.class, SoundClip.ICON, true);
        this.registerChildType(SoundSequence.class, SoundSequence.ICON, true);
        this.setViewpoint(new StandardViewpoint("viewpoint"), false);
    }

    public final List<SceneLocationLayer> getLayers() {
        return Collections.unmodifiableList(this.locationLayers);
    }

    public final List<SceneLocationLayer> getLocationLayers(SceneLayer sceneLayer) {
        ArrayList<SceneLocationLayer> result = new ArrayList<SceneLocationLayer>();
        for (SceneLocationLayer layer : this.getLayers()) {
            if (!sceneLayer.equals(layer.getSceneLayer())) continue;
            result.add(layer);
        }
        return result;
    }

    public List<LocationTransition> getTransitions() {
        return this.transition;
    }

    public List<CardLink> getCardLinks() {
        return this.cardLinks;
    }

    public List<SoundClip> getSoundClips() {
        return this.soundClips;
    }

    public List<SoundSequence> getSoundSequences() {
        return this.soundSequences;
    }

    public Viewpoint getViewpoint() {
        if (this.viewpoint == null) {
            return SimpleViewpoint.DEFAULT_VIEWPOINT;
        }
        return this.viewpoint;
    }

    public void setViewpoint(AbstractViewpoint viewpoint) {
        this.setViewpoint(viewpoint, true);
    }

    public void setAmbientSound(SoundClip clip) {
        this.ambientSound = new Reference<SoundClip>((ProjectComponent)this, clip);
        this.fireModified();
    }

    public SoundClip getAmbientSound() {
        SoundClip localSound = this.ambientSound.resolve();
        if (localSound != null) {
            return localSound;
        }
        return this.getParentComponent().getAmbientSound();
    }

    public void setBackgroundLocation(SceneLocation backgroundLocation) {
        this.backgroundLocation = new Reference<SceneLocation>((ProjectComponent)this, backgroundLocation);
        this.fireModified();
    }

    public SceneLocation getBackgroundLocation() {
        return this.backgroundLocation.resolve();
    }

    public List<SceneLocation> getShowOtherLocations() {
        return this.showOtherLocations.resolve();
    }

    public void addShowOtherLocation(SceneLocation state) {
        this.showOtherLocations.resolve().add(state);
        this.fireModified();
    }

    public void clearShowOtherLocations() {
        this.showOtherLocations.resolve().clear();
        this.fireModified();
    }

    public void removeShowOtherLocation(SceneLocation state) {
        this.showOtherLocations.resolve().remove(state);
        this.fireModified();
    }

    public Transform3D getBackgroundCoordTransform() {
        if (this.backgroundLocation.resolve() == null) {
            return null;
        }
        Camera result = this.backgroundLocation.resolve().getCamera();
        Transform3D alignmentTransform = new Transform3D(this.getCamera().getCumulativeTransform());
        alignmentTransform.mul(result.getInverseTransform());
        return alignmentTransform;
    }

    public final Map<IOFileType, String> getFilenameFormats() {
        return this.filenameFormats;
    }

    public final String getFilenameFormat(IOFileType fileType) {
        String result = this.filenameFormats.get((Object)fileType);
        return result == null ? fileType.getDefaultFilenamePattern() : this.filenameFormats.get((Object)fileType);
    }

    public Camera getCamera() {
        return this.viewpoint == null ? new Camera(this.getID()) : this.viewpoint.getCamera();
    }

    public Rectangle4d getViewport(boolean includeMargins) {
        Rectangle4d baseViewport = this.viewpoint == null ? PatchworkComposerApp.BLENDER_VIEWPORT : this.viewpoint.getViewport();
        return includeMargins ? baseViewport.fromProportional(this.getMarginsRegion()) : baseViewport;
    }

    public Rectangle4d getViewportProportional(boolean includeMargins) {
        Rectangle4d baseViewport = this.getViewport(includeMargins);
        return PatchworkComposerApp.BLENDER_VIEWPORT.toProportional(baseViewport);
    }

    public void setMarginsRegion(Rectangle4d marginsRegion) {
        this.marginsRegion = marginsRegion;
        for (SceneLocationLayer layer : this.getLayers()) {
            layer.updateImages();
        }
        this.fireModified(this.getPath());
    }

    public Rectangle4d getMarginsRegion() {
        SceneLocation fromLocation;
        if (this.marginsRegion != null) {
            return this.marginsRegion;
        }
        Viewpoint viewpoint = this.getViewpoint();
        if (viewpoint instanceof InterpolatedViewpoint && (fromLocation = ((InterpolatedViewpoint)viewpoint).getFromLocation()) != null) {
            return fromLocation.getMarginsRegion();
        }
        return new Rectangle4d(0.0, 0.0, 1.0, 1.0);
    }

    public final void autoLoadImages() {
        for (IOFileType type : IOFileType.values()) {
            if (!type.isImageType()) continue;
            this.autoLoadImages(type);
        }
    }

    public void updateFromScene() {
        for (SceneLayer sceneLayer : this.getParentComponent().getSceneLayers()) {
            if (!this.getLocationLayers(sceneLayer).isEmpty()) continue;
            this.addLocationLayer(new SceneLocationLayer(sceneLayer), true);
        }
        if (this.viewpoint instanceof StandardViewpoint) {
            ((StandardViewpoint)this.viewpoint).updateFromSceneGraph();
        }
    }

    @Override
    public Scene getParentComponent() {
        return (Scene)super.getParentComponent();
    }

    @Override
    public void addChildComponent(String id, Class<? extends ProjectComponent> type) {
        if (type.equals(StandardViewpoint.class)) {
            this.setViewpoint(new StandardViewpoint(id), true);
        } else if (type.equals(InterpolatedViewpoint.class)) {
            this.setViewpoint(new InterpolatedViewpoint(id), true);
        } else if (type.equals(LocationTransition.class)) {
            this.addTransition(new LocationTransition(id), true);
        } else if (type.equals(CardLink.class)) {
            this.addCardLink(new CardLink(id), true);
        } else if (type.equals(SoundClip.class)) {
            this.addSoundClip(new SoundClip(id), true);
        } else if (type.equals(SoundSequence.class)) {
            this.addSoundSequence(new SoundSequence(id), true);
        } else if (type.equals(SceneLocationLayer.class)) {
            this.addLocationLayer(new SceneLocationLayer(id), true);
        }
    }

    @Override
    public void addChildComponent(ProjectComponent child, int insertIndex) {
        if (child instanceof SoundClip) {
            this.addSoundClip((SoundClip)child, true);
        } else if (child instanceof SoundSequence) {
            this.addSoundSequence((SoundSequence)child, true);
        } else if (child instanceof SceneLocationLayer) {
            this.addLocationLayer((SceneLocationLayer)child, true);
        }
    }

    @Override
    public void removeChildComponent(ProjectComponent child) {
        if (child.getClass().equals(StandardViewpoint.class) || child.getClass().equals(InterpolatedViewpoint.class)) {
            this.setViewpoint(null, true);
        } else if (child instanceof LocationTransition) {
            this.removeTransition((LocationTransition)child, true);
        } else if (child instanceof CardLink) {
            this.removeCardLink((CardLink)child, true);
        } else if (child instanceof SoundClip) {
            this.removeSoundClip((SoundClip)child, true);
        } else if (child instanceof SoundSequence) {
            this.removeSoundSequence((SoundSequence)child, true);
        } else if (child instanceof SceneLocationLayer) {
            this.removeLocationLayer((SceneLocationLayer)child, true);
        }
    }

    @Override
    public final Icon getIcon() {
        return LOCATION_ICON;
    }

    private final void addLocationLayer(SceneLocationLayer layer, boolean notify) {
        this.locationLayers.add(layer);
        this.registerChild(layer, notify);
    }

    private final void removeLocationLayer(SceneLocationLayer layer, boolean notify) {
        this.locationLayers.remove(layer);
        this.removeChild(layer, notify);
    }

    private void addTransition(LocationTransition hotspot, boolean notify) {
        this.transition.add(hotspot);
        this.registerChild(hotspot, notify);
    }

    private void removeTransition(LocationTransition hotspot, boolean notify) {
        this.transition.remove(hotspot);
        this.removeChild(hotspot, notify);
    }

    private void addCardLink(CardLink cardLink, boolean notify) {
        this.cardLinks.add(cardLink);
        this.registerChild(cardLink, notify);
    }

    private void removeCardLink(CardLink cardLink, boolean notify) {
        this.cardLinks.remove(cardLink);
        this.removeChild(cardLink, notify);
    }

    private void addSoundClip(SoundClip clip, boolean notify) {
        this.soundClips.add(clip);
        this.registerChild(clip, notify);
    }

    private void removeSoundClip(SoundClip clip, boolean notify) {
        this.soundClips.remove(clip);
        this.removeChild(clip, notify);
    }

    private void addSoundSequence(SoundSequence sequence, boolean notify) {
        this.soundSequences.add(sequence);
        this.registerChild(sequence, notify);
    }

    private void removeSoundSequence(SoundSequence sequence, boolean notify) {
        this.soundSequences.remove(sequence);
        this.removeChild(sequence, notify);
    }

    private void autoLoadImages(IOFileType type) {
        File directory = this.getIODirectory(type);
        File[] files = directory.listFiles();
        for (SceneLocationLayer layer : this.getLayers()) {
            layer.autoLoadImages(type, files);
        }
    }

    private void setViewpoint(AbstractViewpoint viewpoint, boolean notify) {
        if (this.viewpoint != null) {
            this.removeChild(this.viewpoint, notify);
        }
        this.viewpoint = viewpoint;
        if (this.viewpoint != null) {
            this.registerChild(viewpoint, true);
        }
    }

    public static class Transcoder
    extends ProjectComponent.Transcoder<SceneLocation> {
        private static final String ELEMENT_NAME = "SceneLocation";
        private static final String ATTR_BG_LOCATION = "backgroundLocation";
        private static final String ATTR_OTHER_LOCATIONS = "otherLocations";
        private static final String FIELD_LOCATION_LAYERS = "sceneLocationLayers";
        private static final String FIELD_TRANSITIONS = "transitions";
        private static final String FIELD_CARD_LINKS = "cardLinks";
        private static final String FIELD_SOUND_CLIPS = "soundClips";
        private static final String FIELD_SOUND_SEQUENCES = "soundSequences";
        private static final String FIELD_VIEWPOINT = "viewpoint";
        private static final String FIELD_FILENAME_FORMATS = "filenameFormats";
        private static final String ATTR_MARGINS_REGION = "marginsRegion";
        private static final String ATTR_AMBIENT_SOUND = "ambientSound";

        public Transcoder() {
            super(ELEMENT_NAME, SceneLocation.class);
            this.setFieldTranscoder(FIELD_LOCATION_LAYERS, new SceneLocationLayer.Transcoder());
            this.setFieldTranscoder(FIELD_TRANSITIONS, new LocationTransition.Transcoder());
            this.setFieldTranscoder(FIELD_CARD_LINKS, new CardLink.Transcoder());
            this.setFieldTranscoder(FIELD_SOUND_CLIPS, new SoundClip.Transcoder());
            this.setFieldTranscoder(FIELD_SOUND_SEQUENCES, new SoundSequence.Transcoder());
            this.setFieldTranscoder(FIELD_VIEWPOINT, new StandardViewpoint.Transcoder(), new InterpolatedViewpoint.Transcoder());
            this.setFieldTranscoder(FIELD_FILENAME_FORMATS, new EnumMapTranscoder<IOFileType>(IOFileType.class){

                @Override
                protected IOFileType toEnumVal(String name) {
                    return IOFileType.valueOf(name);
                }
            });
        }

        @Override
        protected void getAttributes(SceneLocation object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_BG_LOCATION, object.backgroundLocation.encode());
            destination.put(ATTR_OTHER_LOCATIONS, object.showOtherLocations.encode());
            if (object.marginsRegion != null) {
                destination.put(ATTR_MARGINS_REGION, object.marginsRegion.encode());
            }
            destination.put(ATTR_AMBIENT_SOUND, object.ambientSound.encode());
        }

        @Override
        protected final void getChildren(SceneLocation object, MultiMap<String, Object> destination) {
            for (SceneLocationLayer layer : object.getLayers()) {
                destination.putLast(FIELD_LOCATION_LAYERS, layer);
            }
            for (LocationTransition transition : object.getTransitions()) {
                destination.putLast(FIELD_TRANSITIONS, transition);
            }
            for (CardLink cardLink : object.getCardLinks()) {
                destination.putLast(FIELD_CARD_LINKS, cardLink);
            }
            for (SoundClip clip : object.getSoundClips()) {
                destination.putLast(FIELD_SOUND_CLIPS, clip);
            }
            for (SoundSequence sequence : object.getSoundSequences()) {
                destination.putLast(FIELD_SOUND_SEQUENCES, sequence);
            }
            if (object.getViewpoint() != null) {
                destination.putLast(FIELD_VIEWPOINT, object.getViewpoint());
            }
            destination.putLast(FIELD_FILENAME_FORMATS, object.getFilenameFormats());
        }

        @Override
        protected SceneLocation decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            EnumMap formats;
            SceneLocation decoded = new SceneLocation(id);
            for (Object locationLayer : decodedChildren.getAll(FIELD_LOCATION_LAYERS)) {
                decoded.addLocationLayer((SceneLocationLayer)locationLayer, false);
            }
            for (Object transition : decodedChildren.getAll(FIELD_TRANSITIONS)) {
                decoded.addTransition((LocationTransition)transition, false);
            }
            for (Object cardLink : decodedChildren.getAll(FIELD_CARD_LINKS)) {
                decoded.addCardLink((CardLink)cardLink, false);
            }
            for (Object soundClip : decodedChildren.getAll(FIELD_SOUND_CLIPS)) {
                decoded.addSoundClip((SoundClip)soundClip, false);
            }
            for (Object soundSequence : decodedChildren.getAll(FIELD_SOUND_SEQUENCES)) {
                decoded.addSoundSequence((SoundSequence)soundSequence, false);
            }
            Object viewpoint = decodedChildren.getFirst(FIELD_VIEWPOINT);
            if (viewpoint instanceof AbstractViewpoint) {
                decoded.setViewpoint((AbstractViewpoint)viewpoint, false);
            }
            if ((formats = (EnumMap)decodedChildren.getFirst(FIELD_FILENAME_FORMATS)) != null) {
                decoded.getFilenameFormats().putAll(formats);
            }
            decoded.ambientSound = new Reference<String>((ProjectComponent)decoded, attributes.get(ATTR_AMBIENT_SOUND));
            decoded.backgroundLocation = new Reference<String>((ProjectComponent)decoded, attributes.get(ATTR_BG_LOCATION));
            decoded.showOtherLocations = new ReferenceList(decoded, attributes.get(ATTR_OTHER_LOCATIONS));
            if (attributes.containsKey(ATTR_MARGINS_REGION)) {
                decoded.marginsRegion = new Rectangle4d(attributes.get(ATTR_MARGINS_REGION));
            }
            return decoded;
        }
    }
}

