/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.StateTransition;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraph;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Collection.MultiHashMap;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.VectorUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class SceneLayer
extends ProjectComponent {
    public static final Icon ICON = IconLoader.loadIcon("silk/bullet_picture.png");
    public static final Icon LOGICAL_ICON = IconLoader.loadIcon("silk/cog.png");
    private String refMeshID;
    private final Point3d refPoint = new Point3d();
    private final Vector3d offset;
    private boolean isBackground;
    private final List<SceneLayerState> states;
    private Reference<SceneLayerState> initialState;

    public static String toSceneLayerID(String refMeshID) {
        if (refMeshID.startsWith("REF")) {
            return refMeshID.substring("REF".length());
        }
        return refMeshID;
    }

    public SceneLayer(String id) {
        super(id);
        if (this.refPoint != null) {
            this.refPoint.set(this.refPoint);
        }
        this.states = new ArrayList<SceneLayerState>();
        this.initialState = new Reference();
        this.offset = new Vector3d();
        this.registerChildType(SceneLayerState.class, SceneLayerState.ICON, true);
    }

    public boolean isBackground() {
        return this.isBackground;
    }

    public void setIsBackground(boolean isBackground) {
        this.isBackground = isBackground;
        this.fireModified();
    }

    public Point3d getRefPoint() {
        return new Point3d(this.refPoint);
    }

    public Point3d getOffsetRefPoint() {
        Point3d result = new Point3d(this.refPoint);
        result.add(this.offset);
        return result;
    }

    public void setRefPoint(Point3d point) {
        this.refPoint.set(point);
        this.fireModified();
    }

    public Vector3d getOffset() {
        return this.offset;
    }

    public void setOffset(Vector3d offset) {
        this.offset.set(offset);
        this.fireModified();
    }

    public String getRefMeshID() {
        return this.refMeshID;
    }

    public void setRefMeshID(String refMeshID) {
        this.refMeshID = refMeshID;
        this.updateFromSceneGraph();
        this.fireModified();
    }

    public List<SceneLayerState> getStates(boolean topologicalOrder) {
        if (topologicalOrder) {
            ArrayList<SceneLayerState> result = new ArrayList<SceneLayerState>();
            HashSet<SceneLayerState> sinks = new HashSet<SceneLayerState>();
            MultiHashMap<SceneLayerState, SceneLayerState> reverseTransitions = new MultiHashMap<SceneLayerState, SceneLayerState>();
            for (SceneLayerState state : this.states) {
                if (!state.hasForwardTransitions()) {
                    sinks.add(state);
                }
                for (StateTransition stateTransition : state.getTransitions()) {
                    reverseTransitions.putLast(stateTransition.getDestinationState(), state);
                }
            }
            HashSet<SceneLayerState> visited = new HashSet<SceneLayerState>();
            for (SceneLayerState state : sinks) {
                this.addWithAllPrecedingStates(state, result, reverseTransitions, visited);
            }
            for (SceneLayerState state : this.states) {
                if (visited.contains(state)) continue;
                this.addWithAllPrecedingStates(state, result, reverseTransitions, visited);
            }
            return result;
        }
        return this.states;
    }

    public List<SceneLayerState> getStates() {
        return this.getStates(false);
    }

    public void addState(SceneLayerState stateFlag) {
        this.addState(stateFlag, true);
    }

    public void removeState(SceneLayerState stateFlag) {
        this.removeState(stateFlag, true);
    }

    public SceneLayerState getInitialState() {
        SceneLayerState result = this.initialState.resolve();
        if (result == null) {
            result = CollectionUtils.first(this.getStates());
        }
        return result;
    }

    public void setInitialState(SceneLayerState initialState) {
        this.initialState = new Reference<SceneLayerState>((ProjectComponent)this, initialState);
        this.fireModified();
    }

    public final void updateFromSceneGraph() {
        SceneGraph sceneGraph = this.getParentComponent().getSceneGraph();
        if (sceneGraph == null) {
            return;
        }
        PolyMesh3D refMesh = sceneGraph.getMeshInGlobalCoords(this.refMeshID);
        if (refMesh != null) {
            Point3d refPoint = refMesh.getBoundingBox().getCenterPoint();
            this.setRefPoint(refPoint);
        }
    }

    @Override
    public Icon getIcon() {
        return this.refMeshID == null ? LOGICAL_ICON : ICON;
    }

    @Override
    public Scene getParentComponent() {
        return (Scene)super.getParentComponent();
    }

    @Override
    public void addChildComponent(String id, Class<? extends ProjectComponent> type) {
        if (type.equals(SceneLayerState.class)) {
            this.addState(new SceneLayerState(id), true);
        }
    }

    @Override
    public void addChildComponent(ProjectComponent child, int insertIndex) {
        if (child instanceof SceneLayerState) {
            this.addState((SceneLayerState)child, insertIndex, true);
        }
    }

    @Override
    public void removeChildComponent(ProjectComponent child) {
        if (child instanceof SceneLayerState) {
            this.removeState((SceneLayerState)child, true);
        }
    }

    private void addWithAllPrecedingStates(SceneLayerState state, List<SceneLayerState> result, MultiMap<SceneLayerState, SceneLayerState> reverseTransitions, Set<SceneLayerState> visited) {
        if (visited.contains(state) || result.contains(state)) {
            return;
        }
        visited.add(state);
        for (SceneLayerState precedingState : reverseTransitions.getAll(state)) {
            this.addWithAllPrecedingStates(precedingState, result, reverseTransitions, visited);
        }
        result.add(state);
    }

    private void addState(SceneLayerState stateFlag, boolean notify) {
        this.states.add(stateFlag);
        this.registerChild(stateFlag, notify);
    }

    private void addState(SceneLayerState state, int index, boolean notify) {
        if (index >= this.states.size()) {
            this.states.add(state);
        } else {
            this.states.add(index, state);
        }
        this.registerChild(state, notify);
    }

    private void removeState(SceneLayerState stateFlag, boolean notify) {
        this.states.remove(stateFlag);
        this.removeChild(stateFlag, notify);
    }

    public static class Transcoder
    extends ProjectComponent.Transcoder<SceneLayer> {
        private static final String ELEMENT_NAME = "SceneLayer";
        private static final String ATTR_IS_BACKGROUND = "isBackground";
        private static final String ATTR_REF_POINT = "refPoint";
        private static final String ATTR_OFFSET = "offset";
        private static final String ATTR_REF_MESH_ID = "refMeshID";
        private static final String ATTR_INITIAL_STATE = "initialState";
        private static final String FIELD_STATES = "states";

        public Transcoder() {
            super(ELEMENT_NAME, SceneLayer.class);
            this.setFieldTranscoder(FIELD_STATES, new SceneLayerState.Transcoder());
        }

        @Override
        protected SceneLayer decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            SceneLayer result = new SceneLayer(id);
            if (attributes.containsKey(ATTR_IS_BACKGROUND)) {
                result.isBackground = Boolean.valueOf(attributes.get(ATTR_IS_BACKGROUND));
            }
            if (attributes.containsKey(ATTR_REF_POINT)) {
                Point3d refPoint = VectorUtils.decodePoint3d(attributes.get(ATTR_REF_POINT));
                result.refPoint.set(refPoint);
            }
            String offsetStr = attributes.get(ATTR_OFFSET);
            result.offset.set(offsetStr == null ? new Vector3d() : VectorUtils.decodeVector3d(offsetStr));
            if (attributes.containsKey(ATTR_REF_MESH_ID)) {
                result.refMeshID = attributes.get(ATTR_REF_MESH_ID);
            }
            for (Object stateFlag : decodedChildren.getAll(FIELD_STATES)) {
                result.addState((SceneLayerState)stateFlag, false);
            }
            result.initialState = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_INITIAL_STATE));
            return result;
        }

        @Override
        protected void getAttributes(SceneLayer object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_IS_BACKGROUND, Boolean.toString(object.isBackground));
            destination.put(ATTR_REF_POINT, VectorUtils.toString(object.refPoint));
            destination.put(ATTR_OFFSET, VectorUtils.toString(object.offset));
            if (object.refMeshID != null) {
                destination.put(ATTR_REF_MESH_ID, object.refMeshID);
            }
            destination.put(ATTR_INITIAL_STATE, object.initialState.encode());
        }

        @Override
        protected void getChildren(SceneLayer object, MultiMap<String, Object> destination) {
            for (SceneLayerState stateFlag : object.getStates()) {
                destination.putLast(FIELD_STATES, stateFlag);
            }
        }
    }
}

