/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model;

import com.sodiumarc.patchwork.app.common.ProgressObserver;
import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerProperties;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundClip;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundSequence;
import com.sodiumarc.patchwork.app.scenecomposer.resource.ResourceManager;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PatchworkProject
extends ProjectComponent {
    public static final String PROJECT_FILE_EXTENSION = ".project.xml";
    public static final String CREDITS_FILE_EXTENSION = ".credits.txt";
    public static final String DEFAULT_CREDITS_FILENAME = "credits.txt";
    public static final Icon PROJECT_ICON = IconLoader.loadIcon("silk/book.png");
    public static final Color GRID_BG_COLOR = new Color(242, 242, 240);
    public static int CARD_SIZE = PatchworkComposerProperties.CARD_SIZE.getInt();
    public static Dimension CARD_DIMENSION = new Dimension(CARD_SIZE, CARD_SIZE);
    public static Rectangle4d CARD_RECT = new Rectangle4d(0.0, 0.0, CARD_SIZE, CARD_SIZE);
    private final List<Card> cards = new ArrayList<Card>();
    private Reference<Card> startingCard = new Reference();
    private Reference<SceneLayerState> prologueEndState = new Reference();
    private Reference<SceneLayerState> epilogueBeginState = new Reference();
    private Reference<SoundSequence> openingScore;
    private String titleImageFilename;
    private File saveFile;
    private boolean isPublished = false;
    private String creditsString;
    private static final Logger LOGGER = Logger.getLogger(PatchworkProject.class);

    public static boolean isValidName(String name) {
        Pattern pattern = Pattern.compile("[a-zA-Z0-9 \\.\\_]*");
        return pattern.matcher(name).matches() && name.trim().equals(name);
    }

    public static PatchworkProject loadFromFile(File file) throws IOException, ParserConfigurationException, SAXException {
        Document document = XMLUtils.getXMLDocument(file, false);
        PatchworkProject project = (PatchworkProject)new XMLTranscoder().decode(document.getDocumentElement());
        project.setSaveFile(file);
        return project;
    }

    public static PatchworkProject loadFromStream(InputStream stream) throws IOException, ParserConfigurationException, SAXException {
        Document document = XMLUtils.getXMLDocument(stream, false);
        PatchworkProject project = (PatchworkProject)new XMLTranscoder().decode(document.getDocumentElement());
        return project;
    }

    public static List<PatchworkProject> loadAllProjects(File directory) {
        File[] projectFiles;
        ArrayList<PatchworkProject> result = new ArrayList<PatchworkProject>();
        for (File file : projectFiles = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(PatchworkProject.PROJECT_FILE_EXTENSION);
            }
        })) {
            try {
                result.add(PatchworkProject.loadFromFile(file));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public PatchworkProject(String id) {
        super(id);
        this.registerChildType(Card.class, Card.ICON, true);
    }

    public void publish(ProgressObserver listener) {
        boolean modified;
        Collection<LocationLayerGraphic> graphics = this.getDescendantsByType(LocationLayerGraphic.class);
        Collection<SoundClip> soundClips = this.getDescendantsByType(SoundClip.class);
        int completed = 0;
        int total = graphics.size() + soundClips.size() + 2;
        listener.setProgress(0, total, null);
        this.save(ResourceManager.getPublishDir());
        this.saveCredits(ResourceManager.getPublishDir());
        listener.setProgress(++completed, total, this.getID());
        BufferedImage titleImage = this.getTitleImage();
        if (titleImage != null) {
            try {
                ResourceManager.publishImageResource(titleImage, this.getGUID() + "_title");
            }
            catch (IOException e) {
                LOGGER.warn("Failed to publish " + this.getID() + ": " + e.getMessage());
            }
        }
        listener.setProgress(++completed, total, this.getID());
        for (LocationLayerGraphic graphic : graphics) {
            if (listener.hasBeenCancelled()) {
                return;
            }
            modified = graphic.publish();
            if (modified && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Published update: " + graphic);
            }
            listener.setProgress(++completed, total, graphic.getID());
        }
        for (SoundClip soundClip : soundClips) {
            if (listener.hasBeenCancelled()) {
                return;
            }
            modified = soundClip.publish();
            if (modified && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Published update: " + soundClip);
            }
            listener.setProgress(++completed, total, soundClip.getID());
        }
    }

    public boolean isPublished() {
        return this.isPublished;
    }

    public void preload(ProgressObserver listener) {
        Collection<LocationLayerGraphic> graphics = this.getDescendantsByType(LocationLayerGraphic.class);
        Collection<SoundClip> soundClips = this.getDescendantsByType(SoundClip.class);
        this.getCreditsString();
        int completed = 0;
        int total = graphics.size() + soundClips.size();
        listener.setProgress(0, total, null);
        for (LocationLayerGraphic graphic : graphics) {
            if (listener.hasBeenCancelled()) {
                return;
            }
            graphic.preload();
            listener.setProgress(++completed, total, graphic.getID());
        }
        for (SoundClip soundClip : soundClips) {
            if (listener.hasBeenCancelled()) {
                return;
            }
            soundClip.preload();
            listener.setProgress(++completed, total, soundClip.getID());
        }
    }

    public void setPublished(boolean isPublished) {
        this.isPublished = isPublished;
    }

    public String getCreditsString() {
        if (this.creditsString == null) {
            String filename = DEFAULT_CREDITS_FILENAME;
            if (this.isPublished) {
                this.creditsString = this.loadCredits(ResourceManager.getInputStream(filename));
            } else {
                File creditsFile = new File(PatchworkComposerProperties.PROJECT_DIR.getFile(), filename);
                if (creditsFile.exists()) {
                    try {
                        this.creditsString = this.loadCredits(new FileInputStream(creditsFile));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.creditsString;
    }

    public List<Card> getCards() {
        return this.cards;
    }

    public void addCard(Card card) {
        this.addCard(card, true);
    }

    public void removeCard(Card card) {
        this.removeCard(card, true);
    }

    public Card getStartingCard() {
        return this.startingCard.resolve();
    }

    public void setStartingCard(Card startingCard) {
        this.startingCard = new Reference<Card>((ProjectComponent)this, startingCard);
        this.fireModified();
    }

    public SceneLayerState getPrologueEndState() {
        return this.prologueEndState.resolve();
    }

    public void setPrologueEndState(SceneLayerState prologueEndState) {
        this.prologueEndState = new Reference<SceneLayerState>((ProjectComponent)this, prologueEndState);
        this.fireModified();
    }

    public SceneLayerState getEpilogueBeginState() {
        return this.epilogueBeginState.resolve();
    }

    public void setEpilogueBeginState(SceneLayerState epilogueBeginState) {
        this.epilogueBeginState = new Reference<SceneLayerState>((ProjectComponent)this, epilogueBeginState);
        this.fireModified();
    }

    public SoundSequence getOpeningScore() {
        return this.openingScore.resolve();
    }

    public void setOpeningScore(SoundSequence openingScore) {
        this.openingScore = new Reference<SoundSequence>((ProjectComponent)this, openingScore);
        this.fireModified();
    }

    public String getTitleImageFilename() {
        return this.titleImageFilename;
    }

    public BufferedImage getTitleImage() {
        return this.getImage(this.titleImageFilename);
    }

    public void setTitleImageFilename(String titleImageFilename) {
        this.titleImageFilename = titleImageFilename;
        this.fireModified();
    }

    public void save(File directory) {
        Document doc;
        File oldDirectory;
        assert (directory != null) : "directory is null";
        File file = new File(directory, this.getID() + PROJECT_FILE_EXTENSION);
        if (this.saveFile != null && (oldDirectory = this.saveFile.getParentFile()).equals(directory)) {
            this.saveFile.renameTo(file);
        }
        try {
            doc = XMLUtils.newXMLDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return;
        }
        Comment comment = doc.createComment("Just a thought");
        doc.appendChild(comment);
        doc.appendChild(new XMLTranscoder().encode(doc, this));
        try {
            XMLUtils.writeXMLDocument(doc, file);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.saveFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCredits(File directory) {
        String creditsString = this.getCreditsString();
        if (creditsString != null) {
            File file = new File(directory, DEFAULT_CREDITS_FILENAME);
            Writer out = null;
            try {
                out = new OutputStreamWriter(new FileOutputStream(file));
                out.write(creditsString);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public void deleteFile() {
        if (this.saveFile != null) {
            this.saveFile.delete();
        }
        this.saveFile = null;
    }

    public void updateImages() {
        for (SceneLocationLayer layer : this.getDescendantsByType(SceneLocationLayer.class, new ArrayList())) {
            layer.updateImages();
        }
    }

    @Override
    public Icon getIcon() {
        return PROJECT_ICON;
    }

    @Override
    public File getIODirectory(IOFileType key) {
        return key.getDefaultInputDir();
    }

    @Override
    public void addChildComponent(String id, Class<? extends ProjectComponent> type) {
        if (type.equals(Card.class)) {
            this.addCard(new Card(id));
        }
    }

    @Override
    public void removeChildComponent(ProjectComponent child) {
        if (child instanceof Card) {
            this.removeCard((Card)child);
        }
    }

    private void addCard(Card card, boolean notify) {
        this.cards.add(card);
        this.registerChild(card, notify);
    }

    private void removeCard(Card card, boolean notify) {
        this.cards.remove(card);
        this.removeChild(card, notify);
    }

    private void setSaveFile(File saveFile) {
        this.saveFile = saveFile;
    }

    private BufferedImage getImage(String filename) {
        BufferedImage result = null;
        if (filename != null) {
            if (this.isPublished()) {
                result = ResourceManager.getImageResourceByID(this.getGUID() + "_title");
            } else {
                try {
                    result = ImageIO.read(new File(this.getIODirectory(IOFileType.LAYER_SCANS), filename));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (result != null) {
            result = ImageUtils.scale(result, CARD_SIZE, CARD_SIZE);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadCredits(InputStream inputSream) {
        String result = null;
        StringBuilder text = new StringBuilder();
        Scanner scanner = null;
        String NL = System.getProperty("line.separator");
        try {
            scanner = new Scanner(inputSream);
            while (scanner.hasNextLine()) {
                text.append(scanner.nextLine() + NL);
            }
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        result = text.toString();
        return result;
    }

    public static class XMLTranscoder
    extends ProjectComponent.Transcoder<PatchworkProject> {
        private static final String ELEMENT_NAME = "project";
        private static final String FIELD_CARDS = "cards";
        private static final String ATTR_STARTING_CARD = "staringCard";
        private static final String ATTR_PROLOGUE_END_STATE = "prologueEndState";
        private static final String ATTR_EPILOGUE_BEGIN_STATE = "epilogueBeginState";
        private static final String ATTR_OPENING_SCORE = "openingScore";
        private static final String ATTR_TITLE_FILENAME = "titleImageFilename";

        public XMLTranscoder() {
            super(ELEMENT_NAME, PatchworkProject.class);
            this.setFieldTranscoder(FIELD_CARDS, new Card.Transcoder());
        }

        @Override
        protected PatchworkProject decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            PatchworkProject result = new PatchworkProject(id);
            for (Object card : decodedChildren.getAll(FIELD_CARDS)) {
                result.addCard((Card)card, false);
            }
            result.startingCard = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_STARTING_CARD));
            result.prologueEndState = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_PROLOGUE_END_STATE));
            result.epilogueBeginState = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_EPILOGUE_BEGIN_STATE));
            result.openingScore = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_OPENING_SCORE));
            result.titleImageFilename = attributes.get(ATTR_TITLE_FILENAME);
            return result;
        }

        @Override
        protected void getAttributes(PatchworkProject object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_STARTING_CARD, object.startingCard.encode());
            destination.put(ATTR_PROLOGUE_END_STATE, object.prologueEndState.encode());
            destination.put(ATTR_EPILOGUE_BEGIN_STATE, object.epilogueBeginState.encode());
            destination.put(ATTR_OPENING_SCORE, object.openingScore.encode());
            destination.put(ATTR_TITLE_FILENAME, object.titleImageFilename);
        }

        @Override
        protected void getChildren(PatchworkProject object, MultiMap<String, Object> destination) {
            for (Card card : object.getCards()) {
                destination.putLast(FIELD_CARDS, card);
            }
        }
    }
}

