/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model;

import com.sodiumarc.patchwork.render.control.KnownImageFilter;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.xml.PropertiesTranscoder;
import com.sodiumarc.patchwork.util.xml.SimpleTranscoder;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Properties;

public class ConfiguredImageFilter {
    private final KnownImageFilter filter;
    private Properties properties;

    public ConfiguredImageFilter(KnownImageFilter filter) {
        this.filter = filter;
        this.properties = new Properties();
    }

    public final void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public final void clearProperties() {
        this.properties.clear();
    }

    public final BufferedImage apply(BufferedImage input) {
        return this.filter.getInstance().apply(input, this.properties);
    }

    public static class Transcoder
    extends SimpleTranscoder<ConfiguredImageFilter> {
        private static final String ELEMENT_NAME = "ConfiguredImageFilter";
        private static final String ATTR_FILTER_NAME = "filter";
        private static final String FIELD_PROPERTIES_LIST = "propertiesList";

        public Transcoder() {
            super(ELEMENT_NAME, ConfiguredImageFilter.class);
            this.setFieldTranscoder(FIELD_PROPERTIES_LIST, new PropertiesTranscoder());
        }

        @Override
        protected ConfiguredImageFilter decode(Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            KnownImageFilter filterType = KnownImageFilter.valueOf(attributes.get(ATTR_FILTER_NAME));
            ConfiguredImageFilter result = new ConfiguredImageFilter(filterType);
            Properties properties = (Properties)decodedChildren.getFirst(FIELD_PROPERTIES_LIST);
            if (properties != null) {
                result.properties = properties;
            }
            return result;
        }

        @Override
        protected void getAttributes(ConfiguredImageFilter object, Map<String, String> destination) {
            destination.put(ATTR_FILTER_NAME, object.filter.name());
        }

        @Override
        protected void getChildren(ConfiguredImageFilter object, MultiMap<String, Object> destination) {
            destination.putLast(FIELD_PROPERTIES_LIST, object.properties);
        }
    }
}

