/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.model;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class Card
extends ProjectComponent {
    public static final Icon ICON = IconLoader.loadIcon("silk/map.png");
    private final List<Scene> scenes = new ArrayList<Scene>();
    private Reference<SceneLocation> startingLocation;

    public Card(String id) {
        super(id);
        this.registerChildType(Scene.class, Scene.SCENE_ICON, true);
        this.startingLocation = new Reference();
    }

    public List<Scene> getScenes() {
        return this.scenes;
    }

    public void addScene(Scene scene) {
        this.addScene(scene, true);
    }

    public void removeScene(Scene scene) {
        this.removeScene(scene, true);
    }

    public SceneLocation getStartingLocation() {
        SceneLocation result = this.startingLocation.resolve();
        if (result == null) {
            CollectionUtils.first(this.getDescendantsByType(SceneLocation.class, new ArrayList()));
        }
        return result;
    }

    public void setStartingLocation(SceneLocation startingLocation) {
        this.startingLocation = new Reference<SceneLocation>((ProjectComponent)this, startingLocation);
        this.fireModified();
    }

    @Override
    public PatchworkProject getParentComponent() {
        return (PatchworkProject)super.getParentComponent();
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public void addChildComponent(String id, Class<? extends ProjectComponent> type) {
        if (type == Scene.class) {
            this.addScene(new Scene(id), true);
        }
    }

    @Override
    public void addChildComponent(ProjectComponent child, int insertIndex) {
        if (child instanceof Scene) {
            this.addScene((Scene)child, true);
        }
    }

    @Override
    public void removeChildComponent(ProjectComponent child) {
        if (child instanceof Scene) {
            this.removeScene((Scene)child, true);
        }
    }

    private void addScene(Scene scene, boolean notify) {
        this.scenes.add(scene);
        this.registerChild(scene, notify);
    }

    private void removeScene(Scene scene, boolean notify) {
        this.scenes.remove(scene);
        this.removeChild(scene, notify);
    }

    public static class Transcoder
    extends ProjectComponent.Transcoder<Card> {
        private static final String ELEMENT_NAME = "Card";
        private static final String FIELD_SCENES = "scenes";
        private static final String ATTR_START_LOCATION = "startingLocation";

        public Transcoder() {
            super(ELEMENT_NAME, Card.class);
            this.setFieldTranscoder(FIELD_SCENES, new Scene.Transcoder());
        }

        @Override
        protected Card decode(String id, Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            Card result = new Card(id);
            for (Object scene : decodedChildren.getAll(FIELD_SCENES)) {
                result.addScene((Scene)scene, false);
            }
            result.startingLocation = new Reference<String>((ProjectComponent)result, attributes.get(ATTR_START_LOCATION));
            return result;
        }

        @Override
        protected void getAttributes(Card object, Map<String, String> destination) {
            super.getAttributes(object, destination);
            destination.put(ATTR_START_LOCATION, object.startingLocation.encode());
        }

        @Override
        protected void getChildren(Card object, MultiMap<String, Object> destination) {
            for (Scene scene : object.getScenes()) {
                destination.putLast(FIELD_SCENES, scene);
            }
        }
    }
}

