/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.as3;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.animation.AS3Animation;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerProperties;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LayeredImageGraphic;
import com.sodiumarc.patchwork.generate.CardState;
import com.sodiumarc.patchwork.render.control.RenderImage;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class AS3Publisher {
    private TemplateLibrary templates;

    public AS3Publisher() {
        try {
            this.templates = new TemplateLibrary(PatchworkComposerProperties.AS3_TEMPLATE_FILE.getFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void publishProject(PatchworkProject project, Set<Card> cards, File outputDir) {
        if (this.templates == null) {
            return;
        }
        try {
            StringTemplate template = this.templates.getTemplate("GameConfig");
            assert (template != null) : "Missing template: " + this.getClass();
            StringTemplate addCardTemplate = this.templates.getTemplate("GameConfig.ADD_CARD");
            assert (addCardTemplate != null) : "Missing template: ADD_CARD";
            StringBuilder addCards = new StringBuilder();
            for (Card card : cards) {
                addCardTemplate.setParameterValue("CARD_ID", card.getID());
                addCards.append(addCardTemplate.getProcessedText());
                this.publishCard(card, outputDir);
            }
            template.setParameterValue("ADD_CARDS", addCards.toString());
            template.setParameterValue("GRID_BG_COLOR", "0xEEEEEE");
            template.setParameterValueQuoted("PROLOGUE_CARD_ID", null);
            template.setParameterValueQuoted("PROLOGUE_END_STATE_ID", null);
            template.setParameterValue((Object)"GRID_SIZE", 2 * PatchworkProject.CARD_SIZE);
            String filename = FileUtils.ensureExtension("MyGameConfig", "as");
            File outputFile = new File(outputDir, filename);
            String as3String = template.getProcessedText();
            FileUtils.writeString(as3String, outputFile);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void publishCard(Card card, File outputDir) {
        try {
            StringTemplate template = this.templates.getTemplate(Card.class);
            assert (template != null) : "Missing template: " + Card.class;
            StringTemplate resourceTemplate = this.templates.getTemplate(Card.class, "RESOURCE");
            assert (resourceTemplate != null) : "Missing template: RESOURCE";
            StringTemplate shadowImageTemplate = this.templates.getTemplate("SHADOW_IMAGE");
            assert (shadowImageTemplate != null) : "Missing template: SHADOW_IMAGE";
            StringTemplate addAnimToDictTemplate = this.templates.getTemplate(AS3Animation.class, "ADD_TO_DICTIONARY");
            assert (addAnimToDictTemplate != null) : "Missing template: ADD_TO_DICTIONARY";
            StringTemplate addKeyframesToDictTemplate = this.templates.getTemplate(AS3Animation.class, "ADD_TO_DICTIONARY");
            assert (addKeyframesToDictTemplate != null) : "Missing template: ADD_TO_DICTIONARY";
            StringBuilder stateDefList = new StringBuilder();
            for (SceneLocation sceneLocation : card.getDescendantsByType(SceneLocation.class)) {
                stateDefList.append(this.encodeSceneLocation(sceneLocation));
            }
            String encodedResources = this.encodeResources(card, resourceTemplate);
            StringBuilder shadows = new StringBuilder();
            List<RenderImage> shadowImages = CardState.getDefaultShadowImages();
            int index = 0;
            for (RenderImage shadowImage : shadowImages) {
                shadowImageTemplate.setParameterValue("IMAGE_NAME", shadowImage.getImageFilename());
                shadowImageTemplate.setParameterValue("IMAGE_INDEX", Integer.toString(index++));
                shadowImageTemplate.setParameterValue("IMAGE_COUNT", Integer.toString(shadowImages.size()));
                shadows.append(shadowImageTemplate.getProcessedText());
            }
            template.clearParameterValues();
            template.setParameterValue("CARD_ID", card.getID());
            template.setParameterValue("CARD_STATES", stateDefList.toString());
            template.setParameterValue("STARTING_STATE_ID", card.getStartingLocation().getIDPath(1));
            template.setParameterValue("RESOURCES", encodedResources);
            template.setParameterValue("SHADOW_IMAGES", shadows.toString());
            String filename = FileUtils.ensureExtension(card.getID(), "as");
            File outputFile = new File(outputDir, filename);
            String as3String = template.getProcessedText();
            FileUtils.writeString(as3String, outputFile);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String encodeResources(Card card, StringTemplate resourceTemplate) throws ParseException {
        StringBuilder result = new StringBuilder();
        Collection<LayeredImageGraphic> graphics = card.getDescendantsByType(LayeredImageGraphic.class, new ArrayList());
        for (LayeredImageGraphic graphic : graphics) {
            BufferedImage image = graphic.getImage(0.0f);
            Rectangle4d outputBounds = graphic.getOutputBounds();
            String filename = graphic.getGUID() + ".png";
            resourceTemplate.setParameterValue("IMAGE_NAME", filename);
            resourceTemplate.setParameterValue("IMAGE_OFFSET", StringUtils.encodePoint(new Point((int)outputBounds.getX(), (int)outputBounds.getY())));
            result.append(resourceTemplate.getProcessedText());
            File outputFile = new File(PatchworkComposerProperties.AS3_IMAGE_OUTPUT_DIR.getFile(), filename);
            try {
                ImageUtils.saveImage(image, outputFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result.toString();
    }

    private String encodeSceneLocation(SceneLocation location) throws ParseException {
        StringTemplate template = this.templates.getTemplate(SceneLocation.class);
        assert (template != null) : "Missing template: " + this.getClass();
        StringTemplate addToArrayTemplate = this.templates.getTemplate(AS3Animation.class, "ADD_TO_ARRAY");
        assert (addToArrayTemplate != null) : "Missing template: ADD_TO_ARRAY";
        StringBuilder animDefList = new StringBuilder();
        template.clearParameterValues();
        template.setParameterValue("HOTSPOTS", null);
        template.setParameterValue("CARD_LINK_CRITERIA", null);
        template.setParameterValue("CONDITIONAL_TRANSITIONS", null);
        template.setParameterValue("ANIMATIONS", animDefList.toString());
        template.setParameterValue("MASKS", null);
        template.setParameterValue("CARD_STATE_ID", location.getIDPath(1));
        template.setParameterValueQuoted("TRANSITION_STATE_ID", null);
        template.setParameterValueQuoted("SPAWN_CARD_ID", null);
        template.setParameterValue((Object)"BG_ALPHA", 0L);
        template.setParameterValue("IS_GRID_ANCHORED", Boolean.toString(false));
        return template.getProcessedText();
    }
}

