/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Tuple3d;

public abstract class Tuple3dPanel
extends JPanel {
    private JSpinner xSpinner = this.makeSpinner();
    private JSpinner ySpinner = this.makeSpinner();
    private JSpinner zSpinner = this.makeSpinner();
    private ChangeListener spinnerListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            Tuple3dPanel.this.valueChanged();
        }
    };

    public Tuple3dPanel() {
        super(new GridLayout(1, 3, 5, 5));
        this.add(this.xSpinner);
        this.add(this.ySpinner);
        this.add(this.zSpinner);
    }

    public void setValue(Tuple3d value) {
        this.setSpinner(this.xSpinner, value == null ? 0.0 : value.getX());
        this.setSpinner(this.ySpinner, value == null ? 0.0 : value.getY());
        this.setSpinner(this.zSpinner, value == null ? 0.0 : value.getZ());
    }

    public <T extends Tuple3d> T getValue(T result) {
        result.setX((Double)this.xSpinner.getValue());
        result.setY((Double)this.ySpinner.getValue());
        result.setZ((Double)this.zSpinner.getValue());
        return result;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.xSpinner.setEnabled(enabled);
        this.ySpinner.setEnabled(enabled);
        this.zSpinner.setEnabled(enabled);
    }

    protected abstract void valueChanged();

    private JSpinner makeSpinner() {
        JSpinner result = new JSpinner(new SpinnerNumberModel(0.0, -100000.0, 100000.0, 0.1));
        ((JSpinner.DefaultEditor)result.getEditor()).getTextField().setColumns(5);
        result.addChangeListener(this.spinnerListener);
        return result;
    }

    private void setSpinner(JSpinner spinner, double value) {
        spinner.removeChangeListener(this.spinnerListener);
        spinner.setValue(value);
        spinner.addChangeListener(this.spinnerListener);
    }
}

