/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.tree.ProjectComponentTree;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public abstract class TreeChooserButton
extends JButton {
    private final boolean showSelected;
    private ProjectComponent choiceRoot;
    private ProjectComponent expandRoot;
    private ProjectComponent selected;
    private Set<Class<?>> enabledTypes;

    public TreeChooserButton() {
        this((Icon)null, (String)null);
    }

    public TreeChooserButton(Icon icon) {
        this(icon, null);
    }

    public TreeChooserButton(Icon icon, String text) {
        super(text, icon);
        this.showSelected = icon == null && text == null;
        this.setHorizontalAlignment(2);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeChooserButton.this.onPress();
            }
        });
        this.setSelected(null);
    }

    public void setEnabledTypes(Set<Class<?>> enabledTypes) {
        this.enabledTypes = enabledTypes;
    }

    public void setEnabledType(Class<?> enabledType) {
        this.enabledTypes = new HashSet();
        this.enabledTypes.add(enabledType);
    }

    public void setEnabledTypes(Class<?> ... enabledType) {
        this.enabledTypes = new HashSet();
        for (Class<?> type : enabledType) {
            this.enabledTypes.add(type);
        }
    }

    public void setChoiceRoot(ProjectComponent choiceRoot) {
        this.choiceRoot = choiceRoot;
        this.updateEnabling();
    }

    public void setExpandRoot(ProjectComponent expandRoot) {
        this.expandRoot = expandRoot;
    }

    public void setSelected(ProjectComponent selected) {
        this.selected = selected;
        if (this.showSelected) {
            this.setIcon(selected == null ? null : selected.getIcon());
            this.setText(selected == null ? "Choose..." : selected.getID());
        }
    }

    public ProjectComponent getSelected() {
        return this.selected;
    }

    protected abstract void selectionChanged(ProjectComponent var1);

    protected void canceled() {
    }

    private void onPress() {
        ProjectComponentTree chooserTree = new ProjectComponentTree(false);
        if (this.choiceRoot != null) {
            chooserTree.setRoots(Collections.singleton(this.choiceRoot));
            if (this.expandRoot != null) {
                chooserTree.expandPath(this.expandRoot);
            } else {
                chooserTree.expandPath(this.choiceRoot);
            }
            if (this.selected != null) {
                chooserTree.setSingleSelection(this.selected);
            }
        }
        chooserTree.setEnabledTypes(this.enabledTypes);
        JScrollPane scroller = new JScrollPane(chooserTree);
        scroller.setPreferredSize(new Dimension(300, 400));
        int paneResult = JOptionPane.showConfirmDialog(this, scroller, "Choose", 2);
        if (paneResult == 0) {
            ProjectComponent selection = chooserTree.getSingleSelection();
            if (selection == null) {
                this.setSelected(null);
                this.selectionChanged(null);
            } else if (this.isValidSelection(selection)) {
                this.setSelected(selection);
                this.selectionChanged(selection);
            }
        } else {
            this.canceled();
        }
    }

    private boolean isValidSelection(ProjectComponent selection) {
        if (this.enabledTypes == null) {
            return true;
        }
        for (Class<?> type : this.enabledTypes) {
            if (!type.isAssignableFrom(selection.getClass())) continue;
            return true;
        }
        return false;
    }

    private void updateEnabling() {
        this.setEnabled(this.choiceRoot != null);
    }
}

