/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.util.ColorComponent;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.List;

public class TraceImagePrintable
implements Printable {
    public static float CELL_MARGIN = 0.02f;
    private final List<BufferedImage> pages;
    private final float traceAlpha;

    public TraceImagePrintable(List<BufferedImage> graphics, float traceAlpha) {
        this.pages = graphics;
        this.traceAlpha = traceAlpha;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.pages.size()) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Dimension pageDimension = new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        int topSectionHeight = pageDimension.height - pageDimension.width;
        int margin = (int)(CELL_MARGIN * (float)pageDimension.width);
        Rectangle topCellRect = new Rectangle(margin, margin, pageDimension.width - margin * 2, topSectionHeight - margin * 2);
        Rectangle bottomCellRect = new Rectangle(margin, topSectionHeight + margin, pageDimension.width - margin * 2, pageDimension.width - margin * 2);
        BufferedImage image = this.pages.get(pageIndex);
        int gridSize = PatchworkProject.CARD_SIZE * 2;
        Dimension topImageSize = new Dimension((int)((float)topCellRect.height * ((float)image.getWidth() / (float)image.getHeight())), topCellRect.height);
        float imageWidthProp = (float)image.getWidth() / (float)gridSize;
        float imageHeightProp = (float)image.getHeight() / (float)gridSize;
        Dimension bottomImageSize = new Dimension((int)(imageWidthProp * (float)bottomCellRect.width), (int)(imageHeightProp * (float)bottomCellRect.height));
        BufferedImage topImage = ImageUtils.scale(image, topImageSize.width, topImageSize.height);
        BufferedImage bottomImage = ImageUtils.scale(image, bottomImageSize.width, bottomImageSize.height);
        this.fade(bottomImage, this.traceAlpha);
        graphics.drawImage(topImage, topCellRect.x, topCellRect.y, null);
        graphics.drawImage(bottomImage, bottomCellRect.x, bottomCellRect.y, null);
        graphics.setColor(Color.GRAY);
        graphics.drawRect(bottomCellRect.x - 2, bottomCellRect.y - 2, bottomCellRect.width + 4, bottomCellRect.height + 4);
        graphics.setColor(Color.BLUE);
        this.drawCross(graphics, new Point(bottomCellRect.x, topSectionHeight), 5);
        this.drawCross(graphics, new Point(bottomCellRect.x + bottomCellRect.width, topSectionHeight), 5);
        return 0;
    }

    private void drawCross(Graphics graphics, Point center, int radius) {
        graphics.drawLine(center.x - radius, center.y, center.x + radius, center.y);
        graphics.drawLine(center.x, center.y - radius, center.x, center.y + radius);
    }

    private void fade(BufferedImage image, float mult) {
        int n = image.getWidth();
        for (int x = 0; x < n; ++x) {
            int m = image.getHeight();
            for (int y = 0; y < m; ++y) {
                int color = image.getRGB(x, y);
                int alpha = ColorUtils.getComponent(color, ColorComponent.ALPHA);
                int tone = ColorUtils.getIntensity(color);
                color = ColorUtils.toIntARGB((int)(mult * (float)alpha), tone, tone, tone);
                image.setRGB(x, y, color);
            }
        }
    }
}

