/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.Predicate;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.StateTransition;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class StateTransitionPanel
extends ProjectComponentPanel<StateTransition> {
    private TreeChooserButton destinationButton;
    private JComboBox operatorCombo;
    private ActionListener operatorComboListener;
    private LabeledRowPanel.LabeledRow formulaRow;
    private JTextField operatorFormulaField;
    private FormulaFieldListener formulaFieldListener;
    private JCheckBox unstackedOnlyCheckBox;
    private ActionListener unstackedOnlyListener;
    private JCheckBox bidirectionalCheckBox;
    private ActionListener bidirectionalListener;

    @Override
    protected JComponent getMainArea() {
        this.destinationButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((StateTransition)StateTransitionPanel.this.getTarget()).setDestinationState((SceneLayerState)selection);
                StateTransitionPanel.this.fireTargetModified();
            }
        };
        this.destinationButton.setEnabledType(SceneLayerState.class);
        this.operatorCombo = new JComboBox<Predicate.Operator>(Predicate.Operator.values());
        this.operatorComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StateTransition target = (StateTransition)StateTransitionPanel.this.getTarget();
                if (target != null) {
                    target.setPredicateOperator((Predicate.Operator)((Object)StateTransitionPanel.this.operatorCombo.getSelectedItem()));
                    StateTransitionPanel.this.updateEnabling();
                    StateTransitionPanel.this.fireTargetModified();
                }
            }
        };
        this.operatorFormulaField = new JTextField(20);
        this.formulaFieldListener = new FormulaFieldListener();
        this.operatorFormulaField.addFocusListener(this.formulaFieldListener);
        this.unstackedOnlyCheckBox = new JCheckBox();
        this.unstackedOnlyListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StateTransition target = (StateTransition)StateTransitionPanel.this.getTarget();
                if (target != null) {
                    target.setUnstackedOnly(StateTransitionPanel.this.unstackedOnlyCheckBox.isSelected());
                    StateTransitionPanel.this.fireTargetModified();
                }
            }
        };
        this.bidirectionalCheckBox = new JCheckBox();
        this.bidirectionalListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StateTransition target = (StateTransition)StateTransitionPanel.this.getTarget();
                if (target != null) {
                    target.setBidirectional(StateTransitionPanel.this.bidirectionalCheckBox.isSelected());
                    StateTransitionPanel.this.fireTargetModified();
                }
            }
        };
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("Destination:", (Component)this.destinationButton, true));
        rows.add(new LabeledRowPanel.LabeledRow("Predicate Rule:", (Component)this.operatorCombo));
        this.formulaRow = new LabeledRowPanel.LabeledRow("Predicate Formula:", (Component)this.operatorFormulaField, true);
        this.formulaRow.setEnabled(false);
        rows.add(this.formulaRow);
        rows.add(new LabeledRowPanel.LabeledRow("Bidirectional:", (Component)this.bidirectionalCheckBox));
        rows.add(new LabeledRowPanel.LabeledRow("Unstacked Only:", (Component)this.unstackedOnlyCheckBox));
        return new LabeledRowPanel(rows);
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        StateTransition target = (StateTransition)this.getTarget();
        this.operatorCombo.removeActionListener(this.operatorComboListener);
        this.operatorFormulaField.removeActionListener(this.formulaFieldListener);
        this.unstackedOnlyCheckBox.removeActionListener(this.unstackedOnlyListener);
        this.bidirectionalCheckBox.removeActionListener(this.bidirectionalListener);
        if (target != null) {
            this.destinationButton.setChoiceRoot(target.getAncestorByType(SceneLayer.class));
            this.destinationButton.setExpandRoot(target.getAncestorByType(SceneLayer.class));
            this.destinationButton.setSelected(target.getDestinationState());
            this.unstackedOnlyCheckBox.setSelected(target.isUnstackedOnly());
            this.bidirectionalCheckBox.setSelected(target.isBidirectional());
            this.operatorCombo.setSelectedItem((Object)target.getPredicateOperator());
            this.operatorFormulaField.setText(target.getPredicateFormula());
        } else {
            this.destinationButton.setChoiceRoot(null);
            this.destinationButton.setExpandRoot(null);
            this.destinationButton.setSelected(null);
            this.unstackedOnlyCheckBox.setSelected(false);
            this.bidirectionalCheckBox.setSelected(false);
            this.operatorFormulaField.setText(null);
        }
        this.operatorCombo.addActionListener(this.operatorComboListener);
        this.operatorFormulaField.addActionListener(this.formulaFieldListener);
        this.unstackedOnlyCheckBox.addActionListener(this.unstackedOnlyListener);
        this.bidirectionalCheckBox.addActionListener(this.bidirectionalListener);
        this.updateEnabling();
    }

    private void onFormulaChanged() {
        StateTransition target = (StateTransition)this.getTarget();
        if (target != null) {
            String text = this.operatorFormulaField.getText();
            if (text != null && text.trim().isEmpty()) {
                text = null;
            }
            target.setPredicateFormula(text);
            this.fireTargetModified();
        }
    }

    private void updateEnabling() {
        this.formulaRow.setEnabled(this.operatorCombo.getSelectedItem() == Predicate.Operator.FORMULA);
    }

    private class FormulaFieldListener
    implements ActionListener,
    FocusListener {
        private FormulaFieldListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            StateTransitionPanel.this.onFormulaChanged();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StateTransitionPanel.this.onFormulaChanged();
        }
    }
}

