/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.common.DoubleSpinner;
import com.sodiumarc.patchwork.app.scenecomposer.GridCoordsPanel;
import com.sodiumarc.patchwork.app.scenecomposer.LocationLayerGraphicPanel;
import com.sodiumarc.patchwork.app.scenecomposer.PointPanel;
import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentList;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.SlideGraphic;
import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SlideGraphicPanel
extends LocationLayerGraphicPanel<SlideGraphic> {
    private GridCoordsPanel tileSizeSpinners;
    private PointPanel startOffsetPanel;
    private PointPanel endOffsetPanel;
    private DoubleSpinner durationSpinner;
    private ProjectComponentList<LocationLayerGraphic> graphicsList;

    @Override
    protected JComponent getMainArea() {
        this.tileSizeSpinners = new GridCoordsPanel(){

            @Override
            protected void valueChanged() {
                SlideGraphic target = (SlideGraphic)SlideGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setTileSize(SlideGraphicPanel.this.tileSizeSpinners.getValue());
                    SlideGraphicPanel.this.fireTargetModified();
                }
            }

            @Override
            protected int getRangeMin() {
                return 1;
            }

            @Override
            protected int getRangeMax() {
                return 100;
            }
        };
        this.startOffsetPanel = new PointPanel(){

            @Override
            protected void valueChanged() {
                SlideGraphic target = (SlideGraphic)SlideGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setStartOffset(SlideGraphicPanel.this.startOffsetPanel.getValue());
                    SlideGraphicPanel.this.fireTargetModified();
                }
            }

            @Override
            protected Range<Integer> getRange() {
                return new Range<Integer>(-100, 100);
            }
        };
        this.endOffsetPanel = new PointPanel(){

            @Override
            protected void valueChanged() {
                SlideGraphic target = (SlideGraphic)SlideGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setEndOffset(SlideGraphicPanel.this.endOffsetPanel.getValue());
                    SlideGraphicPanel.this.fireTargetModified();
                }
            }

            @Override
            protected Range<Integer> getRange() {
                return new Range<Integer>(-100, 100);
            }
        };
        this.durationSpinner = new DoubleSpinner(1.0, 0.0, 100.0, 0.1){

            @Override
            protected void valueChanged(double value) {
                SlideGraphic target = (SlideGraphic)SlideGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setDurationSeconds((float)value);
                    SlideGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.graphicsList = new ProjectComponentList<LocationLayerGraphic>("Graphics", LocationLayerGraphic.class, 1, true){

            @Override
            protected List<LocationLayerGraphic> getContents() {
                SlideGraphic target = (SlideGraphic)SlideGraphicPanel.this.getTarget();
                return target == null ? null : target.getGraphics();
            }

            @Override
            protected void selectionChanged(List<LocationLayerGraphic> selected) {
            }

            @Override
            protected void onAdd(LocationLayerGraphic toAdd) {
                SlideGraphic target = (SlideGraphic)SlideGraphicPanel.this.getTarget();
                if (target != null) {
                    target.addGraphic(toAdd);
                    SlideGraphicPanel.this.fireTargetModified();
                }
            }

            @Override
            protected void onDelete(List<LocationLayerGraphic> toDelete) {
                SlideGraphic target = (SlideGraphic)SlideGraphicPanel.this.getTarget();
                if (target != null) {
                    for (LocationLayerGraphic graphic : toDelete) {
                        target.removeGraphic(graphic);
                    }
                    SlideGraphicPanel.this.fireTargetModified();
                }
            }
        };
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("Tile Size (rows, cols):", (Component)this.tileSizeSpinners));
        rows.add(new LabeledRowPanel.LabeledRow("Start Offset (cols, rows):", (Component)this.startOffsetPanel));
        rows.add(new LabeledRowPanel.LabeledRow("End Offset (cols, rows):", (Component)this.endOffsetPanel));
        rows.add(new LabeledRowPanel.LabeledRow("Duration (seconds):", (Component)this.durationSpinner));
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)new LabeledRowPanel("Animation", rows), "North");
        result.add(this.graphicsList, "Center");
        result.add((Component)this.getCommonSettingsPanel(), "South");
        return result;
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        SlideGraphic target = (SlideGraphic)this.getTarget();
        if (target != null) {
            this.graphicsList.setChoiceRoot(target.getPath().get(0));
            this.graphicsList.setExpandRoot(target.getParentComponent());
            this.startOffsetPanel.setValue(target.getStartOffset());
            this.endOffsetPanel.setValue(target.getEndOffset());
            this.durationSpinner.setDoubleValue(target.getDurationSeconds());
            this.tileSizeSpinners.setValue(target.getTileSize());
        } else {
            this.graphicsList.setChoiceRoot(null);
            this.graphicsList.setExpandRoot(null);
            this.startOffsetPanel.setValue(null);
            this.endOffsetPanel.setValue(null);
            this.durationSpinner.setDoubleValue(0.0);
            this.tileSizeSpinners.setValue(null);
        }
        this.graphicsList.update();
    }
}

