/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.scenecomposer.LocationLayerGraphicPanel;
import com.sodiumarc.patchwork.app.scenecomposer.PointPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.ShadowGraphic;
import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ShadowGraphicPanel
extends LocationLayerGraphicPanel<ShadowGraphic> {
    private TreeChooserButton castingGraphicButton;
    private TreeChooserButton receivingGraphicButton;
    private PointPanel manualPivotPanel;
    private JSpinner alphaSpinner;
    private ChangeListener alphaListener;

    @Override
    protected JComponent getMainArea() {
        this.castingGraphicButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((ShadowGraphic)ShadowGraphicPanel.this.getTarget()).setCastingGraphic((LocationLayerGraphic)selection);
                ShadowGraphicPanel.this.fireTargetModified();
            }
        };
        this.castingGraphicButton.setEnabledType(LocationLayerGraphic.class);
        this.receivingGraphicButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((ShadowGraphic)ShadowGraphicPanel.this.getTarget()).setReceivingGraphic((LocationLayerGraphic)selection);
                ShadowGraphicPanel.this.fireTargetModified();
            }
        };
        this.receivingGraphicButton.setEnabledType(LocationLayerGraphic.class);
        this.manualPivotPanel = new PointPanel(){

            @Override
            protected void valueChanged() {
                ((ShadowGraphic)ShadowGraphicPanel.this.getTarget()).setShadowOffset(ShadowGraphicPanel.this.manualPivotPanel.getValue());
                ShadowGraphicPanel.this.fireTargetModified();
            }

            @Override
            protected Range<Integer> getRange() {
                return new Range<Integer>(-1000, 10000);
            }
        };
        this.alphaSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.05));
        ((JSpinner.DefaultEditor)this.alphaSpinner.getEditor()).getTextField().setColumns(4);
        this.alphaListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((ShadowGraphic)ShadowGraphicPanel.this.getTarget()).setShadowAlpha(((Double)ShadowGraphicPanel.this.alphaSpinner.getValue()).floatValue());
                ShadowGraphicPanel.this.fireTargetModified();
            }
        };
        JButton refreshButton = new JButton("Refresh", IconLoader.loadIcon("silk/arrow_refresh.png"));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShadowGraphic target = (ShadowGraphic)ShadowGraphicPanel.this.getTarget();
                if (target != null) {
                    target.refresh();
                }
            }
        });
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("Casting Graphic:", (Component)this.castingGraphicButton, true));
        rows.add(new LabeledRowPanel.LabeledRow("Receiving Graphic:", (Component)this.receivingGraphicButton, true));
        rows.add(new LabeledRowPanel.LabeledRow("Shadow Offset (x,y):", (Component)this.manualPivotPanel, true));
        rows.add(new LabeledRowPanel.LabeledRow("Alpha:", (Component)this.alphaSpinner, false));
        rows.add(new LabeledRowPanel.LabeledRow("", (Component)refreshButton, false));
        return new LabeledRowPanel(rows);
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        ShadowGraphic target = (ShadowGraphic)this.getTarget();
        this.alphaSpinner.removeChangeListener(this.alphaListener);
        if (target != null) {
            this.castingGraphicButton.setChoiceRoot(target.getAncestorByType(Card.class));
            this.castingGraphicButton.setExpandRoot(target.getParentComponent());
            this.castingGraphicButton.setSelected(target.getCastingGraphic());
            this.receivingGraphicButton.setChoiceRoot(target.getAncestorByType(PatchworkProject.class));
            this.receivingGraphicButton.setExpandRoot(target.getParentComponent());
            this.receivingGraphicButton.setSelected(target.getReceivingGraphic());
            this.manualPivotPanel.setValue(target.getShadowOffset());
            this.alphaSpinner.setValue(new Double(target.getShadowAlpha()));
        }
        this.alphaSpinner.addChangeListener(this.alphaListener);
    }
}

