/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.MarginsPanel;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerApp;
import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentList;
import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.CardLink;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.LocationTransition;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundClip;
import com.sodiumarc.patchwork.app.scenecomposer.table.IOTypeTable;
import com.sodiumarc.patchwork.app.scenecomposer.table.ProjectComponentTable;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SceneLocationPanel
extends ProjectComponentPanel<SceneLocation> {
    private IOTypeTable filePatternTable;
    private JButton autoLoadButton;
    private TreeChooserButton backgroundButton;
    private TreeChooserButton ambientSoundButton;
    private MarginsPanel marginsPanel;
    private ProjectComponentList<SceneLocation> otherLocationList;
    private ProjectComponentTable<SceneLocation> stateTable;

    @Override
    protected JComponent getMainArea() {
        this.otherLocationList = new ProjectComponentList<SceneLocation>("Show Other Locations", SceneLocation.class, 1, false){

            @Override
            protected void selectionChanged(List<SceneLocation> selected) {
                SceneLocation target = (SceneLocation)SceneLocationPanel.this.getTarget();
                if (target != null) {
                    target.clearShowOtherLocations();
                    for (SceneLocation location : selected) {
                        target.addShowOtherLocation(location);
                    }
                    SceneLocationPanel.this.fireTargetModified();
                }
            }
        };
        EnumMap<IOFileType, String> defaults = new EnumMap<IOFileType, String>(IOFileType.class);
        for (IOFileType type : IOFileType.values()) {
            if (!type.isImageType()) continue;
            defaults.put(type, type.getDefaultFilenamePattern());
        }
        this.filePatternTable = new IOTypeTable(defaults){

            @Override
            protected void targetChanged(Map<IOFileType, String> targetMap) {
                SceneLocationPanel.this.fireTargetModified();
            }

            @Override
            protected String onEdit(IOFileType key, String currentValue) {
                JTextField editField = new JTextField(20);
                editField.setText(currentValue);
                int paneResult = JOptionPane.showConfirmDialog(this, editField, "Enter File Pattern", 2);
                if (paneResult == 0) {
                    return editField.getText().trim();
                }
                return currentValue;
            }
        };
        JScrollPane scroller = new JScrollPane(this.filePatternTable);
        scroller.getViewport().setBackground(Color.WHITE);
        scroller.setPreferredSize(new Dimension(400, 110));
        this.autoLoadButton = new JButton("Auto Load");
        this.autoLoadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SceneLocationPanel.this.getTarget() != null) {
                    ((SceneLocation)SceneLocationPanel.this.getTarget()).autoLoadImages();
                    SceneLocationPanel.this.fireTargetModified();
                }
            }
        });
        this.backgroundButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((SceneLocation)SceneLocationPanel.this.getTarget()).setBackgroundLocation((SceneLocation)selection);
                SceneLocationPanel.this.fireTargetModified();
            }
        };
        this.backgroundButton.setEnabledType(SceneLocation.class);
        this.ambientSoundButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((SceneLocation)SceneLocationPanel.this.getTarget()).setAmbientSound((SoundClip)selection);
                SceneLocationPanel.this.fireTargetModified();
            }
        };
        this.ambientSoundButton.setEnabledType(SoundClip.class);
        this.marginsPanel = new MarginsPanel("Render Margins"){

            @Override
            protected void marginsChanged() {
                SceneLocationPanel.this.onMarginChange();
            }

            @Override
            protected void marginsCleared() {
                SceneLocationPanel.this.onMarginsCleared();
            }
        };
        this.stateTable = new ProjectComponentTable<SceneLocation>(EnumSet.of(ProjectComponentTable.ButtonColumn.Del), "State", true){

            @Override
            protected void getRows(SceneLocation target, List<ProjectComponent> tableRows) {
                for (SceneLayer layer : target.getParentComponent().getSceneLayers()) {
                    for (SceneLayerState state : layer.getStates(true)) {
                        tableRows.add(state);
                        for (LocationTransition transition : target.getTransitions()) {
                            if (!transition.getAttachedStates().contains(state)) continue;
                            tableRows.add(transition);
                        }
                        for (CardLink cardLink : target.getCardLinks()) {
                            if (!cardLink.getAttachedStates().contains(state)) continue;
                            tableRows.add(cardLink);
                        }
                    }
                }
            }

            @Override
            protected int getLabelGenerations(int row, List<ProjectComponent> tableRows) {
                return 2;
            }

            @Override
            protected boolean isSectionHeaderRow(int row, List<ProjectComponent> tableRows) {
                ProjectComponent component = tableRows.get(row);
                return component instanceof SceneLayerState;
            }

            @Override
            protected boolean isRowRemovable(int row, List<ProjectComponent> tableRows) {
                ProjectComponent component = tableRows.get(row);
                return !(component instanceof SceneLayerState);
            }
        };
        ArrayList<LabeledRowPanel.LabeledRow> generalRows = new ArrayList<LabeledRowPanel.LabeledRow>();
        generalRows.add(new LabeledRowPanel.LabeledRow("Background Location:", (Component)this.backgroundButton, true));
        generalRows.add(new LabeledRowPanel.LabeledRow("Ambient Sound:", (Component)this.ambientSoundButton, true));
        JPanel patternPanel = new JPanel(new BorderLayout(5, 5));
        patternPanel.setBorder(BorderFactory.createTitledBorder("Image Patterns (scene, loc, layer)"));
        patternPanel.add((Component)scroller, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)this.autoLoadButton, "East");
        patternPanel.add((Component)bottomPanel, "South");
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.add(this.marginsPanel);
        leftPanel.add(new LabeledRowPanel("General", generalRows));
        leftPanel.add(this.otherLocationList);
        leftPanel.add(patternPanel);
        return leftPanel;
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        SceneLocation location = (SceneLocation)this.getTarget();
        this.otherLocationList.clear();
        if (location != null) {
            this.filePatternTable.setTargetMap(location.getFilenameFormats());
            this.backgroundButton.setChoiceRoot(location.getAncestorByType(Card.class));
            this.backgroundButton.setExpandRoot(location.getAncestorByType(Scene.class));
            this.backgroundButton.setSelected(location.getBackgroundLocation());
            this.ambientSoundButton.setChoiceRoot(location.getAncestorByType(PatchworkProject.class));
            this.ambientSoundButton.setExpandRoot(location.getAncestorByType(Scene.class));
            this.ambientSoundButton.setSelected(location.getAmbientSound());
            this.marginsPanel.setMarginsRegion(location.getMarginsRegion());
            Scene card = location.getAncestorByType(Scene.class);
            if (card != null) {
                ArrayList<SceneLocation> locations = new ArrayList<SceneLocation>(card.getLocations());
                locations.remove(location);
                this.otherLocationList.setContents(locations, location.getShowOtherLocations());
            }
        }
        this.stateTable.setTarget(location);
    }

    private void onMarginChange() {
        SceneLocation target = (SceneLocation)this.getTarget();
        if (target != null) {
            target.setMarginsRegion(this.marginsPanel.getMarginsRegion());
            this.fireTargetModified();
        }
    }

    protected void onMarginsCleared() {
        SceneLocation target = (SceneLocation)this.getTarget();
        if (target != null) {
            target.setMarginsRegion(PatchworkComposerApp.CANONICAL_RECT);
            this.marginsPanel.setMarginsRegion(target.getMarginsRegion());
            this.fireTargetModified();
        }
    }
}

