/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.table.LocationLayerGraphicTable;
import com.sodiumarc.patchwork.app.scenecomposer.table.ProjectComponentTable;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import com.sodiumarc.patchwork.util.TargetablePanel;
import com.sodiumarc.patchwork.util.TargetablePanelListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SceneLocationLayerPanel
extends ProjectComponentPanel<SceneLocationLayer> {
    private TreeChooserButton sceneLayerButton;
    private JSpinner transitionSpinner;
    private ChangeListener transitionListener;
    private JButton hazeColorButton;
    private JSpinner hazeAmountSpinner;
    private ChangeListener hazeAmountListener;
    private ProjectComponentTable<SceneLocationLayer> childTable;
    private LocationLayerGraphicTable graphicTable;

    @Override
    protected void targetSet() {
        super.targetSet();
        SceneLocationLayer target = (SceneLocationLayer)this.getTarget();
        this.transitionSpinner.removeChangeListener(this.transitionListener);
        this.hazeAmountSpinner.removeChangeListener(this.hazeAmountListener);
        if (target != null) {
            this.sceneLayerButton.setChoiceRoot(target.getAncestorByType(Scene.class));
            this.sceneLayerButton.setExpandRoot(target.getAncestorByType(Scene.class));
            this.sceneLayerButton.setSelected(target.getSceneLayer());
            this.transitionSpinner.setValue(target.getApproachTransition());
            this.hazeColorButton.setBackground(target.getHazeColor());
            this.hazeAmountSpinner.setValue(new Double(target.getHazeAmount()));
        }
        this.transitionSpinner.addChangeListener(this.transitionListener);
        this.hazeAmountSpinner.addChangeListener(this.hazeAmountListener);
        this.graphicTable.setTarget(target);
        this.childTable.setTarget(target);
    }

    @Override
    protected JComponent getMainArea() {
        this.sceneLayerButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((SceneLocationLayer)SceneLocationLayerPanel.this.getTarget()).setSceneLayer((SceneLayer)selection);
                SceneLocationLayerPanel.this.fireTargetModified();
            }
        };
        HashSet types = new HashSet();
        types.add(SceneLayer.class);
        this.sceneLayerButton.setEnabledTypes(types);
        this.transitionSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.05));
        ((JSpinner.DefaultEditor)this.transitionSpinner.getEditor()).getTextField().setColumns(4);
        this.transitionListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SceneLocationLayer target = (SceneLocationLayer)SceneLocationLayerPanel.this.getTarget();
                if (target != null) {
                    target.setApproachTransition(((Double)SceneLocationLayerPanel.this.transitionSpinner.getValue()).floatValue());
                    SceneLocationLayerPanel.this.fireTargetModified();
                }
            }
        };
        this.hazeAmountSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.05));
        ((JSpinner.DefaultEditor)this.hazeAmountSpinner.getEditor()).getTextField().setColumns(4);
        this.hazeAmountListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SceneLocationLayer target = (SceneLocationLayer)SceneLocationLayerPanel.this.getTarget();
                if (target != null) {
                    target.setHazeAmount(((Double)SceneLocationLayerPanel.this.hazeAmountSpinner.getValue()).floatValue());
                    SceneLocationLayerPanel.this.fireTargetModified();
                }
            }
        };
        this.hazeColorButton = new JButton("Choose...");
        this.hazeColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color hazeColor = JColorChooser.showDialog(SceneLocationLayerPanel.this, "Haze Color", ((SceneLocationLayer)SceneLocationLayerPanel.this.getTarget()).getHazeColor());
                SceneLocationLayerPanel.this.hazeColorButton.setBackground(hazeColor);
                ((SceneLocationLayer)SceneLocationLayerPanel.this.getTarget()).setHazeColor(hazeColor);
            }
        });
        this.childTable = new ProjectComponentTable<SceneLocationLayer>(EnumSet.of(ProjectComponentTable.ButtonColumn.Edit, ProjectComponentTable.ButtonColumn.Del), "Graphic", true){

            @Override
            protected void getRows(SceneLocationLayer target, List<ProjectComponent> tableRows) {
                tableRows.addAll(target.getGraphics());
            }

            @Override
            protected boolean isRowDragable(int row, List<ProjectComponent> tableRows) {
                return true;
            }

            @Override
            protected boolean isRowEditable(int row, List<ProjectComponent> tableRows) {
                return true;
            }

            @Override
            protected boolean isRowRemovable(int row, List<ProjectComponent> tableRows) {
                return true;
            }

            @Override
            protected void insertRow(int row, ProjectComponent component, List<ProjectComponent> tableRows) {
                ((SceneLocationLayer)this.getTarget()).moveGraphic((LocationLayerGraphic)component, row);
                this.fireTargetModified();
            }

            @Override
            protected void removeRow(int row, List<ProjectComponent> tableRows) {
                ((SceneLocationLayer)this.getTarget()).removeChildComponent(tableRows.get(row));
                this.fireTargetModified();
            }
        };
        this.graphicTable = new LocationLayerGraphicTable();
        TargetablePanelListener tableListener = new TargetablePanelListener(){

            @Override
            public void targetModified(TargetablePanel<?> source) {
                SceneLocationLayerPanel.this.fireTargetModified();
            }

            @Override
            public void targetChanged(TargetablePanel<?> source) {
            }
        };
        this.childTable.addListener(tableListener);
        this.graphicTable.addListener(tableListener);
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("Scene Layer:", (Component)this.sceneLayerButton));
        rows.add(new LabeledRowPanel.LabeledRow("Front-Side Transition:", (Component)this.transitionSpinner));
        JPanel hazePanel = new JPanel(new BorderLayout(5, 0));
        hazePanel.add((Component)this.hazeAmountSpinner, "West");
        hazePanel.add((Component)this.hazeColorButton, "Center");
        rows.add(new LabeledRowPanel.LabeledRow("Haze:", (Component)hazePanel));
        JPanel result = new JPanel(new BorderLayout(0, 10));
        result.add((Component)new LabeledRowPanel(rows), "North");
        result.add(this.childTable, "Center");
        result.add((Component)this.graphicTable, "South");
        return result;
    }
}

