/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Reference;
import com.sodiumarc.patchwork.util.StringUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public abstract class ProjectComponentTransferHandler
extends TransferHandler {
    public void createGestureRecognizer(final JComponent c) {
        DragSource source = DragSource.getDefaultDragSource();
        source.createDefaultDragGestureRecognizer(c, 3, new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                if (!ProjectComponentTransferHandler.this.canDragSelected(c)) {
                    return;
                }
                Transferable transferable = ProjectComponentTransferHandler.this.createTransferable(c);
                dge.startDrag(null, transferable);
                ProjectComponentTransferHandler.this.exportDone(c, transferable, dge.getDragAction());
            }
        });
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        if (!info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return false;
        }
        return this.canImportComponents(info.getDropLocation(), this.getGUIDS(info.getTransferable()));
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        Set<ProjectComponent> selectedComponent = this.getExportComponents(c);
        ArrayList<String> strings = new ArrayList<String>();
        for (ProjectComponent projectComponent : selectedComponent) {
            strings.add(projectComponent.getGUID().toString());
        }
        return new StringSelection(StringUtils.toDelimitedList(strings, "\n"));
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        if (!info.isDrop()) {
            return false;
        }
        this.importComponents(info.getDropLocation(), this.getGUIDS(info.getTransferable()));
        return true;
    }

    public Set<ProjectComponent> resolve(ProjectComponent handle, Set<String> guids) {
        HashSet<ProjectComponent> result = new HashSet<ProjectComponent>();
        for (String guid : guids) {
            Reference ref = new Reference(handle, guid);
            result.add((ProjectComponent)ref.resolve());
        }
        return result;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        this.exportDone(this.getGUIDS(data), action);
    }

    protected boolean canDragSelected(JComponent c) {
        return false;
    }

    protected abstract Set<ProjectComponent> getExportComponents(JComponent var1);

    protected abstract void exportDone(Set<String> var1, int var2);

    protected boolean canImportComponents(TransferHandler.DropLocation dropLocation, Set<String> guids) {
        return true;
    }

    protected abstract void importComponents(TransferHandler.DropLocation var1, Set<String> var2);

    private Set<String> getGUIDS(Transferable t) {
        HashSet<String> guids = new HashSet<String>();
        String data = null;
        try {
            data = (String)t.getTransferData(DataFlavor.stringFlavor);
            String[] values = data.split("\n");
            for (int i = 0; i < values.length; ++i) {
                guids.add(values[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return guids;
    }
}

