/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.util.CompareUtilities;
import com.sodiumarc.patchwork.util.TargetablePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class ProjectComponentPanel<T extends ProjectComponent>
extends TargetablePanel<T> {
    private final IDFieldListener idFieldListener = new IDFieldListener();
    private final JLabel iconLabel = new JLabel();
    private final JTextField idField = new JTextField();

    public ProjectComponentPanel() {
        this(true);
    }

    public ProjectComponentPanel(boolean showHeaderLabel) {
        super(new BorderLayout(5, 5));
        this.idField.addFocusListener(this.idFieldListener);
        JPanel headerPanel = new JPanel(new BorderLayout(5, 5));
        headerPanel.setBackground(Color.WHITE);
        headerPanel.setOpaque(true);
        headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK), BorderFactory.createMatteBorder(5, 5, 5, 5, Color.WHITE)));
        headerPanel.add((Component)this.iconLabel, "West");
        headerPanel.add((Component)this.idField, "Center");
        JComponent mainArea = this.getMainArea();
        if (showHeaderLabel) {
            mainArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)headerPanel, "North");
        }
        this.add((Component)mainArea, "Center");
    }

    @Override
    protected void targetSet() {
        ProjectComponent component = (ProjectComponent)this.getTarget();
        this.iconLabel.setIcon(component == null ? null : component.getIcon());
        this.updateIDFromTarget();
    }

    protected abstract JComponent getMainArea();

    private void onIDChange() {
        ProjectComponent target = (ProjectComponent)this.getTarget();
        String newID = this.idField.getText().trim();
        if (CompareUtilities.equals(newID, target.getID())) {
            return;
        }
        if (!target.isUniqueSiblingID(newID)) {
            JOptionPane.showMessageDialog(this, "ID already in use: \"" + newID + "\"");
            return;
        }
        target.setID(newID);
        this.fireTargetModified();
    }

    private void updateIDFromTarget() {
        ProjectComponent target = (ProjectComponent)this.getTarget();
        this.idField.removeActionListener(this.idFieldListener);
        this.idField.setText(target == null ? null : target.getID());
        this.idField.addActionListener(this.idFieldListener);
        this.idField.setEnabled(target != null);
    }

    private class IDFieldListener
    implements ActionListener,
    FocusListener {
        private IDFieldListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            ProjectComponentPanel.this.onIDChange();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProjectComponentPanel.this.onIDChange();
        }
    }
}

