/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundSequence;
import com.sodiumarc.patchwork.app.scenecomposer.table.IOTypeTable;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.EnumMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PatchworkProjectPanel
extends ProjectComponentPanel<PatchworkProject> {
    private TreeChooserButton startingCardButton;
    private TreeChooserButton prologueEndStateButton;
    private TreeChooserButton epilogueBeginStateButton;
    private TreeChooserButton openingScoreButton;
    private JComboBox titleImageCombo;
    private ActionListener comboListener;
    private IOTypeTable dirTable;
    private JFileChooser dirChooser;

    public PatchworkProjectPanel() {
        this.setPreferredSize(new Dimension(500, 150));
    }

    @Override
    protected JComponent getMainArea() {
        this.startingCardButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((PatchworkProject)PatchworkProjectPanel.this.getTarget()).setStartingCard((Card)selection);
                PatchworkProjectPanel.this.fireTargetModified();
            }
        };
        this.startingCardButton.setEnabledTypes(Card.class);
        this.prologueEndStateButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((PatchworkProject)PatchworkProjectPanel.this.getTarget()).setPrologueEndState((SceneLayerState)selection);
                PatchworkProjectPanel.this.fireTargetModified();
            }
        };
        this.prologueEndStateButton.setEnabledTypes(SceneLayerState.class);
        this.epilogueBeginStateButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((PatchworkProject)PatchworkProjectPanel.this.getTarget()).setEpilogueBeginState((SceneLayerState)selection);
                PatchworkProjectPanel.this.fireTargetModified();
            }
        };
        this.epilogueBeginStateButton.setEnabledTypes(SceneLayerState.class);
        this.openingScoreButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((PatchworkProject)PatchworkProjectPanel.this.getTarget()).setOpeningScore((SoundSequence)selection);
                PatchworkProjectPanel.this.fireTargetModified();
            }
        };
        this.openingScoreButton.setEnabledTypes(SoundSequence.class);
        this.titleImageCombo = new JComboBox();
        this.comboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PatchworkProject)PatchworkProjectPanel.this.getTarget()).setTitleImageFilename((String)PatchworkProjectPanel.this.titleImageCombo.getSelectedItem());
                PatchworkProjectPanel.this.fireTargetModified();
            }
        };
        this.dirChooser = new JFileChooser();
        this.dirChooser.setFileSelectionMode(1);
        this.dirChooser.setMultiSelectionEnabled(false);
        EnumMap<IOFileType, String> defaults = new EnumMap<IOFileType, String>(IOFileType.class);
        for (IOFileType type : IOFileType.values()) {
            defaults.put(type, type.getDefaultInputDir().getAbsolutePath());
        }
        this.dirTable = new IOTypeTable(defaults);
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("Starting Card:", (Component)this.startingCardButton, true));
        rows.add(new LabeledRowPanel.LabeledRow("Prologue End State:", (Component)this.prologueEndStateButton, true));
        rows.add(new LabeledRowPanel.LabeledRow("Epilogue Begin State:", (Component)this.epilogueBeginStateButton, true));
        rows.add(new LabeledRowPanel.LabeledRow("Opening Score:", (Component)this.openingScoreButton, true));
        rows.add(new LabeledRowPanel.LabeledRow("Title Image:", (Component)this.titleImageCombo, true));
        JScrollPane scroller = new JScrollPane(this.dirTable);
        scroller.getViewport().setBackground(Color.WHITE);
        JPanel result = new JPanel(new BorderLayout(10, 10));
        result.add((Component)new LabeledRowPanel("Initial", rows), "North");
        result.add((Component)scroller, "Center");
        return result;
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        PatchworkProject target = (PatchworkProject)this.getTarget();
        if (target != null) {
            this.startingCardButton.setChoiceRoot(target.getPath().get(0));
            this.startingCardButton.setExpandRoot(target.getPath().get(0));
            this.startingCardButton.setSelected(target.getStartingCard());
            this.prologueEndStateButton.setChoiceRoot(target.getPath().get(0));
            this.prologueEndStateButton.setExpandRoot(target.getPath().get(0));
            this.prologueEndStateButton.setSelected(target.getPrologueEndState());
            this.epilogueBeginStateButton.setChoiceRoot(target.getPath().get(0));
            this.epilogueBeginStateButton.setExpandRoot(target.getPath().get(0));
            this.epilogueBeginStateButton.setSelected(target.getEpilogueBeginState());
            this.openingScoreButton.setChoiceRoot(target.getPath().get(0));
            this.openingScoreButton.setExpandRoot(target.getPath().get(0));
            this.openingScoreButton.setSelected(target.getOpeningScore());
            this.updateImageCombos(target);
        }
    }

    private void updateImageCombos(PatchworkProject target) {
        this.titleImageCombo.removeActionListener(this.comboListener);
        File animParentDir = target.getIODirectory(IOFileType.LAYER_SCANS);
        File[] files = animParentDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isDirectory() && pathname.getName().endsWith(".png");
            }
        });
        ArrayList<String> names = new ArrayList<String>(files.length);
        for (File file : files) {
            names.add(file.getName());
        }
        names.add(0, null);
        this.titleImageCombo.setModel(new DefaultComboBoxModel<Object>(names.toArray()));
        this.titleImageCombo.setSelectedItem(target.getTitleImageFilename());
        this.titleImageCombo.addActionListener(this.comboListener);
    }
}

